/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpNonSharedSettingsManager {
    private static final String STORAGE_NODE_INTERPRETER_PATH = "js.buildTools.gulp.node_interpreter";
    private static final String STORAGE_GULP_PACKAGE_DIR_PATH = "js.buildTools.gulp.gulp_package_dir";
    private static final String GULP_PACKAGE_NAME = "gulp";
    private final Project myProject;
    @NotNull
    private volatile GulpNonSharedSettings myNonSharedSettings;

    public GulpNonSharedSettingsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "<init>"));
        }
        this.myNonSharedSettings = new GulpNonSharedSettings("", "");
        this.myProject = project;
    }

    @NotNull
    public GulpNonSharedSettings get(@Nullable VirtualFile contextGulpfile) {
        String gulpPackageDirPath;
        GulpNonSharedSettings settings = this.myNonSharedSettings;
        if (!StringUtil.isEmptyOrSpaces((String)settings.getNodeInterpreterPath()) && !StringUtil.isEmptyOrSpaces((String)settings.getGulpPackageDirPath())) {
            GulpNonSharedSettings gulpNonSharedSettings = settings;
            if (gulpNonSharedSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "get"));
            }
            return gulpNonSharedSettings;
        }
        String nodeInterpreterPath = settings.getNodeInterpreterPath();
        if (StringUtil.isEmptyOrSpaces((String)nodeInterpreterPath)) {
            nodeInterpreterPath = StringUtil.notNullize((String)this.detectNodeInterpreter());
        }
        if (StringUtil.isEmptyOrSpaces((String)(gulpPackageDirPath = settings.getGulpPackageDirPath()))) {
            gulpPackageDirPath = StringUtil.notNullize((String)this.detectGulpPackageDirPath(nodeInterpreterPath, contextGulpfile));
        }
        this.myNonSharedSettings = settings = new GulpNonSharedSettings(nodeInterpreterPath, gulpPackageDirPath);
        GulpNonSharedSettings gulpNonSharedSettings = settings;
        if (gulpNonSharedSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "get"));
        }
        return gulpNonSharedSettings;
    }

    @Nullable
    private String detectNodeInterpreter() {
        File nodeInterpreterFile;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String nodeInterpreterPath = propertiesComponent.getValue(STORAGE_NODE_INTERPRETER_PATH);
        if (StringUtil.isEmptyOrSpaces((String)nodeInterpreterPath) && (nodeInterpreterFile = NodeDetectionUtil.findInterpreterInPath()) != null) {
            nodeInterpreterPath = nodeInterpreterFile.getAbsolutePath();
        }
        return nodeInterpreterPath;
    }

    @Nullable
    private String detectGulpPackageDirPath(@NotNull String nodeInterpreterPath, @Nullable VirtualFile contextGulpfile) {
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "detectGulpPackageDirPath"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String gulpPackageDirPath = propertiesComponent.getValue(STORAGE_GULP_PACKAGE_DIR_PATH);
        if (StringUtil.isEmptyOrSpaces((String)gulpPackageDirPath)) {
            ArrayList list = ContainerUtil.newArrayList();
            NodeSettings nodeSettings = null;
            if (!StringUtil.isEmptyOrSpaces((String)nodeInterpreterPath)) {
                nodeSettings = new NodeSettings(nodeInterpreterPath);
            }
            VirtualFile requester = contextGulpfile != null ? contextGulpfile : this.myProject.getBaseDir();
            NodeModuleSearchUtil.findModulesWithName(list, GULP_PACKAGE_NAME, requester, nodeSettings, true);
            for (CompletionModuleInfo moduleInfo : list) {
                VirtualFile file = moduleInfo.getVirtualFile();
                if (file == null) continue;
                gulpPackageDirPath = FileUtil.toSystemDependentName((String)file.getPath());
            }
        }
        return gulpPackageDirPath;
    }

    public void set(@NotNull String nodeInterpreterPath, @NotNull String gulpPackageDirPath) {
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "set"));
        }
        if (gulpPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDirPath", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "set"));
        }
        this.myNonSharedSettings = new GulpNonSharedSettings(nodeInterpreterPath, gulpPackageDirPath);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(STORAGE_NODE_INTERPRETER_PATH, nodeInterpreterPath);
        propertiesComponent.setValue(STORAGE_GULP_PACKAGE_DIR_PATH, gulpPackageDirPath);
    }

    @Nullable
    private NodeSettings getNodeSettings() {
        String nodeInterpreterPath = PropertiesComponent.getInstance((Project)this.myProject).getValue(STORAGE_NODE_INTERPRETER_PATH);
        if (!StringUtil.isEmptyOrSpaces((String)nodeInterpreterPath)) {
            return new NodeSettings(nodeInterpreterPath);
        }
        File nodeInterpreterFile = NodeDetectionUtil.findInterpreterInPath();
        if (nodeInterpreterFile != null) {
            return new NodeSettings(nodeInterpreterFile.getAbsolutePath());
        }
        return null;
    }

    @NotNull
    public List<String> detectAllGulpPackageDirs(@Nullable VirtualFile contextGulpfile) {
        ArrayList modules = ContainerUtil.newArrayList();
        NodeSettings nodeSettings = this.getNodeSettings();
        VirtualFile requester = contextGulpfile != null ? contextGulpfile : this.myProject.getBaseDir();
        NodeModuleSearchUtil.findModulesWithName(modules, GULP_PACKAGE_NAME, requester, nodeSettings, true);
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "detectAllGulpPackageDirs"));
        }
        return arrayList;
    }

    @NotNull
    public static GulpNonSharedSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "getInstance"));
        }
        GulpNonSharedSettingsManager gulpNonSharedSettingsManager = (GulpNonSharedSettingsManager)ServiceManager.getService((Project)project, GulpNonSharedSettingsManager.class);
        if (gulpNonSharedSettingsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "getInstance"));
        }
        return gulpNonSharedSettingsManager;
    }
}

