/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunConfigurationProducer
extends RunConfigurationProducer<GulpRunConfiguration> {
    protected GulpRunConfigurationProducer() {
        super((ConfigurationType)GulpConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(GulpRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        GulpRunSettings runSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, sourceElement);
        if (runSettings == null) {
            return false;
        }
        GulpRunConfigurationProducer.setupConfigurationFromSettings(configuration, runSettings);
        return true;
    }

    public static void setupConfigurationFromSettings(@NotNull GulpRunConfiguration configuration, @NotNull GulpRunSettings runSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer", "setupConfigurationFromSettings"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer", "setupConfigurationFromSettings"));
        }
        configuration.setRunSettings(runSettings);
        configuration.setName(GulpRunConfigurationProducer.buildName(runSettings.getTasks()));
    }

    public boolean isConfigurationFromContext(GulpRunConfiguration configuration, ConfigurationContext context) {
        GulpRunSettings thisRunSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, null);
        if (thisRunSettings == null) {
            return false;
        }
        return GulpService.getInstance().isConfigurationMatched((RunConfiguration)configuration, thisRunSettings);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    @Nullable
    private static GulpRunSettings createRunSettingsFromContext(@NotNull GulpRunSettings templateRunSettings, @NotNull ConfigurationContext context, @Nullable Ref<PsiElement> sourceElement) {
        JSFile leastEnclosingElement;
        if (templateRunSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRunSettings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer", "createRunSettingsFromContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer", "createRunSettingsFromContext"));
        }
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        JSFile psiGulpfile = GulpRunConfigurationProducer.getGulpfile(element);
        if (psiGulpfile == null) {
            return null;
        }
        VirtualFile virtualGulpfile = psiGulpfile.getVirtualFile();
        if (virtualGulpfile == null) {
            return null;
        }
        Pair<String, JSCallExpression> taskPair = GulpfilePsiStructure.findEnclosingTask(element, psiGulpfile);
        GulpRunSettings.Builder builder = new GulpRunSettings.Builder(templateRunSettings);
        builder.setGulpfilePath(FileUtil.toSystemDependentName((String)virtualGulpfile.getPath()));
        if (taskPair != null) {
            builder.setTasks(Collections.singletonList(taskPair.getFirst()));
            leastEnclosingElement = (PsiElement)taskPair.getSecond();
        } else {
            builder.setTasks(Collections.singletonList("default"));
            leastEnclosingElement = psiGulpfile;
        }
        if (sourceElement != null) {
            sourceElement.set((Object)leastEnclosingElement);
        }
        return builder.build();
    }

    @Nullable
    private static JSFile getGulpfile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer", "getGulpfile"));
        }
        JSFile jsFile = element instanceof PsiFile ? (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class) : (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        if (jsFile != null && GulpService.getInstance().isBuildfileName(jsFile.getName())) {
            return jsFile;
        }
        return null;
    }

    private static String buildName(@NotNull List<String> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer", "buildName"));
        }
        if (tasks.isEmpty()) {
            return "default";
        }
        return StringUtil.join(tasks, (String)", ");
    }
}

