/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBuildToolPackageJson", storages={@Storage(file="$WORKSPACE_FILE$")})
public class PackageJsonFileManager
extends JsbtFileManager
implements PersistentStateComponent<Element> {
    public static final String PACKAGE_JSON = "package.json";
    private static final String DETECTION_DONE_ATTR = "detection-done";
    private static final String PACKAGE_JSON_TAG = "package-json";

    public PackageJsonFileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/PackageJsonFileManager", "<init>"));
        }
        super(project, NpmScriptsService.getInstance());
    }

    @NotNull
    public static PackageJsonFileManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/PackageJsonFileManager", "getInstance"));
        }
        PackageJsonFileManager packageJsonFileManager = (PackageJsonFileManager)ServiceManager.getService((Project)project, PackageJsonFileManager.class);
        if (packageJsonFileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonFileManager", "getInstance"));
        }
        return packageJsonFileManager;
    }

    @Override
    @Nullable
    public NpmScriptsStructure getCachedStructure(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/PackageJsonFileManager", "getCachedStructure"));
        }
        return (NpmScriptsStructure)super.getCachedStructure(packageJson);
    }

    @Override
    protected boolean shouldSaveAllDocumentBeforeFetch() {
        return false;
    }

    @Nullable
    public Element getState() {
        Element parent = new Element("package-json-files");
        if (this.isDetectionDone()) {
            parent.setAttribute(DETECTION_DONE_ATTR, Boolean.TRUE.toString());
        }
        List paths = ContainerUtil.map(this.getBuildfiles(), (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return file.getPath();
            }
        });
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)parent, (String)PACKAGE_JSON_TAG, (List)paths);
        return parent;
    }

    public void loadState(Element parent) {
        if (parent == null) {
            return;
        }
        this.clearAllBuildfiles();
        if (Boolean.parseBoolean(parent.getAttributeValue(DETECTION_DONE_ATTR))) {
            this.setDetectionDone();
        }
        List paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)parent, (String)PACKAGE_JSON_TAG);
        for (String path : paths) {
            VirtualFile packageJson;
            if (!StringUtil.isNotEmpty((String)path) || (packageJson = LocalFileSystem.getInstance().findFileByPath(path)) == null || !packageJson.isValid() || packageJson.isDirectory()) continue;
            this.addBuildfileStructure(new NpmScriptsStructure(packageJson));
        }
    }
}

