/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonUtil {
    public static final String FILE_NAME = "package.json";
    private static final String NODE_MODULES = "node_modules";
    private static final Key<CachedPackageJsonData> CACHED_PACKAGE_JSON_DATA_KEY = Key.create((String)"js.cached.package-json.data");

    protected PackageJsonUtil() {
    }

    public static boolean isPackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageJsonFile"));
        }
        PsiFile file = element.getContainingFile();
        return file != null && PackageJsonUtil.isPackageJsonFile(file);
    }

    public static boolean isPackageJsonFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageJsonFile"));
        }
        return JsonLanguage.INSTANCE.equals(file.getLanguage()) && FILE_NAME.equals(file.getName());
    }

    public static boolean isPackageJsonFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageJsonFile"));
        }
        return !file.isDirectory() && StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)file.getNameSequence());
    }

    @Nullable
    public static JsonProperty getProperty(@NotNull PsiElement position) {
        JsonObject object;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getProperty"));
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)position, JsonProperty.class, (boolean)false);
        if (property != null && (object = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            return property;
        }
        return null;
    }

    public static boolean isInsideIndirectDependency(@NotNull VirtualFile file) {
        VirtualFile packageJson;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isInsideIndirectDependency"));
        }
        VirtualFile moduleRoot = NodeModuleSearchUtil.findDependencyRoot(file);
        if (moduleRoot == null) {
            return false;
        }
        VirtualFile nodeModulesDir = moduleRoot.getParent();
        if (nodeModulesDir == null || !StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)nodeModulesDir.getNameSequence())) {
            throw new AssertionError((Object)("Parent directory is expected to be node_modules, but actual is " + nodeModulesDir));
        }
        if (NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir) != null) {
            return true;
        }
        VirtualFile parent = nodeModulesDir.getParent();
        if (parent != null && (packageJson = parent.findChild(FILE_NAME)) != null && packageJson.isValid() && !packageJson.isDirectory()) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
            boolean directDependency = data.isDependencyOfAnyType(moduleRoot.getName());
            return !directDependency;
        }
        return false;
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        long documentTimeStamp;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(packageJson);
        CachedPackageJsonData cached = (CachedPackageJsonData)CACHED_PACKAGE_JSON_DATA_KEY.get((UserDataHolder)packageJson);
        long l = documentTimeStamp = document != null ? document.getModificationStamp() : -1L;
        if (cached == null || cached.getFileTimeStamp() != packageJson.getTimeStamp() || cached.getDocumentTimeStamp() != documentTimeStamp) {
            PackageJsonData data = PackageJsonData.parse(packageJson, document);
            cached = new CachedPackageJsonData(data, packageJson.getTimeStamp(), documentTimeStamp);
            CACHED_PACKAGE_JSON_DATA_KEY.set((UserDataHolder)packageJson, (Object)cached);
        }
        PackageJsonData packageJsonData = cached.getData();
        if (packageJsonData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        return packageJsonData;
    }

    private static class CachedPackageJsonData {
        private final PackageJsonData myData;
        private final long myFileTimeStamp;
        private final long myDocumentTimeStamp;

        /*
         * WARNING - void declaration
         */
        public CachedPackageJsonData(@NotNull PackageJsonData data, long fileTimeStamp, long l) {
            void documentTimeStamp;
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData", "<init>"));
            }
            this.myData = data;
            this.myFileTimeStamp = fileTimeStamp;
            this.myDocumentTimeStamp = documentTimeStamp;
        }

        @NotNull
        public PackageJsonData getData() {
            PackageJsonData packageJsonData = this.myData;
            if (packageJsonData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData", "getData"));
            }
            return packageJsonData;
        }

        public long getFileTimeStamp() {
            return this.myFileTimeStamp;
        }

        public long getDocumentTimeStamp() {
            return this.myDocumentTimeStamp;
        }
    }
}

