/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunConfigurationProducer
extends RunConfigurationProducer<NpmRunConfiguration> {
    protected NpmRunConfigurationProducer() {
        super((ConfigurationType)NpmConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(NpmRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        NpmRunSettings runSettings = NpmRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, sourceElement);
        if (runSettings == null) {
            return false;
        }
        NpmRunConfigurationProducer.setupConfigurationFromSettings(configuration, runSettings);
        return true;
    }

    public boolean isConfigurationFromContext(NpmRunConfiguration configuration, ConfigurationContext context) {
        NpmRunSettings thisRunSettings = NpmRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, null);
        if (thisRunSettings == null) {
            return false;
        }
        return NpmScriptsService.getInstance().isConfigurationMatched((RunConfiguration)configuration, thisRunSettings);
    }

    public static void setupConfigurationFromSettings(@NotNull NpmRunConfiguration configuration, @NotNull NpmRunSettings runSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer", "setupConfigurationFromSettings"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer", "setupConfigurationFromSettings"));
        }
        configuration.setRunSettings(runSettings);
        configuration.setGeneratedName();
    }

    @Nullable
    private static NpmRunSettings createRunSettingsFromContext(@NotNull NpmRunSettings templateRunSettings, @NotNull ConfigurationContext context, @Nullable Ref<PsiElement> sourceElement) {
        if (templateRunSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRunSettings", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer", "createRunSettingsFromContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer", "createRunSettingsFromContext"));
        }
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        JsonFile psiPackageJson = NpmRunConfigurationProducer.getPackageJson(element);
        if (psiPackageJson == null) {
            return null;
        }
        VirtualFile virtualPackageJson = psiPackageJson.getVirtualFile();
        if (virtualPackageJson == null) {
            return null;
        }
        JsonProperty scriptProperty = NpmRunConfigurationProducer.findContainingScriptProperty(element);
        if (scriptProperty == null) {
            return null;
        }
        NpmRunSettings.Builder builder = NpmRunSettings.builder(templateRunSettings);
        builder.setPackageJsonPath(virtualPackageJson.getPath());
        builder.setCommand(NpmCommand.RUN_SCRIPT);
        builder.setScriptNames(Collections.singletonList(scriptProperty.getName()));
        if (sourceElement != null) {
            sourceElement.set((Object)scriptProperty);
        }
        return builder.build();
    }

    @Nullable
    private static JsonProperty findContainingScriptProperty(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer", "findContainingScriptProperty"));
        }
        JsonProperty firstAncestor = NpmRunConfigurationProducer.findFirstJsonProperty(element);
        if (firstAncestor == null) {
            return null;
        }
        JsonObject parentObj = (JsonObject)ObjectUtils.tryCast((Object)firstAncestor.getParent(), JsonObject.class);
        if (parentObj == null) {
            return null;
        }
        JsonProperty scriptsProperty = (JsonProperty)ObjectUtils.tryCast((Object)parentObj.getParent(), JsonProperty.class);
        if (scriptsProperty == null) {
            return null;
        }
        return firstAncestor;
    }

    @Nullable
    private static JsonProperty findFirstJsonProperty(@Nullable PsiElement element) {
        while (element != null) {
            if (element instanceof JsonProperty) {
                return (JsonProperty)element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    private static JsonFile getPackageJson(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer", "getPackageJson"));
        }
        JsonFile file = element instanceof JsonFile ? (JsonFile)ObjectUtils.tryCast((Object)element, JsonFile.class) : (JsonFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JsonFile.class);
        if (file != null && PackageJsonUtil.isPackageJsonFile((PsiFile)file)) {
            return file;
        }
        return null;
    }
}

