/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class NpmRunConfigurationUtil {
    private NpmRunConfigurationUtil() {
    }

    public static void check(@NotNull NpmRunSettings settings, @NotNull String nodeInterpreterPath) throws RuntimeConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil", "check"));
        }
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil", "check"));
        }
        String packageJsonPath = settings.getPackageJsonPath();
        if (packageJsonPath.isEmpty()) {
            throw new RuntimeConfigurationError("Please specify package.json");
        }
        File packageJson = new File(packageJsonPath);
        if (!packageJson.isAbsolute() || !packageJson.isFile()) {
            throw new RuntimeConfigurationError("Please specify package.json correctly");
        }
        if (settings.getCommand() == NpmCommand.RUN_SCRIPT && settings.getScriptNames().isEmpty()) {
            throw new RuntimeConfigurationError("Please specify npm scripts to run");
        }
        if (nodeInterpreterPath.isEmpty()) {
            throw new RuntimeConfigurationError("Please specify Node.js interpreter");
        }
        File nodeInterpreter = new File(nodeInterpreterPath);
        if (!nodeInterpreter.isAbsolute() || !nodeInterpreter.isFile()) {
            throw new RuntimeConfigurationError("Please specify Node.js interpreter correctly");
        }
    }
}

