/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final NpmRunSettings myRunSettings;
    private final File myNodeInterpreter;
    private final File myNpmExecutable;
    private final ExecutionEnvironment myEnvironment;

    public NpmRunProfileState(@NotNull NpmRunSettings runSettings, @NotNull NodeSettings interpreter, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "<init>"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "<init>"));
        }
        this.myNodeInterpreter = new File(interpreter.getInterpreterPath());
        if (!this.myNodeInterpreter.isFile()) {
            throw new ExecutionException("No such Node.js interpreter: " + interpreter.getInterpreterPath());
        }
        String npmExePath = interpreter.getGuessedNpmExePath();
        if (npmExePath == null) {
            throw new ExecutionException("Failed to find npm for " + interpreter.getInterpreterPath());
        }
        this.myNpmExecutable = new File(npmExePath);
        if (!this.myNpmExecutable.isFile()) {
            throw new ExecutionException("No such npm executable: " + npmExePath);
        }
        this.myRunSettings = runSettings;
        this.myEnvironment = environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "execute"));
        }
        return this.execute(-1);
    }

    @Override
    @Nullable
    public ExecutionResult executeWithDebugPort(int debugPort) throws ExecutionException {
        return this.execute(debugPort);
    }

    @Nullable
    private ExecutionResult execute(int debugPort) throws ExecutionException {
        ConsoleView console;
        GeneralCommandLine commandLine = this.createCommandLine(debugPort);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, true);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        if (debugPort != -1) {
            console = null;
        } else {
            console = this.createConsole(commandLine.getWorkDirectory());
            console.attachToProcess((ProcessHandler)processHandler);
            this.foldCommandLine(console, (ProcessHandler)processHandler);
        }
        return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
    }

    @NotNull
    private ConsoleView createConsole(@Nullable File cwd) {
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(this.myEnvironment.getProject());
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject()));
        builder.addFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject()));
        builder.addFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = builder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "createConsole"));
        }
        return consoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(int debugPort) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        File workingDirectory = new File(this.myRunSettings.getPackageJsonPath()).getParentFile();
        CommandLineUtil.setWorkingDirectoryAndPWD((GeneralCommandLine)commandLine, (String)workingDirectory.getAbsolutePath());
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.getEnvironment().put("FORCE_COLOR", "true");
        File npmJsMainFile = NodeCommandLineUtil.findNpmJsMainFile(this.myNodeInterpreter, this.myNpmExecutable);
        if (npmJsMainFile != null) {
            String nodeOptions;
            commandLine.setExePath(this.myNodeInterpreter.getAbsolutePath());
            if (debugPort > 0) {
                commandLine.getEnvironment().put("DEBUG_NODE_OPTION", "--debug-brk=" + debugPort);
            }
            if (StringUtil.isNotEmpty((String)(nodeOptions = this.myRunSettings.getNodeOptions().trim()))) {
                commandLine.addParameters(ParametersList.parse((String)nodeOptions));
            }
            commandLine.addParameters(new String[]{npmJsMainFile.getAbsolutePath()});
        } else {
            commandLine.setExePath(this.myNpmExecutable.getAbsolutePath());
        }
        commandLine.addParameter(this.myRunSettings.getCommand().getCliOption());
        String arguments = this.myRunSettings.getArguments().trim();
        if (NpmCommand.RUN_SCRIPT == this.myRunSettings.getCommand()) {
            commandLine.addParameters(this.myRunSettings.getScriptNames());
            if (!arguments.isEmpty()) {
                commandLine.addParameter("--");
            }
        }
        if (!arguments.isEmpty()) {
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "foldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "foldCommandLine"));
        }
        BaseOSProcessHandler osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class);
        if (osProcessHandler != null) {
            ArrayList commandLine = ContainerUtil.newArrayList((Object[])new String[]{"npm"});
            commandLine.add(this.myRunSettings.getCommand().getCliOption());
            String arguments = this.myRunSettings.getArguments().trim();
            if (NpmCommand.RUN_SCRIPT == this.myRunSettings.getCommand()) {
                commandLine.addAll(this.myRunSettings.getScriptNames());
                if (!arguments.isEmpty()) {
                    commandLine.add("--");
                }
            }
            if (!arguments.isEmpty()) {
                commandLine.add(arguments);
            }
            NpmRunProfileState.doFoldCommandLine(consoleView, osProcessHandler, ParametersListUtil.join((List)commandLine));
        }
    }

    private static void doFoldCommandLine(final @NotNull ConsoleView consoleView, final @NotNull BaseOSProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "doFoldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "doFoldCommandLine"));
        }
        if (foldedCommandLineText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedCommandLineText", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "doFoldCommandLine"));
        }
        final String commandLine = processHandler.getCommandLine();
        if (commandLine != null) {
            if (processHandler.isStartNotified()) {
                JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(ProcessEvent event) {
                        processHandler.removeProcessListener((ProcessListener)this);
                        JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
                    }
                });
            }
        }
    }
}

