/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.compiler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResultContainer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSLanguageCompilerResult {
    public static final String ERROR_CATEGORY = "error";
    private static final String FILENAME = "filename";
    private static final String MESSAGE = "message";
    private static final String LINE = "line";
    private static final String COLUMN = "column";
    private static final String CATEGORY = "category";
    public static final String EMIT_FILES = "emitFiles";
    public static final String COMPILED_FILES = "compiledFiles";
    public final int myColumn;
    public final int myLine;
    public final String myErrorText;
    public final String myCategory;
    public final String myFileAbsoluteSystemDependPath;

    @NotNull
    public static JSLanguageCompilerResultContainer build(@NotNull JsonElement parse) {
        if (parse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parse", "com/intellij/lang/javascript/compiler/JSLanguageCompilerResult", "build"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        JsonObject object = parse.getAsJsonObject();
        if (object.has(ERROR_CATEGORY)) {
            String errorText = object.get(ERROR_CATEGORY).getAsString();
            JSLanguageCompilerResultContainer jSLanguageCompilerResultContainer = new JSLanguageCompilerResultContainer((List<JSLanguageCompilerResult>)JSLanguageCompilerResult.buildError(errorText), null);
            if (jSLanguageCompilerResultContainer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/compiler/JSLanguageCompilerResult", "build"));
            }
            return jSLanguageCompilerResultContainer;
        }
        JsonElement compiledFilesObject = object.get(COMPILED_FILES);
        ArrayList compiledFiles = null;
        if (compiledFilesObject != null && !compiledFilesObject.isJsonNull() && compiledFilesObject.isJsonArray()) {
            compiledFiles = ContainerUtil.newArrayList();
            for (JsonElement element : compiledFilesObject.getAsJsonArray()) {
                compiledFiles.add(element.getAsString());
            }
        }
        JsonElement dataArray = object.get("dataArray");
        assert (dataArray.isJsonArray());
        for (JsonElement element : dataArray.getAsJsonArray()) {
            assert (element.isJsonObject());
            JsonObject errorRow = element.getAsJsonObject();
            JsonElement fileNameElement = errorRow.get(FILENAME);
            JsonElement errorMessageElement = errorRow.get(MESSAGE);
            JsonElement lineElement = errorRow.get(LINE);
            JsonElement columnElement = errorRow.get(COLUMN);
            JsonElement categoryElement = errorRow.get(CATEGORY);
            result.add(new JSLanguageCompilerResult(errorMessageElement == null || errorMessageElement.isJsonNull() ? null : errorMessageElement.getAsString(), fileNameElement == null || fileNameElement.isJsonNull() ? null : fileNameElement.getAsString(), categoryElement == null || categoryElement.isJsonNull() ? null : categoryElement.getAsString(), lineElement == null || lineElement.isJsonNull() ? 0 : lineElement.getAsInt(), columnElement == null || columnElement.isJsonNull() ? 0 : columnElement.getAsInt()));
        }
        JSLanguageCompilerResultContainer jSLanguageCompilerResultContainer = new JSLanguageCompilerResultContainer(result, compiledFiles);
        if (jSLanguageCompilerResultContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/compiler/JSLanguageCompilerResult", "build"));
        }
        return jSLanguageCompilerResultContainer;
    }

    public static ImmutableList<JSLanguageCompilerResult> buildError(String errorText) {
        return ContainerUtil.immutableList((Object[])new JSLanguageCompilerResult[]{new JSLanguageCompilerResult(errorText, null, null, 0, 0)});
    }

    public JSLanguageCompilerResult(String errorText, String fileAbsolutePath, String category, int line, int column) {
        this.myCategory = category;
        this.myColumn = column - 1;
        this.myLine = line - 1;
        this.myErrorText = errorText;
        this.myFileAbsoluteSystemDependPath = fileAbsolutePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLanguageCompilerResult result = (JSLanguageCompilerResult)o;
        if (this.myColumn != result.myColumn) {
            return false;
        }
        if (this.myLine != result.myLine) {
            return false;
        }
        if (this.myErrorText != null ? !this.myErrorText.equals(result.myErrorText) : result.myErrorText != null) {
            return false;
        }
        if (this.myCategory != null ? !this.myCategory.equals(result.myCategory) : result.myCategory != null) {
            return false;
        }
        return !(this.myFileAbsoluteSystemDependPath != null ? !this.myFileAbsoluteSystemDependPath.equals(result.myFileAbsoluteSystemDependPath) : result.myFileAbsoluteSystemDependPath != null);
    }

    public int hashCode() {
        int result = this.myColumn;
        result = 31 * result + this.myLine;
        result = 31 * result + (this.myErrorText != null ? this.myErrorText.hashCode() : 0);
        result = 31 * result + (this.myCategory != null ? this.myCategory.hashCode() : 0);
        result = 31 * result + (this.myFileAbsoluteSystemDependPath != null ? this.myFileAbsoluteSystemDependPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TypeScriptCompilerResult{myColumn=" + this.myColumn + ", myLine=" + this.myLine + ", myErrorText='" + this.myErrorText + '\'' + ", myCategory='" + this.myCategory + '\'' + ", myFileAbsoluteSystemDependPath='" + this.myFileAbsoluteSystemDependPath + '\'' + '}';
    }
}

