/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.compiler;

import com.google.gson.Gson;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.compiler.JSCompilerCommandResultProcessor;
import com.intellij.lang.javascript.compiler.JSCompilerCompileResultProcessor;
import com.intellij.lang.javascript.compiler.JSLanguageCompileInfo;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResult;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResultContainer;
import com.intellij.lang.javascript.compiler.JSLanguageExternalCompiler;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerAnswer;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerAnswerConsumer;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerCommand;
import com.intellij.lang.javascript.compiler.protocol.JSLanguageCompilerProtocol;
import com.intellij.lang.javascript.compiler.ui.JSLanguageCompilerToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.UIUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageExternalCompilerImpl
implements JSLanguageExternalCompiler {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    private static final Gson GSON = new Gson();
    private final Object myLock;
    private final ExecutorService myExecutorService;
    private ProcessHandler myProcessHandler;
    private final JSLanguageCompilerProtocol myCompilerProtocol;
    private final Map<String, Long> myCompileTimeStamps;
    private final Map<Object, JSLanguageCompilerResultContainer> myCompileResults;
    private final Project myProject;
    private volatile String myStartErrorMessage;
    @Nullable
    private final JSLanguageCompilerToolWindowManager myErrorToolWindowManager;
    @NotNull
    private final LowMemoryWatcher myLowMemoryWatcher;
    private volatile JSLanguageExternalCompiler.State myState;

    @Override
    @NotNull
    public JSLanguageExternalCompiler.State getState() {
        JSLanguageExternalCompiler.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "getState"));
        }
        return state;
    }

    public JSLanguageExternalCompilerImpl(@NotNull Project project, @NotNull JSLanguageCompilerProtocol compilerProtocol, @Nullable JSLanguageCompilerToolWindowManager manager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "<init>"));
        }
        if (compilerProtocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerProtocol", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myExecutorService = Executors.newSingleThreadExecutor(ConcurrencyUtil.newNamedThreadFactory((String)"JS external compiler"));
        this.myCompileTimeStamps = ContainerUtil.newHashMap();
        this.myCompileResults = ContainerUtil.newHashMap();
        this.myState = JSLanguageExternalCompiler.State.STARTING;
        this.myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                JSLanguageExternalCompilerImpl.this.resetCaches();
            }
        });
        this.myProject = project;
        this.myErrorToolWindowManager = manager;
        this.myCompilerProtocol = compilerProtocol;
        this.init();
    }

    @Override
    public void resetCaches() {
        this.myCompileResults.clear();
        this.myCompileTimeStamps.clear();
    }

    public void init() {
        LOGGER.debug("Submit init action to thread pool");
        this.myExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Start service in thread pool");
                    JSLanguageExternalCompilerImpl.this.startCompiler();
                    if (LOGGER.isDebugEnabled() && JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager != null) {
                        LOGGER.debug("Compiler service successfully started");
                    }
                }
                catch (Throwable e) {
                    JSLanguageExternalCompilerImpl.this.myStartErrorMessage = e.getLocalizedMessage();
                }
                finally {
                    JSLanguageExternalCompilerImpl.this.createUI();
                }
            }
        });
    }

    private void createUI() {
        if (this.myProject.isDisposed()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProcessHandler handler;
                        Object object = JSLanguageExternalCompilerImpl.this.myLock;
                        synchronized (object) {
                            handler = JSLanguageExternalCompilerImpl.this.myProcessHandler;
                        }
                        if (JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager != null) {
                            if (handler == null || JSLanguageExternalCompilerImpl.this.getState() != JSLanguageExternalCompiler.State.STARTED) {
                                JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager.logProjectErrors(JSLanguageCompilerResult.buildError(String.format("Cannot start compiler process%s", JSLanguageExternalCompilerImpl.this.myStartErrorMessage == null ? "" : ": " + JSLanguageExternalCompilerImpl.this.myStartErrorMessage)), true);
                            } else {
                                JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager.cleanProjectErrorsPanel();
                                JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager.connectToProcessHandler(handler);
                            }
                        }
                    }
                }, ModalityState.defaultModalityState());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCompiler() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                LOGGER.debug("Creating OS Handler");
                this.myProcessHandler = this.myCompilerProtocol.createCompilerProcessAndConnection();
                if (this.myProcessHandler == null) {
                    this.myState = JSLanguageExternalCompiler.State.ERROR_OR_TIMEOUT;
                    this.myStartErrorMessage = this.myCompilerProtocol.getInitializeError();
                    return;
                }
                this.myState = JSLanguageExternalCompiler.State.STARTED;
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDERR) {
                            LOGGER.debug("TS COMPILER ERROR: " + event.getText());
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            LOGGER.debug("TS COMPILER OUT: " + event.getText());
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        if (JSLanguageExternalCompilerImpl.this.myState == JSLanguageExternalCompiler.State.STARTED || JSLanguageExternalCompilerImpl.this.myState == JSLanguageExternalCompiler.State.STARTING) {
                            JSLanguageExternalCompilerImpl.this.myState = JSLanguageExternalCompiler.State.ERROR_OR_TIMEOUT;
                        }
                    }
                });
                LOGGER.debug("OS Handler created successfully");
            }
            catch (Exception e) {
                this.myState = JSLanguageExternalCompiler.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = e.getLocalizedMessage();
                LOGGER.debug("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.myProcessHandler != null && this.myState == JSLanguageExternalCompiler.State.ERROR_OR_TIMEOUT) {
                    this.stopCompiler();
                }
            }
        }
    }

    public void dispose() {
        this.stopCompiler();
    }

    @Override
    @Nullable
    public Future<JSLanguageCompilerResultContainer> compile(final @NotNull JSLanguageCompileInfo input, final @NotNull JSCompilerCompileResultProcessor processor) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "compile"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "compile"));
        }
        return this.myExecutorService.submit(new Callable<JSLanguageCompilerResultContainer>(){

            @Override
            public JSLanguageCompilerResultContainer call() throws Exception {
                Thread.currentThread().setName("JS Language Compiler thread");
                try {
                    JSLanguageCompilerResultContainer result;
                    if (JSLanguageExternalCompilerImpl.this.myState != JSLanguageExternalCompiler.State.STARTED) {
                        return null;
                    }
                    long startTime = System.currentTimeMillis();
                    Object cachingKey = input.getCacheKey();
                    if (cachingKey != null && input.shouldGetValueFromCache(JSLanguageExternalCompilerImpl.this.myCompileTimeStamps) && (result = (JSLanguageCompilerResultContainer)JSLanguageExternalCompilerImpl.this.myCompileResults.get(cachingKey)) != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Used compiling cache " + input);
                        }
                        JSLanguageExternalCompilerImpl.this.showErrors((ImmutableList<JSLanguageCompilerResult>)result.getCompiledResults(), input);
                        return result;
                    }
                    JSLanguageCompilerCommand command = input.updateCompileTimeStampsAndReturnCommand(JSLanguageExternalCompilerImpl.this.myCompileTimeStamps);
                    if (command == null) {
                        LOGGER.debug("Skip compiling by timestamp" + input);
                        return null;
                    }
                    JSLanguageCompilerAnswer answer = JSLanguageExternalCompilerImpl.this.awaitCommand(command.getCommand(), command);
                    if (answer == null || answer.getElement().has("noInfo")) {
                        LOGGER.debug("There is no compiler result");
                        if (cachingKey != null) {
                            JSLanguageExternalCompilerImpl.this.myCompileResults.remove(cachingKey);
                        }
                        return null;
                    }
                    JSLanguageCompilerResultContainer result2 = processor.process(answer);
                    if (cachingKey != null) {
                        if (input.shouldSaveValueToCache()) {
                            JSLanguageExternalCompilerImpl.this.myCompileResults.put(cachingKey, result2);
                        } else {
                            JSLanguageExternalCompilerImpl.this.myCompileResults.remove(cachingKey);
                        }
                    }
                    JSLanguageExternalCompilerImpl.this.showErrors((ImmutableList<JSLanguageCompilerResult>)result2.getCompiledResults(), input);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Total compile time, millis: " + (System.currentTimeMillis() - startTime));
                    }
                    return result2;
                }
                catch (Throwable err) {
                    LOGGER.error(err.getMessage(), err);
                    return null;
                }
            }
        });
    }

    @Override
    public void sendCommandToCompiler(final @NotNull JSLanguageCompilerCommand command, final @NotNull JSCompilerCommandResultProcessor processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "sendCommandToCompiler"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "sendCommandToCompiler"));
        }
        this.myExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                JSLanguageCompilerAnswer answer = JSLanguageExternalCompilerImpl.this.awaitCommand(command.getCommand(), command);
                if (answer != null) {
                    processor.process(answer);
                }
            }
        });
    }

    private void showErrors(final ImmutableList<JSLanguageCompilerResult> result, JSLanguageCompileInfo input) {
        if (input.shouldShowErrorsInToolWindow()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (null != JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager) {
                        JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager.logCurrentErrors((ImmutableList<JSLanguageCompilerResult>)result, false);
                    }
                }
            });
        }
    }

    private JSLanguageCompilerAnswer awaitCommand(@NotNull String command, @NotNull Object data) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "awaitCommand"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/compiler/JSLanguageExternalCompilerImpl", "awaitCommand"));
        }
        try {
            String json = GSON.toJson(data);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Await " + json);
            }
            final CountDownLatch latch = new CountDownLatch(1);
            final Ref ref = new Ref();
            this.sendData(command, json, new JSLanguageCompilerAnswerConsumer(){

                @Override
                public void consume(JSLanguageCompilerAnswer message) {
                    ref.set((Object)message);
                    latch.countDown();
                }
            });
            latch.await(1L, TimeUnit.MINUTES);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Compiler answer: " + ref.get());
            }
            return (JSLanguageCompilerAnswer)ref.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable err) {
            LOGGER.error(err.getMessage(), err);
        }
        return null;
    }

    private void sendData(String command, String dataChunk, JSLanguageCompilerAnswerConsumer consumer) {
        this.myCompilerProtocol.writeWithCallback(command, dataChunk, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCompiler() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == JSLanguageExternalCompiler.State.DISPOSED) {
                return;
            }
            this.myState = JSLanguageExternalCompiler.State.DISPOSED;
            this.myExecutorService.shutdownNow();
            try {
                this.myExecutorService.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.myLowMemoryWatcher.stop();
            Disposer.dispose((Disposable)this.myCompilerProtocol);
            if (this.myProcessHandler != null) {
                this.myProcessHandler.destroyProcess();
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager != null) {
                            JSLanguageExternalCompilerImpl.this.myErrorToolWindowManager.disconnectFromProcessHandler();
                        }
                    }
                });
            }
        }
    }
}

