/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.compiler.ui;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResult;
import com.intellij.lang.javascript.compiler.ui.JSLanguageErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageCompilerToolWindowManager
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final String WARNING = "warning";
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile NewErrorTreeViewPanel myCurrentErrorTreeViewPanel;
    private volatile NewErrorTreeViewPanel myProjectErrorTreeViewPanel;
    private volatile boolean myFirstInitialized;
    @Nullable
    private ConsoleView myConsoleView;
    @Nullable
    private ContentImpl myConsoleContent;
    @Nullable
    private volatile ToolWindow myToolWindow;
    private String myHelpId;
    @Nullable
    private final Icon myIcon;
    @Nullable
    private AnAction[] myActions;
    private final String myToolWindowName;
    @Nullable
    private volatile List<JSLanguageCompilerResult> myLastResult;

    public JSLanguageCompilerToolWindowManager(@NotNull Project project, @NotNull String toolWindowName, @NotNull String helpId, @Nullable Icon icon, AnAction ... actions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/compiler/ui/JSLanguageCompilerToolWindowManager", "<init>"));
        }
        if (toolWindowName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowName", "com/intellij/lang/javascript/compiler/ui/JSLanguageCompilerToolWindowManager", "<init>"));
        }
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/compiler/ui/JSLanguageCompilerToolWindowManager", "<init>"));
        }
        this.myProject = project;
        this.myToolWindowName = toolWindowName;
        this.myHelpId = helpId;
        this.myIcon = icon;
        this.myActions = actions;
    }

    public synchronized void connectToProcessHandler(ProcessHandler handler) {
        this.init();
        NewErrorTreeViewPanel errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
        if (errorTreeViewPanel != null) {
            errorTreeViewPanel.getErrorViewStructure().clear();
        }
        LOGGER.debug("creating tool window");
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myToolWindow != null);
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            this.myConsoleView = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){};
            this.myConsoleView.attachToProcess(handler);
            this.myConsoleContent = new ContentImpl(this.myConsoleView.getComponent(), "Console", false);
            toolWindow.getContentManager().addContent((Content)this.myConsoleContent);
        }
    }

    public synchronized void printToConsole(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/compiler/ui/JSLanguageCompilerToolWindowManager", "printToConsole"));
        }
        ConsoleView view = this.myConsoleView;
        if (view != null) {
            view.print(message, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    public synchronized boolean isConnectedToProcessHandler() {
        return this.myConsoleView != null;
    }

    public void show() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.show(null);
        }
    }

    public synchronized void init() {
        if (!this.myFirstInitialized || this.myToolWindow == null) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager.registerToolWindow(this.myToolWindowName, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
            toolWindow.setIcon(this.myIcon);
            this.myToolWindow = toolWindow;
            this.createAllErrorsPanel();
            this.myFirstInitialized = true;
            LOGGER.debug("initialized tool window");
        }
    }

    private ContentImpl createCurrentErrorContent(final ToolWindow toolWindow) {
        final Ref content = new Ref();
        JSLanguageErrorTreeViewPanel errorTreeViewPanel = new JSLanguageErrorTreeViewPanel(this.myProject, this.myHelpId, new Runnable(){

            @Override
            public void run() {
                JSLanguageCompilerToolWindowManager.this.myLastResult = null;
            }
        }, this.myActions){

            public void close() {
                toolWindow.hide(new Runnable(){

                    @Override
                    public void run() {
                        JSLanguageCompilerToolWindowManager.this.myLastResult = null;
                        ContentImpl contentImpl = (ContentImpl)content.get();
                        if (contentImpl != null) {
                            toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                        }
                        ContentImpl newContentImpl = JSLanguageCompilerToolWindowManager.this.createCurrentErrorContent(toolWindow);
                        toolWindow.getContentManager().setSelectedContent((Content)newContentImpl);
                    }
                });
            }
        };
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        content.set((Object)new ContentImpl((JComponent)((Object)errorTreeViewPanel), "Current Errors", false));
        toolWindow.getContentManager().addContent((Content)content.get(), 0);
        this.myCurrentErrorTreeViewPanel = errorTreeViewPanel;
        return (ContentImpl)content.get();
    }

    @Nullable
    private NewErrorTreeViewPanel createAllErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            return panel;
        }
        final ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            return null;
        }
        final Ref content = new Ref();
        JSLanguageErrorTreeViewPanel errorTreeViewPanel = new JSLanguageErrorTreeViewPanel(this.myProject, this.myHelpId, null, this.myActions){

            public void close() {
                final NewErrorTreeViewPanel oldPanel = JSLanguageCompilerToolWindowManager.this.myProjectErrorTreeViewPanel;
                JSLanguageCompilerToolWindowManager.this.myProjectErrorTreeViewPanel = null;
                toolWindow.hide(new Runnable(){

                    @Override
                    public void run() {
                        ContentImpl contentImpl = (ContentImpl)content.get();
                        if (contentImpl != null) {
                            toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                        }
                        if (oldPanel != null) {
                            Disposer.dispose((Disposable)oldPanel);
                        }
                    }
                });
            }
        };
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        content.set((Object)new ContentImpl((JComponent)((Object)errorTreeViewPanel), "Project Errors", false));
        toolWindow.getContentManager().addContent((Content)content.get());
        this.myProjectErrorTreeViewPanel = errorTreeViewPanel;
        return errorTreeViewPanel;
    }

    public void disconnectFromProcessHandler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ConsoleView console = this.myConsoleView;
        ContentImpl content = this.myConsoleContent;
        ToolWindow toolWindow = this.myToolWindow;
        if (console != null && content != null && toolWindow != null) {
            toolWindow.getContentManager().removeContent((Content)content, true);
            this.myConsoleView = null;
            this.myConsoleContent = null;
            Disposer.dispose((Disposable)console);
        }
    }

    public void logProjectErrors(@NotNull ImmutableList<JSLanguageCompilerResult> results, boolean setActive) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/compiler/ui/JSLanguageCompilerToolWindowManager", "logProjectErrors"));
        }
        NewErrorTreeViewPanel panel = this.createAllErrorsPanel();
        if (panel == null) {
            return;
        }
        JSLanguageCompilerToolWindowManager.logErrorsImpl(panel, results);
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (setActive) {
            this.setActivePanel(panel, window);
        }
    }

    private void setActivePanel(NewErrorTreeViewPanel panel, ToolWindow window) {
        for (Content content : window.getContentManager().getContents()) {
            if (content.getComponent() != panel) continue;
            window.getContentManager().setSelectedContent(content);
            break;
        }
        this.show();
    }

    public void logCurrentErrors(@NotNull ImmutableList<JSLanguageCompilerResult> results, boolean setActive) {
        ArrayList list;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/compiler/ui/JSLanguageCompilerToolWindowManager", "logCurrentErrors"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
        ToolWindow toolWindow = this.myToolWindow;
        if (errorTreeViewPanel == null) {
            if (this.myFirstInitialized && toolWindow != null) {
                ContentImpl content = this.createCurrentErrorContent(toolWindow);
                toolWindow.getContentManager().setSelectedContent((Content)content);
                this.show();
                errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
            } else {
                return;
            }
        }
        if (this.myFirstInitialized && errorTreeViewPanel != null && !(list = ContainerUtil.newArrayList(results)).equals(this.myLastResult)) {
            JSLanguageCompilerToolWindowManager.logErrorsImpl(errorTreeViewPanel, list);
            this.myLastResult = list;
        }
        if (setActive) {
            this.setActivePanel(errorTreeViewPanel, toolWindow);
        }
    }

    private static void logErrorsImpl(NewErrorTreeViewPanel errorTreeViewPanel, List<JSLanguageCompilerResult> list) {
        errorTreeViewPanel.getErrorViewStructure().clear();
        for (JSLanguageCompilerResult compilerResult : list) {
            String path = compilerResult.myFileAbsoluteSystemDependPath;
            VirtualFile file = null;
            if (path != null) {
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
            }
            int category = WARNING.equalsIgnoreCase(compilerResult.myCategory) ? 5 : 4;
            errorTreeViewPanel.addMessage(category, new String[]{compilerResult.myErrorText}, file, compilerResult.myLine, compilerResult.myColumn, null);
        }
        errorTreeViewPanel.updateTree();
    }

    public void dispose() {
        this.cleanPanel();
    }

    public void cleanProjectErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            panel.getErrorViewStructure().clear();
            panel.updateTree();
        }
    }

    public synchronized void cleanPanel() {
        NewErrorTreeViewPanel allErrorTreeViewPanel;
        ConsoleView view;
        NewErrorTreeViewPanel panel;
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.myProject.isDisposed()) {
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(this.myToolWindowName);
        }
        if ((panel = this.myCurrentErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)panel);
        }
        if ((view = this.myConsoleView) != null) {
            Disposer.dispose((Disposable)view);
        }
        if ((allErrorTreeViewPanel = this.myProjectErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)allErrorTreeViewPanel);
        }
        this.myConsoleView = null;
        this.myProjectErrorTreeViewPanel = null;
        this.myToolWindow = null;
        this.myConsoleContent = null;
        this.myCurrentErrorTreeViewPanel = null;
        this.myLastResult = null;
    }
}

