/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.compiler.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class JSLanguageErrorTreeViewPanel
extends NewErrorTreeViewPanel {
    private final String myHelpId;
    private final Runnable myCleanAction;
    @Nullable
    private final AnAction[] myActions;
    private TreeExpander myTreeExpander;

    public JSLanguageErrorTreeViewPanel(Project project, String helpId, @Nullable Runnable cleanAction, AnAction ... actions) {
        super(project, helpId, false, false);
        this.myHelpId = helpId;
        this.myCleanAction = cleanAction;
        this.myActions = actions;
        this.myTreeExpander = (TreeExpander)this.getData(PlatformDataKeys.TREE_EXPANDER.getName());
        this.add(this.createToolPanel(), "West");
        this.myTree.getEmptyText().setText("No Errors");
    }

    private Component createToolPanel() {
        CloseTabToolbarAction closeMessageViewAction = new CloseTabToolbarAction(){

            public void actionPerformed(AnActionEvent e) {
                JSLanguageErrorTreeViewPanel.this.close();
            }
        };
        DefaultActionGroup leftUpdateableActionGroup = new DefaultActionGroup();
        DefaultActionGroup rightUpdateableActionGroup = new DefaultActionGroup();
        if (this.myTreeExpander != null) {
            rightUpdateableActionGroup.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this)));
            rightUpdateableActionGroup.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        }
        rightUpdateableActionGroup.add((AnAction)new DumbAwareAction("Clear All", null, AllIcons.Actions.GC){

            public void actionPerformed(AnActionEvent e) {
                if (JSLanguageErrorTreeViewPanel.this.myCleanAction != null) {
                    JSLanguageErrorTreeViewPanel.this.myCleanAction.run();
                }
                JSLanguageErrorTreeViewPanel.this.getErrorViewStructure().clear();
                JSLanguageErrorTreeViewPanel.this.updateTree();
            }
        });
        if (this.myActions != null) {
            for (AnAction action : this.myActions) {
                leftUpdateableActionGroup.add(action);
            }
        }
        leftUpdateableActionGroup.add((AnAction)new ContextHelpAction(this.myHelpId));
        leftUpdateableActionGroup.add((AnAction)closeMessageViewAction);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar leftToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)leftUpdateableActionGroup, false);
        ActionToolbar rightToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)rightUpdateableActionGroup, false);
        toolbarPanel.add((Component)leftToolbar.getComponent(), "West");
        toolbarPanel.add((Component)rightToolbar.getComponent(), "Center");
        return toolbarPanel;
    }
}

