/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class JSAutoCompletionPopupPolicy
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldFocusLookup(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldFocusLookup"));
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof JSReferenceExpression && JSResolveUtil.isSelfReference(parent) || parent instanceof JSParameter) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldFocusLookup"));
            }
            return threeState;
        }
        if (DialectDetector.isActionScript(parameters.getPosition())) {
            ASTNode node;
            PsiElement originalPosition = parameters.getOriginalPosition();
            if (originalPosition != null && (node = originalPosition.getNode()) != null && JSKeywordSets.AS_RESERVED_WORDS.contains(node.getElementType())) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldFocusLookup"));
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldFocusLookup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldFocusLookup"));
        }
        return threeState;
    }

    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        IElementType nodeType;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
        }
        PsiElement commentOrLiteral = PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{PsiComment.class, JSLiteralExpression.class});
        if (commentOrLiteral != null && !(commentOrLiteral instanceof JSXmlLiteralExpressionImpl)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        PsiElement prevContextElement = contextElement;
        ASTNode node = prevContextElement.getNode();
        if (node != null && ((nodeType = node.getElementType()) == JSTokenTypes.DOT || nodeType == JSTokenTypes.DOT_DOT || nodeType == JSTokenTypes.DOT_DOT_DOT)) {
            prevContextElement = PsiTreeUtil.prevLeaf((PsiElement)prevContextElement);
        }
        if (prevContextElement != null && prevContextElement.getParent() instanceof JSParameterList || prevContextElement instanceof PsiErrorElement) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        PsiElement parent = contextElement.getParent();
        if (parent instanceof JSProperty || parent instanceof JSReferenceExpression && parent.getParent() instanceof ES6Property && ((ES6Property)parent.getParent()).isShorthanded() && !DialectDetector.isES6((PsiElement)psiFile) || parent instanceof TypeScriptPropertySignature) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
        }
        return threeState;
    }
}

