/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JSDocTagsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final List<String> asdocTags = Arrays.asList("copy", "default", "eventType", "example", "exampleText", "includeExample", "inheritDoc", "internal", "param", "private", "return", "see", "since", "throws", "module", "final", "title", "config", "global");
    private static final List<String> jsdocTags = Arrays.asList("abstract", "access", "alias", "augments", "author", "borrows", "callback", "cfg", "class", "classdesc", "constant", "constructor", "constructs", "copyright", "default", "deprecated", "desc", "description", "enum", "event", "example", "exports", "extends", "external", "field", "fieldOf", "file", "fileOverview", "fires", "function", "global", "ignore", "inner", "instance", "kind", "lends", "licence", "link", "member", "memberOf", "method", "methodOf", "mixes", "mixin", "module", "name", "namespace", "param", "private", "property", "protected", "public", "readonly", "requires", "returns", "see", "since", "static", "summary", "this", "throws", "todo", "tutorial", "type", "typedef", "variation", "version", "mixes", "mixin");
    private static final List<String> closureTags = Arrays.asList("author", "code", "const", "constructor", "define", "deprecated", "enum", "export", "extends", "externs", "fileoverview", "implements", "inheritDoc", "interface", "lends", "license", "preserve", "noalias", "nosideeffects", "override", "param", "private", "protected", "return", "see", "supported", "suppress", "template", "this", "type", "typedef");
    private static final Collection<String> jsTags = new THashSet((Collection)ContainerUtil.concat(jsdocTags, closureTags));

    JSDocTagsCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        int i;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSDocTagsCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSDocTagsCompletionProvider", "addCompletions"));
        }
        PsiElement docTagName = parameters.getPosition();
        String text = docTagName.getText();
        int index = parameters.getOffset() - docTagName.getTextOffset();
        String s = text.substring(0, index);
        for (i = s.length() - 1; i >= 0 && Character.isJavaIdentifierPart(s.charAt(i)); --i) {
        }
        if (i >= 0 && s.charAt(i) == '@') {
            Collection<String> variants = DialectDetector.isActionScript(docTagName) ? asdocTags : jsTags;
            for (String variant : variants) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)variant));
            }
        }
    }
}

