/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypeEx;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;

public class JSInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    public static final InsertHandler<LookupElement> FUNCTION_INSERT_HANDLER = new JSInsertHandler<LookupElement>(){

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            char completionChar = context.getCompletionChar();
            if (1.needParensByContext(context.getFile().findElementAt(context.getStartOffset())) && !1.weAreNearCall(context.getFile().findElementAt(context.getTailOffset()), completionChar) && completionChar != '(') {
                1.insertBraces(context);
                context.getEditor().getCaretModel().moveToOffset(context.getEditor().getCaretModel().getOffset() + 2);
                return;
            }
            super.handleInsert(context, item);
        }
    };
    public static final Key<TailType> FORCED_TAIL_TYPE = Key.create((String)"forced.tail.type");

    public void handleInsert(InsertionContext context, LookupElement item) {
        TailType tailType;
        if (context.getCompletionChar() != '\r') {
            context.setAddCompletionChar(false);
        }
        if (context.getCompletionChar() == '(') {
            tailType = TailTypeEx.SMART_LPARENTH;
        } else {
            TailType forcedTailType;
            tailType = LookupItem.handleCompletionChar((Editor)context.getEditor(), (LookupElement)item, (char)context.getCompletionChar());
            if (tailType == TailType.UNKNOWN && item instanceof LookupItem && (forcedTailType = (TailType)((LookupItem)item).getAttribute(FORCED_TAIL_TYPE)) != null) {
                tailType = forcedTailType;
            }
        }
        tailType.processTail(context.getEditor(), context.getSelectionEndOffset());
        int offsetToImport = context.getStartOffset();
        PsiElement elementAtOffset = context.getFile().findElementAt(offsetToImport);
        PsiElement contextElement = elementAtOffset != null ? elementAtOffset.getParent().getParent() : null;
        boolean showParameterInfo = false;
        char completionChar = context.getCompletionChar();
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)context.getProject());
        if (tailType == TailType.DOT || completionChar == '.' || (showParameterInfo = (tailType == TailType.COMMA || completionChar == ',') && contextElement instanceof JSArgumentList)) {
            if (showParameterInfo) {
                autoPopupController.autoPopupParameterInfo(context.getEditor(), null);
            } else {
                autoPopupController.autoPopupMemberLookup(context.getEditor(), null);
            }
        }
        CaretModel caretModel = context.getEditor().getCaretModel();
        if (item.getLookupString().endsWith("()") || item.getLookupString().endsWith("[]")) {
            caretModel.moveCaretRelatively(-1, 0, false, false, true);
        } else {
            Object object = item.getObject();
            PsiElement element = object instanceof PsiElement && ((PsiElement)object).isValid() ? (PsiElement)object : null;
            boolean weAreNearCall = JSInsertHandler.weAreNearCall(context.getFile().findElementAt(context.getTailOffset()), completionChar);
            if (element != null && completionChar != '.' && completionChar != ',' && completionChar != ' ') {
                JSFunction constructor;
                JSFunction functionInitializer;
                JSElement parent;
                if (element instanceof JSProperty && !((parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, (Class[])new Class[]{JSObjectLiteralExpression.class, JSExpressionStatement.class, JSVariable.class})) instanceof JSObjectLiteralExpression) && (functionInitializer = ((JSProperty)element).tryGetFunctionInitializer()) != null && !JSResolveUtil.isFromPredefinedFile(functionInitializer.getContainingFile())) {
                    element = functionInitializer;
                }
                JSFunctionItem possibleFun = JSPsiImplUtils.calculatePossibleFunction(element);
                boolean atNew = contextElement instanceof JSNewExpression;
                if (element instanceof JSClass && atNew && (constructor = ((JSClass)element).getConstructor()) != null) {
                    possibleFun = constructor;
                }
                if (possibleFun != null && !possibleFun.isGetProperty() && !possibleFun.isSetProperty()) {
                    boolean needParens;
                    int offset = caretModel.getOffset();
                    boolean completingWithLParen = completionChar == '(';
                    boolean bl = needParens = completionChar != '\r';
                    if (!completingWithLParen) {
                        needParens &= JSInsertHandler.needParensByContext(elementAtOffset);
                        if ((needParens &= contextElement instanceof JSNewExpression || !JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)possibleFun)) && !weAreNearCall) {
                            JSInsertHandler.insertBraces(context);
                        }
                    }
                    boolean shiftInsideParens = false;
                    if (needParens) {
                        if (possibleFun.getParameters().length > 0) {
                            shiftInsideParens = true;
                        } else {
                            boolean hasArguments = possibleFun.isReferencesArguments();
                            if (hasArguments) {
                                shiftInsideParens = true;
                            }
                        }
                    }
                    if (completingWithLParen) {
                        if (shiftInsideParens) {
                            JSFunctionItem funElement = possibleFun instanceof PsiElement ? possibleFun : null;
                            autoPopupController.autoPopupParameterInfo(context.getEditor(), (PsiElement)funElement);
                        } else {
                            caretModel.moveToOffset(offset + 1);
                        }
                    } else if (shiftInsideParens) {
                        caretModel.moveToOffset(offset + 1);
                        JSFunctionItem funElement = possibleFun instanceof PsiElement ? possibleFun : null;
                        autoPopupController.autoPopupParameterInfo(context.getEditor(), (PsiElement)funElement);
                    } else {
                        caretModel.moveToOffset(offset + (needParens ? 2 : 0));
                    }
                } else if (element instanceof JSProperty) {
                    PsiElement prev;
                    int offset = caretModel.getOffset();
                    PsiElement psiElement = context.getFile().findElementAt(offset);
                    PsiElement parent2 = psiElement != null ? psiElement.getParent() : null;
                    boolean alreadyHasSemicolon = false;
                    if (psiElement != null && (prev = psiElement.getPrevSibling()) instanceof JSProperty && prev.getNode().findChildByType(JSTokenTypes.COLON) != null) {
                        alreadyHasSemicolon = true;
                    }
                    if (parent2 instanceof JSObjectLiteralExpression && !alreadyHasSemicolon) {
                        context.getEditor().getDocument().insertString(offset, (CharSequence)":");
                        caretModel.moveToOffset(offset + 1);
                    }
                } else if (element instanceof JSClass && atNew && !weAreNearCall && completionChar != '\r' && completionChar != '(') {
                    int offset = caretModel.getOffset();
                    JSInsertHandler.insertBraces(context);
                    caretModel.moveToOffset(offset + 2);
                }
            }
            String qNameToImport = null;
            PsiElement elementForQNameImport = element;
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            if (element != null) {
                JSReferenceExpression contextExpr = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, JSReferenceExpression.class);
                if (elementForQNameImport instanceof JSAttributeListOwner) {
                    JSClass contextClass;
                    JSClass clazz;
                    JSAttributeList attributeList = ((JSAttributeListOwner)elementForQNameImport).getAttributeList();
                    if (elementForQNameImport instanceof JSVariable && attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && (clazz = JSUtils.getMemberContainingClass(elementForQNameImport)) != null && ((contextClass = JSResolveUtil.getClassOfContext(elementAtOffset)) == null || !JSInheritanceUtil.isParentClass(contextClass, clazz, false))) {
                        elementForQNameImport = clazz;
                        offsetToImport = (contextExpr = JSInsertHandler.updateContextExpr(contextExpr)) != null ? contextExpr.getTextRange().getStartOffset() : 0;
                    }
                    String qName = ((JSQualifiedNamedElement)elementForQNameImport).getQualifiedName();
                    if (contextExpr != null && qName != null && StringUtil.isNotEmpty((String)StringUtil.getPackageName((String)qName))) {
                        qNameToImport = qName;
                    }
                }
            }
            if (qNameToImport != null && DialectDetector.isActionScript(elementForQNameImport)) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
                elementAtOffset = context.getFile().findElementAt(offsetToImport);
                ImportUtils.doImport(elementAtOffset, qNameToImport, true);
            }
            if (elementAtOffset != null && elementAtOffset.getNode().getElementType() == JSDocTokenTypes.DOC_TAG_NAME && object instanceof String && ("return".equals(object) || "returns".equals(object))) {
                JSDocumentationProvider.setReturnTag((String)object);
            }
        }
    }

    protected static boolean needParensByContext(PsiElement elementAtOffset) {
        JSType expectedType;
        PsiElement grandParentElementAtOffset;
        PsiElement parentElementAtOffset = elementAtOffset != null ? elementAtOffset.getParent() : null;
        PsiElement psiElement = grandParentElementAtOffset = parentElementAtOffset != null ? parentElementAtOffset.getParent() : null;
        if (grandParentElementAtOffset instanceof JSBinaryExpression && ((JSBinaryExpression)grandParentElementAtOffset).getOperationSign() == JSTokenTypes.INSTANCEOF_KEYWORD && parentElementAtOffset == ((JSBinaryExpression)grandParentElementAtOffset).getROperand() || (grandParentElementAtOffset instanceof JSVariable || grandParentElementAtOffset instanceof JSFunction) && parentElementAtOffset.getPrevSibling() != null && parentElementAtOffset.getPrevSibling().getNode().getElementType() == JSTokenTypes.COLON || grandParentElementAtOffset instanceof JSImportStatement || parentElementAtOffset instanceof JSDocTagValue || parentElementAtOffset instanceof JSAttributeNameValuePair || parentElementAtOffset instanceof PsiComment) {
            return false;
        }
        return !(parentElementAtOffset instanceof JSExpression) || grandParentElementAtOffset instanceof JSAssignmentExpression || (expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parentElementAtOffset)) == null || !JSTypeUtils.hasFunctionType(expectedType);
    }

    protected static boolean weAreNearCall(PsiElement elementAt, char ch) {
        if (elementAt != null) {
            if (ch == '\t') {
                ASTNode node = elementAt.getNode();
                if (node != null && JSTokenTypes.IDENTIFIER_TOKENS_SET.contains(node.getElementType())) {
                    elementAt = PsiTreeUtil.nextLeaf((PsiElement)elementAt);
                }
                if (elementAt instanceof PsiWhiteSpace && !elementAt.textContains('\n')) {
                    elementAt = PsiTreeUtil.nextLeaf((PsiElement)elementAt);
                }
            }
            return elementAt != null && elementAt.getText().equals("(");
        }
        return false;
    }

    protected static void insertBraces(InsertionContext context) {
        char completionChar = context.getCompletionChar();
        int offset = context.getEditor().getCaretModel().getOffset();
        int diff = completionChar == '\n' || completionChar == '\t' || completionChar == '\r' || completionChar == '\u0000' ? 0 : 1;
        context.getEditor().getDocument().insertString(offset - diff, (CharSequence)"()");
    }

    private static JSReferenceExpression updateContextExpr(JSReferenceExpression contextExpr) {
        JSExpression contextExprParent;
        JSExpression jSExpression = contextExprParent = contextExpr != null ? contextExpr.getQualifier() : null;
        if (contextExprParent instanceof JSReferenceExpression) {
            contextExpr = (JSReferenceExpression)contextExprParent;
        }
        return contextExpr;
    }
}

