/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSPsiTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final String[] TYPE_LITERAL_VALUES = new String[]{"true", "false", "null"};
    private static final String[] KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE = new String[]{"true", "false", "null", "break", "continue", "default", "return", "this"};
    private static final String[] KEYWORDS_REQUIRE_SPACE = new String[]{"case", "const", "delete", "in", "instanceof", "new", "throw", "typeof", "var", "void", "with"};

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "addCompletions"));
        }
        PsiFile containingFile = parameters.getPosition().getContainingFile().getOriginalFile();
        List<Object> variants = containingFile instanceof JSExpressionCodeFragment ? ((JSExpressionCodeFragment)containingFile).getTopLevelVariants(parameters.getPosition()) : Arrays.asList(JSKeywordsCompletionProvider.getDefaultKeywordVariants(parameters.getPosition()));
        ArrayList<LookupItem> lookupElements = new ArrayList<LookupItem>(variants.size());
        for (Object variant : variants) {
            lookupElements.add((LookupItem)(variant instanceof LookupItem ? ((LookupItem)variant).setBold() : LookupElementBuilder.create((String)variant.toString()).bold()));
        }
        result.addAllElements(lookupElements);
    }

    @NotNull
    public static LookupElement[] getDefaultKeywordVariants(@NotNull PsiElement context) {
        ASTNode grandParentNode;
        KeywordCompletionConsumer consumer;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
        }
        final ArrayList<Trinity<String, Integer, Boolean>> keywords = new ArrayList<Trinity<String, Integer, Boolean>>();
        JSInsertHandler handler = new JSInsertHandler();
        JSCompletionKeywordsContributor contributor = JSDialectSpecificHandlersFactory.forElement(context).newCompletionKeywordsContributor();
        if (!contributor.process(consumer = new KeywordCompletionConsumer(){

            @Override
            public void consume(int priority, boolean appendSpaces, String ... contributorKeywords) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpaces, contributorKeywords);
            }
        }, context)) {
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, handler);
            if (lookupElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return lookupElementArray;
        }
        PsiElement parent = context.getParent();
        if (parent instanceof JSBreakStatement || parent instanceof JSContinueStatement || parent instanceof JSLiteralExpression || parent instanceof JSParameter || parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof XmlAttribute || parent instanceof XmlAttributeValue || JSTokenTypes.STRING_LITERALS.contains(context.getNode().getElementType()) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiComment.class}) != null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSAttribute.class}) != null || parent instanceof JSReferenceExpression && JSResolveUtil.isSelfReference(parent)) {
            if (LookupElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return LookupElement.EMPTY_ARRAY;
        }
        if (parent instanceof JSCaseClause && JSPsiTreeUtil.getChildExcludingTypes(parent, PsiErrorElement.class, PsiWhiteSpace.class) == context) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, 101, true, "case");
            JSKeywordsCompletionProvider.appendKeywords(keywords, 101, false, "default");
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, handler);
            if (lookupElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return lookupElementArray;
        }
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(context);
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)parent).getQualifier() != null || parent.textContains('.') || parent.textContains(':')) {
                if (LookupElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return LookupElement.EMPTY_ARRAY;
            }
            if (grandParent instanceof JSNewExpression) {
                boolean appendSpace = JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH;
                JSKeywordsCompletionProvider.appendKeywords(keywords, 6, appendSpace, "function");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, handler);
                if (lookupElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return lookupElementArray;
            }
            if (grandParent instanceof JSDoWhileStatement) {
                boolean appendSpace = commonSettings.SPACE_BEFORE_WHILE_PARENTHESES;
                JSKeywordsCompletionProvider.appendKeywords(keywords, 101, appendSpace, "while");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, handler);
                if (lookupElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return lookupElementArray;
            }
            if (grandParent instanceof JSStatement) {
                PsiElement prevSibling;
                boolean appendSpace;
                PsiElement prevStatement = PsiTreeUtil.getPrevSiblingOfType((PsiElement)grandParent, JSStatement.class);
                if (prevStatement instanceof JSIfStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_ELSE_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, 101, appendSpace, "else");
                } else if (prevStatement instanceof JSTryStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_CATCH_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, 101, appendSpace, "catch");
                    appendSpace = commonSettings.SPACE_BEFORE_FINALLY_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, 101, appendSpace, "finally");
                }
                if (grandParent instanceof JSExpressionStatement && (prevSibling = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(grandParent)) != null && prevSibling.getNode().getElementType() == JSTokenTypes.ELSE_KEYWORD) {
                    boolean appendSpace2 = commonSettings.SPACE_BEFORE_IF_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, 101, appendSpace2, "if");
                }
            } else {
                if (grandParent instanceof JSProperty && ((JSProperty)grandParent).getNameIdentifier() == parent) {
                    if (LookupElement.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                    }
                    return LookupElement.EMPTY_ARRAY;
                }
                boolean isComparison = grandParent instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(((JSBinaryExpression)grandParent).getOperationSign());
                boolean isAssignment = grandParent instanceof JSArgumentList || grandParent instanceof JSBinaryExpression && ((JSBinaryExpression)grandParent).getOperationSign() == JSTokenTypes.EQ;
                int priority = isComparison || isAssignment ? 6 : 3;
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, TYPE_LITERAL_VALUES);
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, "this");
                if (isAssignment || !isComparison) {
                    boolean appendSpace = commonSettings.SPACE_BEFORE_METHOD_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpace, "function");
                }
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "typeof");
                if (isAssignment || !isComparison) {
                    JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "new");
                }
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, handler);
                if (lookupElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return lookupElementArray;
            }
        }
        if (grandParent instanceof JSEmbeddedContent && (grandParentNode = grandParent.getNode()) != null && grandParentNode.getElementType() == JSElementTypes.EMBEDDED_EXPRESSION) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, 6, false, TYPE_LITERAL_VALUES);
            JSKeywordsCompletionProvider.appendKeywords(keywords, 6, false, "int", "uint");
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, handler);
            if (lookupElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return lookupElementArray;
        }
        ArrayList withoutSpace = new ArrayList(30);
        ContainerUtil.addAll(withoutSpace, (Object[])KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE);
        ArrayList<String> withSpace = new ArrayList<String>(20);
        ContainerUtil.addAll(withSpace, (Object[])KEYWORDS_REQUIRE_SPACE);
        (commonSettings.SPACE_BEFORE_WHILE_PARENTHESES ? withSpace : withoutSpace).add("while");
        (commonSettings.SPACE_BEFORE_DO_LBRACE ? withSpace : withoutSpace).add("do");
        (commonSettings.SPACE_BEFORE_ELSE_LBRACE ? withSpace : withoutSpace).add("else");
        (commonSettings.SPACE_BEFORE_FOR_PARENTHESES ? withSpace : withoutSpace).add("each");
        (commonSettings.SPACE_BEFORE_FINALLY_LBRACE ? withSpace : withoutSpace).add("finally");
        (commonSettings.SPACE_BEFORE_FOR_PARENTHESES ? withSpace : withoutSpace).add("for");
        (JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH ? withSpace : withoutSpace).add("function");
        (commonSettings.SPACE_BEFORE_IF_PARENTHESES ? withSpace : withoutSpace).add("if");
        (commonSettings.SPACE_BEFORE_TRY_LBRACE ? withSpace : withoutSpace).add("try");
        (commonSettings.SPACE_BEFORE_CATCH_PARENTHESES ? withSpace : withoutSpace).add("catch");
        (commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES ? withSpace : withoutSpace).add("switch");
        JSKeywordsCompletionProvider.appendKeywords(keywords, 3, false, ArrayUtil.toStringArray(withoutSpace));
        JSKeywordsCompletionProvider.appendKeywords(keywords, 3, true, ArrayUtil.toStringArray(withSpace));
        contributor.appendSpecificKeywords(consumer);
        LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, handler);
        if (lookupElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
        }
        return lookupElementArray;
    }

    public static void appendKeywords(List<Trinity<String, Integer, Boolean>> keywords, int priority, boolean appendSpace, String ... names) {
        for (String name : names) {
            keywords.add((Trinity<String, Integer, Boolean>)Trinity.create((Object)name, (Object)priority, (Object)appendSpace));
        }
    }

    private static LookupElement[] createKeywordItems(List<Trinity<String, Integer, Boolean>> keywords, @NotNull JSInsertHandler<?> handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "createKeywordItems"));
        }
        THashMap keywordsMap = new THashMap();
        for (Trinity<String, Integer, Boolean> keyword : keywords) {
            Pair oldKeywordValue = (Pair)keywordsMap.get(keyword.first);
            if (oldKeywordValue != null && (Integer)oldKeywordValue.first >= (Integer)keyword.second) continue;
            keywordsMap.put(keyword.first, Pair.create((Object)keyword.second, (Object)keyword.third));
        }
        LookupItem[] lookupItems = new LookupItem[keywordsMap.size()];
        int i = 0;
        for (Map.Entry entry : keywordsMap.entrySet()) {
            String option = (String)entry.getKey();
            LookupItem item = new LookupItem((Object)option, option).setPriority((double)((Integer)((Pair)entry.getValue()).first).intValue());
            if (((Boolean)((Pair)entry.getValue()).second).booleanValue()) {
                item = item.setTailType(TailType.SPACE);
            }
            item.setInsertHandler(handler);
            lookupItems[i++] = item;
        }
        return lookupItems;
    }
}

