/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSReferenceCompletionUtil;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.completion.TypeScriptCompletionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof JSReferenceExpression);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
        PsiFile containingFile = referenceExpression.getContainingFile();
        boolean ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        List smartVariants = JSSmartCompletionVariantsHandler.getSmartVariants((PsiElement)referenceExpression);
        JSInsertHandler insertHandler = new JSInsertHandler();
        if (smartVariants != null && parameters.getCompletionType() == CompletionType.SMART) {
            JSReferenceCompletionProvider.addVariants(smartVariants, Collections.emptyList(), insertHandler, result);
            return;
        }
        Collection variants = JSReferenceCompletionUtil.calcDefaultVariants(referenceExpression, containingFile, ecma);
        JSReferenceCompletionProvider.addVariants(smartVariants != null ? smartVariants : Collections.emptyList(), variants, insertHandler, result);
        JSReferenceCompletionProvider.addVariantsToImport(referenceExpression, containingFile, variants);
    }

    private static void addVariantsToImport(JSReferenceExpression referenceExpression, PsiFile containingFile, Collection variants) {
        if (DialectDetector.isTypeScript((PsiElement)referenceExpression)) {
            PsiElement parent;
            JSExpression qualifier;
            JSExpression jSExpression = qualifier = referenceExpression instanceof JSReferenceExpressionImpl ? ((JSReferenceExpressionImpl)referenceExpression).getResolveQualifier() : referenceExpression.getQualifier();
            if (qualifier == null && !JSResolveUtil.isSelfReference(parent = referenceExpression.getParent(), (PsiElement)referenceExpression)) {
                TypeScriptCompletionUtil.addAllVariants(referenceExpression, containingFile, variants);
            }
        }
    }

    private static void addVariants(@NotNull Collection smartVariants, @NotNull Collection variants, JSInsertHandler<?> insertHandler, CompletionResultSet result) {
        LookupElement element;
        if (smartVariants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartVariants", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addVariants"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addVariants"));
        }
        THashSet smartVariantsLookups = new THashSet(smartVariants.size());
        for (Object variant : smartVariants) {
            element = CompletionData.objectToLookupItem(variant);
            smartVariantsLookups.add(element.getLookupString());
            JSReferenceCompletionProvider.addVariant(insertHandler, element, result);
        }
        for (Object variant : variants) {
            element = CompletionData.objectToLookupItem(variant);
            if (smartVariantsLookups.contains(element.getLookupString())) continue;
            JSReferenceCompletionProvider.addVariant(insertHandler, element, result);
        }
    }

    private static void addVariant(JSInsertHandler<?> insertHandler, LookupElement element, CompletionResultSet result) {
        LookupItem lookupItem;
        if (element instanceof LookupItem && (lookupItem = (LookupItem)element).getInsertHandler() == null) {
            lookupItem.setInsertHandler(insertHandler);
            lookupItem.setTailType(TailType.UNKNOWN);
        }
        if (element != null) {
            result.addElement(element);
        }
    }
}

