/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JSTextReferenceCompletion {
    static List<LookupElement> addVariants(JSTextReference reference) {
        PsiFile containingFile = reference.getElement().getContainingFile();
        List<LookupElement> localResults = null;
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        boolean newResolveAndCompletion = reference.useActionScriptIndex(containingFile);
        if (newResolveAndCompletion) {
            CompletionResultSink resultSink = new CompletionResultSink((PsiElement)containingFile);
            Collection<String> baseClassFqns = reference.getBaseClassFqns();
            if (baseClassFqns != null && !baseClassFqns.isEmpty()) {
                JSTextReferenceCompletion.setCompletionFilter(resultSink, baseClassFqns, containingFile);
            }
            reference.processToSink(containingFile, resultSink);
            List<PsiElement> results = resultSink.getResults();
            if (results != null) {
                localResults = resultSink.resultsToLookupElements(results);
                result.addAll(localResults);
                JSTextReferenceCompletion.forceQualifyIfNeeded(reference, localResults);
            } else {
                localResults = Collections.emptyList();
            }
        }
        if (!newResolveAndCompletion || reference.getElement() instanceof JSLiteralExpression) {
            result.addAll(JSTextReferenceCompletion.calcDefaultVariants(reference, containingFile, localResults));
            if (reference instanceof JSDocReference) {
                JSTextReferenceCompletion.addJSDocTags(reference, result);
            }
        }
        return result;
    }

    private static void addJSDocTags(JSTextReference reference, List<LookupElement> set) {
        if (reference.getElement() instanceof JSDocTagValue) {
            set.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"boolean"), (double)101.0));
            set.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"function"), (double)101.0));
            set.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"number"), (double)101.0));
            set.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"string"), (double)101.0));
        }
    }

    public static List<LookupElement> calcDefaultVariants(JSTextReference reference, PsiFile containingFile, List<LookupElement> localResults) {
        PsiReference ref;
        PsiElement context;
        List<String> contextNames = reference.fillContextNames();
        VariantsProcessor processor = new VariantsProcessor(contextNames != null ? ArrayUtil.toStringArray(contextNames) : BaseJSSymbolProcessor.EMPTY_CONTEXT, containingFile, reference.getElement(), BaseJSSymbolProcessor.MatchMode.Any);
        processor.setAddOnlyCompleteMatches(contextNames != null || !(reference.getElement() instanceof JSLiteralExpression));
        if (localResults != null) {
            processor.populateCompletionList(localResults, true);
        }
        if ((context = containingFile.getContext()) != null || reference.isPrimary()) {
            CompletionResultSink sink = new CompletionResultSink(reference.getElement());
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            reference.processLocalVariants(containingFile, localProcessor, context);
            List<PsiElement> processorResults = sink.getResults();
            if (processorResults != null) {
                processor.populateCompletionList(sink.resultsToLookupElements(processorResults), true);
            }
        }
        JSReferenceCompletionContributor.processIndexedSymbols(reference.getElement(), processor);
        String name = null;
        PsiElement originalElement = PsiUtilBase.getOriginalElement((PsiElement)reference.getElement(), reference.getElement().getClass());
        if (originalElement != null && (ref = originalElement.findReferenceAt(reference.getRangeInElement().getStartOffset())) != null) {
            name = ref.getCanonicalText();
        }
        return processor.getResults(name);
    }

    private static void forceQualifyIfNeeded(JSTextReference reference, List<LookupElement> results) {
        if (reference.isOnlyFqns() && reference.isPrimary()) {
            for (LookupElement result : results) {
                if (!(result instanceof LookupItem)) continue;
                ((LookupItem)result).forceQualify();
            }
        }
    }

    private static void setCompletionFilter(CompletionResultSink resultSink, Collection<String> baseClassFqns, PsiFile containingFile) {
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
        if (module != null) {
            PublicInheritorFilter filter;
            final GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
            if (baseClassFqns.size() == 1) {
                filter = new PublicInheritorFilter(module.getProject(), baseClassFqns.iterator().next(), scope, false);
            } else {
                final List conditions = ContainerUtil.map(baseClassFqns, (Function)new Function<String, Condition<JSClass>>(){

                    public Condition<JSClass> fun(String fqn) {
                        return new PublicInheritorFilter(module.getProject(), fqn, scope, false);
                    }
                });
                filter = new Condition<JSClass>(){

                    public boolean value(JSClass aClass) {
                        for (Condition condition : conditions) {
                            if (!condition.value((Object)aClass)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            resultSink.setPlaceFilter(CompletionResultSink.createFilter(filter));
        }
    }
}

