/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.ECMA6LanguageDialect;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ECMA6SyntaxHighlighterFactory
extends SingleLazyInstanceSyntaxHighlighterFactory {
    @NotNull
    protected SyntaxHighlighter createHighlighter() {
        ECMA6SyntaxHighlighter eCMA6SyntaxHighlighter = new ECMA6SyntaxHighlighter();
        if (eCMA6SyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/ECMA6SyntaxHighlighterFactory", "createHighlighter"));
        }
        return eCMA6SyntaxHighlighter;
    }

    private static class ECMA6SyntaxHighlighter
    extends JSHighlighter {
        private final Map<IElementType, TextAttributesKey> myKeysMap = new THashMap();

        public ECMA6SyntaxHighlighter() {
            super(ECMA6LanguageDialect.DIALECT_OPTION_HOLDER);
            this.myKeysMap.put(JSTokenTypes.STRING_TEMPLATE_PART, DefaultLanguageHighlighterColors.STRING);
        }

        @Override
        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            if (this.myKeysMap.containsKey(tokenType)) {
                TextAttributesKey[] textAttributesKeyArray = ECMA6SyntaxHighlighter.pack((TextAttributesKey)this.myKeysMap.get(tokenType));
                if (textAttributesKeyArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/ECMA6SyntaxHighlighterFactory$ECMA6SyntaxHighlighter", "getTokenHighlights"));
                }
                return textAttributesKeyArray;
            }
            TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/ECMA6SyntaxHighlighterFactory$ECMA6SyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
    }
}

