/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.GwtLanguageDialect;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GwtSyntaxHighlighterFactory
extends SingleLazyInstanceSyntaxHighlighterFactory {
    @NotNull
    protected SyntaxHighlighter createHighlighter() {
        GwtSyntaxHighlighter gwtSyntaxHighlighter = new GwtSyntaxHighlighter();
        if (gwtSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/GwtSyntaxHighlighterFactory", "createHighlighter"));
        }
        return gwtSyntaxHighlighter;
    }

    private static class GwtSyntaxHighlighter
    extends JSHighlighter {
        private final Map<IElementType, TextAttributesKey> myKeysMap = new THashMap();

        public GwtSyntaxHighlighter() {
            super(GwtLanguageDialect.DIALECT_OPTION_HOLDER);
            this.myKeysMap.put(JSTokenTypes.COLON_COLON, JS_OPERATION_SIGN);
            this.myKeysMap.put(JSTokenTypes.GWT_FIELD_OR_METHOD, CodeInsightColors.METHOD_CALL_ATTRIBUTES);
            this.myKeysMap.put(JSTokenTypes.AT, JS_OPERATION_SIGN);
            this.myKeysMap.put(JSTokenTypes.IDENTIFIER, CodeInsightColors.CLASS_NAME_ATTRIBUTES);
        }

        @Override
        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            if (this.myKeysMap.containsKey(tokenType)) {
                TextAttributesKey[] textAttributesKeyArray = GwtSyntaxHighlighter.pack((TextAttributesKey)this.myKeysMap.get(tokenType));
                if (textAttributesKeyArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/GwtSyntaxHighlighterFactory$GwtSyntaxHighlighter", "getTokenHighlights"));
                }
                return textAttributesKeyArray;
            }
            TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/GwtSyntaxHighlighterFactory$GwtSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
    }
}

