/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import org.jetbrains.annotations.NotNull;

public class JSXHarmonyLanguageDialect
extends JSLanguageDialect {
    public static final DialectOptionHolder DIALECT_OPTION_HOLDER = DialectOptionHolder.JSX;

    public JSXHarmonyLanguageDialect() {
        super("JSX Harmony", DIALECT_OPTION_HOLDER, JavaScriptSupportLoader.ECMA_SCRIPT_6, "text/jsx");
    }

    public static boolean isReactComponent(JSExpression expression) {
        if (!(expression instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)expression;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        return JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "React", "createClass");
    }

    @Override
    public String getFileExtension() {
        return "js";
    }

    @Override
    public JavaScriptParser<?, ?, ?, ?> createParser(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/dialects/JSXHarmonyLanguageDialect", "createParser"));
        }
        return new ES6Parser(this, builder);
    }
}

