/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.completion.ES6CompletionKeywordsContributor;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;

public class TypeScriptCompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        PsiElement parent = context.getParent();
        if (parent instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)context, JSReferenceList.class) == null && ((JSReferenceExpression)parent).getQualifier() == null) {
                consumer.consume(101, false, "string", "boolean", "number", "void", "any");
            }
            return false;
        }
        if (parent instanceof TypeScriptImportStatement || parent instanceof ES6ImportSpecifier || parent instanceof ES6ExportSpecifier) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addFromKeyword(consumer, parent)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSExpressionStatement || grandParent instanceof JSAttributeList) {
            if (grandParent instanceof JSExpressionStatement) {
                JSFunction function;
                PsiElement grandParentParent = grandParent.getParent();
                if (grandParentParent instanceof PsiFile || grandParentParent instanceof TypeScriptModule) {
                    consumer.consume(6, true, "class", "enum", "interface", "declare", "abstract", "async", "export", "type", "module", "namespace", "import");
                } else if ((grandParentParent instanceof JSBlockStatement || grandParentParent instanceof JSIfStatement) && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)grandParentParent, JSFunction.class)) != null) {
                    if (function.isGenerator()) {
                        consumer.consume(101, true, "yield");
                    } else if (ES6PsiUtil.isAsyncContext(function)) {
                        consumer.consume(101, true, "await");
                    }
                }
                PsiElement prev = JSPsiImplUtils.findPrevCodeElement(grandParent);
                if (prev instanceof TypeScriptClass && prev.getNode().findChildByType(JSTokenTypes.LBRACE) == null || prev instanceof TypeScriptInterface && ((TypeScriptInterface)prev).getBody() == null) {
                    consumer.consume(101, true, "extends");
                    if (prev instanceof TypeScriptClass) {
                        consumer.consume(101, true, "implements");
                    }
                    return false;
                }
            }
            consumer.consume(6, true, "public", "private", "protected", "function", "let", "const", "var");
            return !TypeScriptPsiUtil.isAmbientDeclaration(grandParent.getParent());
        }
        if (grandParent instanceof TypeScriptImportStatement && parent instanceof JSReferenceExpression) {
            consumer.consume(101, false, "require");
            return false;
        }
        if (grandParent instanceof JSVarStatement && grandParent.getParent() instanceof TypeScriptClass) {
            consumer.consume(101, false, "constructor");
            consumer.consume(101, true, "public", "private", "protected", "static", "abstract", "async", "get", "set");
            return false;
        }
        if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property) {
            return false;
        }
        if (grandParent instanceof JSBinaryExpression || grandParent instanceof TypeScriptTypeParameterList) {
            consumer.consume(3, false, "extends");
        }
        return true;
    }

    @Override
    public void appendSpecificKeywords(KeywordCompletionConsumer consumer) {
        consumer.consume(3, false, "super", "require");
    }
}

