/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.ES6ImportAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportHandler
extends JSImportHandler {
    private static final TypeScriptImportHandler INSTANCE = new TypeScriptImportHandler();
    private static final ResolveProcessor.ProcessingOptions OPTIONS = new ResolveProcessor.ProcessingOptions(){

        @Override
        public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
            if (fun == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler$1", "toProcessFunctionBodyDeclarations"));
            }
            return false;
        }

        @Override
        public boolean toProcessFunctionArguments() {
            return false;
        }

        @Override
        public boolean toProcessPackageImports(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return false;
        }
    };

    protected TypeScriptImportHandler() {
    }

    public static TypeScriptImportHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        JSTypeResolveResult jSTypeResolveResult = TypeScriptImportHandler.resolveNameImpl(type, source, false, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private static JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, boolean typeContext, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited) {
        String qName;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        PsiElement source = TypeScriptImportHandler.getSourceElement(sourceRaw);
        if (source == null) {
            source = sourceRaw;
        }
        if (!DialectDetector.isTypeScript(source)) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(type);
        Collection<Object> elements = TypeScriptImportHandler.resolveTypeElements(qualifiedName, source, visited, typeContext);
        final PsiElement finalSource = source;
        if ((elements = ContainerUtil.filter(elements, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return TypeScriptModuleAccessibilityChecker.INSTANCE.check(finalSource, element) == null && TypeScriptConfigAccessibilityChecker.INSTANCE.check(finalSource, element) == null;
            }
        })).isEmpty()) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : "";
        if (qName == null) {
            qName = "";
        }
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(qName, elements);
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        return jSTypeResolveResult;
    }

    private static PsiElement getSourceElement(@NotNull PsiElement sourceRaw) {
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getSourceElement"));
        }
        JSSourceElement type = (JSSourceElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)sourceRaw, (Class[])new Class[]{JSSourceElement.class});
        if (type instanceof TypeScriptType) {
            type = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)sourceRaw, JSSourceElement.class);
        }
        if (type instanceof JSBlockStatement || type instanceof TypeScriptModule || type instanceof JSFile || type == null) {
            return type;
        }
        PsiElement parent = type.getParent();
        if (parent != null && TypeScriptPsiUtil.isTopLevelContainer(parent)) {
            return parent;
        }
        return type;
    }

    @Override
    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        final Ref resultValue = new Ref();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.source = context;
        visitor.visited = (Set)new THashSet();
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                if (qualifierResult instanceof JSQualifiedNamedElement) {
                    resultValue.set((Object)((JSQualifiedNamedElement)qualifierResult));
                    return true;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return resultValue.get() != null;
            }
        };
        visitor.processQualifier(JSQualifiedNameImpl.fromQualifiedName(type));
        return resultValue.get() == null ? "" : ((JSQualifiedNamedElement)resultValue.get()).getQualifiedName();
    }

    @NotNull
    private static Set<? extends PsiElement> resolveTypeElements(@NotNull JSQualifiedName qualifiedName, @NotNull PsiElement source, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited, boolean typeContext) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        final THashSet result = new THashSet();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.source = source;
        visitor.typeContext = typeContext;
        visitor.visited = visited;
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                result.add((Object)qualifierResult);
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };
        visitor.processQualifier(qualifiedName);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        return tHashSet;
    }

    private static boolean findReferencedElements(@NotNull String name, @NotNull PsiElement source, boolean localResolve, TypeScriptElementVisitor accumulatedElementsVisitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "findReferencedElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "findReferencedElements"));
        }
        boolean strictTypeContext = accumulatedElementsVisitor.isStrictTypeContext();
        Collection<? extends PsiElement> localResults = TypeScriptImportHandler.getLocalResults(name, source, localResolve, accumulatedElementsVisitor);
        boolean methodAccepted = false;
        for (PsiElement psiElement : localResults) {
            if (strictTypeContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(psiElement)) continue;
            boolean accepted = false;
            if (psiElement instanceof TypeScriptImportStatement) {
                TypeScriptExternalModuleReference externalModuleReference = ((TypeScriptImportStatement)psiElement).getExternalModuleReference();
                TypeScriptEntityName internalModuleReference = ((TypeScriptImportStatement)psiElement).getInternalModuleReference();
                if (externalModuleReference != null) {
                    ResolveResult[] resolveResults;
                    for (ResolveResult resolveResult : resolveResults = externalModuleReference.multiResolve()) {
                        PsiElement resolve = resolveResult.getElement();
                        if (resolve == null || !TypeScriptPsiUtil.isTopLevelContainer(resolve)) continue;
                        TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
                        if (exportAssignment != null) {
                            accepted = TypeScriptImportHandler.processAssignExpression((JSExportAssignment)exportAssignment, accumulatedElementsVisitor);
                            continue;
                        }
                        if (accumulatedElementsVisitor.accept(resolve)) {
                            return true;
                        }
                        accepted = true;
                    }
                } else if (internalModuleReference != null) {
                    accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(internalModuleReference.multiResolve(false)), accumulatedElementsVisitor, ContainerUtil.newHashSet());
                }
            } else if (psiElement instanceof TypeScriptModule) {
                String qName = ((TypeScriptModule)psiElement).getQualifiedName();
                if (qName != null) {
                    accumulatedElementsVisitor.accept(psiElement);
                    accepted = true;
                }
            } else if (TypeScriptImportHandler.isImport(psiElement)) {
                accepted = TypeScriptImportHandler.resolveImport(psiElement, accumulatedElementsVisitor, ContainerUtil.newHashSet());
            }
            if (!accepted && accumulatedElementsVisitor.accept(psiElement)) {
                return true;
            }
            methodAccepted = true;
        }
        return methodAccepted;
    }

    @NotNull
    private static TypeScriptResolveProcessor createProcessor(@NotNull String name, @NotNull PsiElement source, TypeScriptElementVisitor accumulatedElementsVisitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "createProcessor"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "createProcessor"));
        }
        TypeScriptResolveProcessor processor = new TypeScriptResolveProcessor(name, source.getContainingFile(), accumulatedElementsVisitor.getSource());
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.setProcessingOptions(OPTIONS);
        if (accumulatedElementsVisitor.isStrictTypeContext()) {
            processor.setStrictTypeContainerContext(true);
        }
        processor.setToProcessHierarchy(false);
        TypeScriptResolveProcessor typeScriptResolveProcessor = processor;
        if (typeScriptResolveProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "createProcessor"));
        }
        return typeScriptResolveProcessor;
    }

    private static Collection<PsiElement> convertToPsiElements(ResolveResult[] results) {
        return ContainerUtil.mapNotNull((Object[])results, (Function)new Function<ResolveResult, PsiElement>(){

            public PsiElement fun(ResolveResult result) {
                return result.getElement();
            }
        });
    }

    private static boolean isImport(PsiElement element) {
        return element instanceof ES6ImportSpecifier || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportSpecifierAlias || element instanceof JSExportAssignment;
    }

    private static boolean resolveImport(PsiElement element, TypeScriptElementVisitor accumulatedElementsVisitor, Set<PsiElement> visited) {
        if (visited != null && !visited.add(element)) {
            return false;
        }
        boolean accepted = false;
        if (element instanceof TypeScriptImportStatement) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(((TypeScriptImportStatement)element).findReferencedElements(), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportSpecifier) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(((ES6ImportSpecifier)element).resolveOverAliases()), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportedBinding) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(((ES6ImportedBinding)element).findReferencedElements(), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportSpecifierAlias) {
            ES6ImportExportSpecifier specifier = ((ES6ImportSpecifierAlias)element).findSpecifierElement();
            if (specifier != null) {
                accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(specifier.resolveOverAliases()), accumulatedElementsVisitor, visited);
            } else {
                if (accumulatedElementsVisitor.accept(element)) {
                    return true;
                }
                accepted = true;
            }
        } else if (element instanceof JSExportAssignment) {
            accepted = TypeScriptImportHandler.processAssignExpression((JSExportAssignment)element, accumulatedElementsVisitor);
        }
        return accepted;
    }

    private static boolean processWithResolveImportReferences(Collection<? extends PsiElement> elements, TypeScriptElementVisitor accumulatedElementsVisitor, Set<PsiElement> visited) {
        boolean accepted = false;
        for (PsiElement psiElement : elements) {
            if (TypeScriptImportHandler.isImport(psiElement)) {
                accepted = TypeScriptImportHandler.resolveImport(psiElement, accumulatedElementsVisitor, visited);
                continue;
            }
            if (accumulatedElementsVisitor.accept(psiElement)) {
                return true;
            }
            accepted = true;
        }
        return accepted;
    }

    public static boolean isSimpleRefWithoutQualifier(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "isSimpleRefWithoutQualifier"));
        }
        return expression.getQualifier() == null && !StringUtil.isEmpty((String)expression.getReferenceName());
    }

    @NotNull
    private static Collection<? extends PsiElement> getLocalResults(@NotNull String name, @NotNull PsiElement source, boolean localResolve, TypeScriptElementVisitor accumulatedElementsVisitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
        }
        PsiElement moduleParent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)source, (Class[])new Class[]{TypeScriptModule.class, PsiFile.class});
        PsiElement module = moduleParent;
        boolean isExternalModule = module instanceof JSFile && ((JSFile)module).isCommonJSModule();
        boolean isModule = module instanceof TypeScriptModule || isExternalModule;
        PsiElement parent = source.getParent();
        Collection<? extends PsiElement> localElements = TypeScriptImportHandler.getLocalClassesIfExists(name, source, localResolve, accumulatedElementsVisitor, module, parent);
        if (localElements != null) {
            ArrayList elements = ContainerUtil.newArrayList(localElements);
            TypeScriptImportHandler.filterAndAddGlobalResolvedElements(source, accumulatedElementsVisitor, elements, TypeScriptImportHandler.getQualifiedNameForModule(name, module), true);
            ArrayList arrayList = elements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
            }
            return arrayList;
        }
        TypeScriptResolveProcessor processor = TypeScriptImportHandler.createProcessor(name, source, accumulatedElementsVisitor);
        List result = ContainerUtil.newSmartList();
        while (module != null) {
            module.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), module, moduleParent);
            List<PsiElement> elements = processor.getResults();
            if (localResolve) {
                if (elements != null && !elements.isEmpty()) {
                    List<PsiElement> list = elements;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
                    }
                    return list;
                }
            } else {
                if (elements != null) {
                    ArrayList notPublic = null;
                    if (isExternalModule && !elements.isEmpty()) {
                        List<PsiElement> list = elements;
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
                        }
                        return list;
                    }
                    for (PsiElement element : elements) {
                        JSAttributeList list;
                        if (TypeScriptImportHandler.isImportOrBinding(element)) {
                            result.add(element);
                        }
                        if (!(element instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)element).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptImportHandler.isRealModuleOfImplicitModule(module, element)) continue;
                        if (notPublic == null) {
                            notPublic = ContainerUtil.newArrayList();
                        }
                        notPublic.add(element);
                    }
                    if (!accumulatedElementsVisitor.isQualifier() && isModule && !ContainerUtil.isEmpty(notPublic)) {
                        ArrayList arrayList = notPublic;
                        if (arrayList == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
                        }
                        return arrayList;
                    }
                }
                String qName = TypeScriptImportHandler.getQualifiedNameForModule(name, module);
                TypeScriptImportHandler.filterAndAddGlobalResolvedElements(source, accumulatedElementsVisitor, result, qName, false);
            }
            if (!accumulatedElementsVisitor.isQualifier() && !result.isEmpty()) break;
            module = TypeScriptImportHandler.getParentModuleOrFile(module);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalResults"));
        }
        return list;
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameForModule"));
        }
        return module instanceof TypeScriptModule ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    @Nullable
    private static JSElement getParentModuleOrFile(PsiElement module) {
        return module instanceof PsiFile ? null : (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)module, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    private static boolean isImportOrBinding(PsiElement element) {
        return element instanceof ES6ImportSpecifier || element instanceof ES6ImportSpecifierAlias || element instanceof ES6ImportedBinding;
    }

    private static void filterAndAddGlobalResolvedElements(@NotNull PsiElement source, final TypeScriptElementVisitor accumulatedElementsVisitor, Collection<PsiElement> result, String qName, final boolean modulesOnly) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "filterAndAddGlobalResolvedElements"));
        }
        result.addAll(ContainerUtil.filter(TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(qName, source), (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                if (modulesOnly && !(element instanceof TypeScriptModule)) {
                    return false;
                }
                PsiElement place = accumulatedElementsVisitor.getSource();
                return TypeScriptModuleAccessibilityChecker.INSTANCE.check(place, element) == null && TypeScriptConfigAccessibilityChecker.INSTANCE.check(place, element) == null && ES6ImportAccessibilityChecker.INSTANCE.check(place, element) == null;
            }
        }));
    }

    @Nullable
    private static Collection<? extends PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, boolean localResolve, TypeScriptElementVisitor accumulatedElementsVisitor, PsiElement module, PsiElement parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalClassesIfExists"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getLocalClassesIfExists"));
        }
        if (!localResolve && module != parent && module != source && !accumulatedElementsVisitor.isQualifier()) {
            TypeScriptResolveProcessor processor = TypeScriptImportHandler.createProcessor(name, source, accumulatedElementsVisitor);
            JSResolveUtil.treeWalkUp(processor, source, null, source, module);
            List<PsiElement> results = processor.getResults();
            if (results != null) {
                for (PsiElement element : results) {
                    if (!(element instanceof JSClass) || TypeScriptPsiUtil.isTopLevelContainerMember(element)) continue;
                    return ContainerUtil.createMaybeSingletonList((Object)element);
                }
            }
        }
        return null;
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    private static boolean processAssignExpression(JSExportAssignment assignment, TypeScriptElementVisitor accumulatedElementsVisitor) {
        boolean accepted = false;
        String referenceName = assignment.getInitializerReference();
        if (referenceName != null) {
            JSTypeResolveResult result = TypeScriptImportHandler.resolveNameImpl(referenceName, (PsiElement)assignment, accumulatedElementsVisitor.isStrictTypeContext(), accumulatedElementsVisitor.visited());
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(result.getElements(), accumulatedElementsVisitor, ContainerUtil.newHashSet());
        } else {
            JSExpression assignmentExpression = assignment.getExpression();
            if (assignmentExpression instanceof JSClassExpression) {
                accumulatedElementsVisitor.accept((PsiElement)assignmentExpression);
                return true;
            }
            if (assignmentExpression instanceof JSReferenceExpression) {
                return TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(((JSReferenceExpression)assignmentExpression).multiResolve(false)), accumulatedElementsVisitor, ContainerUtil.newHashSet());
            }
        }
        return accepted;
    }

    @NotNull
    public static String resolveClassNameInParentModules(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveClassNameInParentModules"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveClassNameInParentModules"));
        }
        int firstDotIndex = type.indexOf(46);
        String name = firstDotIndex >= 0 ? type.substring(0, firstDotIndex) : type;
        JSElement context = TypeScriptImportHandler.getParentModuleOrFile(source);
        while (context != null) {
            Collection<JSElement> results = JSResolveUtil.findNamedElementsInScope(name, context);
            for (JSElement result : results) {
                String resultQName;
                if (!(result instanceof JSClass) || (resultQName = ((JSClass)result).getQualifiedName()) == null) continue;
                String string = firstDotIndex >= 0 && firstDotIndex < type.length() ? resultQName + "." + type.substring(firstDotIndex + 1) : resultQName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveClassNameInParentModules"));
                }
                return string;
            }
            context = TypeScriptImportHandler.getParentModuleOrFile((PsiElement)context);
        }
        String string = type;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveClassNameInParentModules"));
        }
        return string;
    }

    private static final class SubTypeVisitor
    implements TypeScriptHierarchyVisitor {
        private TypeScriptHierarchyVisitor parent;
        private PsiElement source;
        private String name;
        private Set<Pair<JSQualifiedName, PsiElement>> visited;
        private boolean typeContext;
        private boolean isQualifier = false;

        private SubTypeVisitor() {
        }

        private TypeScriptElementVisitor createSimpleExpressionVisitor() {
            return new TypeScriptElementVisitor(){
                private THashSet<PsiElement> accepted;

                @Override
                public boolean accept(PsiElement element) {
                    if (this.accepted == null) {
                        this.accepted = new THashSet();
                    }
                    if (!this.accepted.add((Object)element)) {
                        return false;
                    }
                    return SubTypeVisitor.this.parent.accept(element);
                }

                @Override
                public PsiElement getSource() {
                    return SubTypeVisitor.this.source;
                }

                @Override
                public boolean isStrictTypeContext() {
                    return SubTypeVisitor.this.typeContext;
                }

                @Override
                public boolean isQualifier() {
                    return SubTypeVisitor.this.isQualifier;
                }

                @Override
                public Set<Pair<JSQualifiedName, PsiElement>> visited() {
                    return SubTypeVisitor.this.visited;
                }
            };
        }

        @Override
        public boolean accept(PsiElement qualifierResult) {
            if (qualifierResult instanceof TypeScriptModule || qualifierResult instanceof JSFile) {
                TypeScriptImportHandler.findReferencedElements(this.name, qualifierResult, true, this.createSimpleExpressionVisitor());
            }
            return this.parent.isDone();
        }

        public SubTypeVisitor createSubVisitor() {
            SubTypeVisitor visitor = new SubTypeVisitor();
            visitor.parent = this;
            visitor.source = this.source;
            visitor.visited = this.visited;
            visitor.isQualifier = true;
            return visitor;
        }

        public void processQualifier(JSQualifiedName qualifiedName) {
            if (!this.visited.add((Pair<JSQualifiedName, PsiElement>)Pair.create((Object)qualifiedName, (Object)this.source))) {
                return;
            }
            this.name = qualifiedName.getName();
            JSQualifiedName qualifier = qualifiedName.getParent();
            if (qualifier != null) {
                this.createSubVisitor().processQualifier(qualifier);
            } else {
                TypeScriptImportHandler.findReferencedElements(this.name, this.source, false, this.createSimpleExpressionVisitor());
            }
        }

        @Override
        public boolean isDone() {
            return this.parent.isDone();
        }
    }

    private static interface TypeScriptHierarchyVisitor {
        public boolean accept(PsiElement var1);

        public boolean isDone();
    }

    private static interface TypeScriptElementVisitor {
        public boolean accept(PsiElement var1);

        @Nullable
        public PsiElement getSource();

        public boolean isStrictTypeContext();

        public boolean isQualifier();

        public Set<Pair<JSQualifiedName, PsiElement>> visited();
    }
}

