/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeEvaluator
extends ES6TypeEvaluator {
    public TypeScriptTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor, boolean ecma) {
        super(context, processor, ecma);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptPropertySignature) {
            JSTypeDeclaration propertyType = ((TypeScriptPropertySignature)resolveResult).getType();
            if (propertyType instanceof JSFunction) {
                this.processFunction((JSFunction)propertyType);
            } else if (propertyType != null) {
                JSType jsType = TypeScriptTypeParser.buildTypeFromTypeScript(propertyType);
                this.addType(jsType, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof TypeScriptModule) {
            this.addTypeFromModule((TypeScriptModule)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptImportStatement) {
            this.addTypeFromImportStatement((TypeScriptImportStatement)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptCallSignature) {
            JSElement peek = this.myContext.peekJSElementToApply();
            if (peek instanceof JSCallExpression) {
                this.myContext.popJSElementToApply();
                this.addType(((TypeScriptCallSignature)resolveResult).getReturnType(), resolveResult);
                this.myContext.pushJSElementToApply(peek);
            }
            return true;
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    private void addTypeFromModule(TypeScriptModule resolveResult) {
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        boolean hasType = false;
        String name = resolveResult.getName();
        if (name != null && this.myTypeProcessor instanceof PsiScopeProcessor) {
            Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)expression).getElements();
            for (PsiElement psiElement : elements) {
                if (psiElement.isEquivalentTo((PsiElement)resolveResult)) continue;
                if (TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                    hasType = true;
                    continue;
                }
                this.addTypeFromResolveResult(psiElement, false);
            }
        }
        boolean isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression);
        if (!(this.myTypeProcessor instanceof PsiScopeProcessor) || isJavaScriptContext || hasType || !this.isPrototypeOrNewExpression() && !(this.myContext.peekJSElementToApply() instanceof JSCallExpression)) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)resolveResult, isJavaScriptContext);
        }
    }

    private void addTypeFromLocalModule(@NotNull JSQualifiedNamedElement resolveResult, boolean isJavaScriptContext) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromLocalModule"));
        }
        String name = resolveResult.getQualifiedName();
        if (!StringUtil.isEmpty((String)name)) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult.getParent(), true);
            JSType jsType = JSNamedType.createType(name, source, isJavaScriptContext ? JSContext.UNKNOWN : JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromImportStatement(TypeScriptImportStatement resolveResult) {
        if (this.myContext.isAlreadyProcessingItem((PsiElement)resolveResult)) {
            return;
        }
        this.myContext.addProcessingItem((PsiElement)resolveResult);
        TypeScriptEntityName internalModuleReference = resolveResult.getInternalModuleReference();
        TypeScriptExternalModuleReference externalModuleReference = resolveResult.getExternalModuleReference();
        if (internalModuleReference != null) {
            ResolveResult[] results;
            for (ResolveResult r : results = internalModuleReference.multiResolve(false)) {
                PsiElement element = r.getElement();
                if (element == null) continue;
                this.addTypeFromResolveResult(element, false);
            }
        } else if (externalModuleReference != null) {
            ResolveResult[] resolveResults;
            for (ResolveResult externalModuleResolveResult : resolveResults = externalModuleReference.multiResolve()) {
                PsiElement element = externalModuleResolveResult.getElement();
                if (element == null) continue;
                this.addTypeFromExternalModuleReferenceResolveResult(element);
            }
        }
        this.myContext.removeProcessingItem((PsiElement)resolveResult);
    }

    @Override
    protected boolean qualifierTypeIsExplicitlyDeclared(@Nullable JSExpression qualifier) {
        JSType qualifierType;
        if (qualifier == null || !DialectDetector.isTypeScript((PsiElement)qualifier)) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression) {
            PsiElement resolve = TypeScriptPsiUtil.resolveViaImports((JSReferenceExpression)qualifier);
            if (resolve instanceof TypeScriptModule) {
                return true;
            }
            if (resolve instanceof ES6ImportedBinding && ((ES6ImportedBinding)resolve).isNamespaceImport()) {
                return true;
            }
        }
        return (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && !(qualifierType instanceof JSAnyType) && qualifierType.getSource().isExplicitlyDeclared();
    }

    @Override
    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve != null && DialectDetector.isTypeScript(resolve)) {
            PsiFile file = resolve.getContainingFile();
            if (file == null) {
                return;
            }
            TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
            if (resolve instanceof JSFile) {
                this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
                if (exportAssignment == null) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolve, true);
                    this.addType(new JSGlobalTypeImpl(typeSource), JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT);
                }
            } else if (resolve instanceof TypeScriptModule && exportAssignment == null) {
                this.addTypeFromResolveResult(resolve, true);
            }
            if (exportAssignment != null) {
                this.evaluateExportAssignment((JSExportAssignment)exportAssignment);
            }
        } else {
            super.addTypeFromExternalModuleReferenceResolveResult(resolve);
        }
    }

    @Override
    protected void evaluateExportAssignment(JSExportAssignment assignment) {
        PsiElement element;
        String reference;
        if (assignment instanceof TypeScriptExportAssignment && (reference = assignment.getInitializerReference()) != null && (element = JSStubBasedPsiTreeUtil.resolveLocally(reference, (PsiElement)assignment)) != null) {
            JSReferenceExpression expression = this.myContext.getProcessedExpression();
            this.addTypeFromResolveResult(element, false);
            if (this.myTypeProcessor instanceof PsiScopeProcessor && element instanceof JSQualifiedNamedElement && expression != null && (element.getContainingFile() != expression.getContainingFile() || !TypeScriptTypeEvaluator.hasInnerDeclarations(element))) {
                this.addIdenticalNameElements((PsiElement)assignment, element, ((JSQualifiedNamedElement)element).getQualifiedName());
            }
            return;
        }
        super.evaluateExportAssignment(assignment);
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        TypeScriptType typeScriptType;
        if (rawqualifier instanceof TypeScriptCastExpression && (typeScriptType = ((TypeScriptCastExpression)rawqualifier).getType()) != null) {
            JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeScriptType);
            this.addType(type, (PsiElement)rawqualifier);
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawqualifier);
    }

    @Override
    protected void addTypeFromClassExpression(@NotNull JSClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromClassExpression"));
        }
        this.addTypeFromClass((PsiElement)aClass);
    }

    @Override
    protected void addTypeFromClass(PsiElement resolveResult) {
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        if (resolveResult instanceof TypeScriptInterface && processedExpression != null) {
            this.processAllIdenticallyNamedElements((PsiElement)processedExpression, resolveResult);
        } else if (resolveResult instanceof JSClass) {
            JSRecordTypeImpl type;
            String qName = ((JSClass)resolveResult).getQualifiedName();
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            if (qName == null) {
                type = TypeScriptTypeParser.buildTypeFromClass((JSClass)resolveResult, true);
            } else {
                JSContext staticOrInstance = this.isPrototypeOrNewExpression() ? JSContext.INSTANCE : JSContext.STATIC;
                type = JSNamedType.createType(qName, typeSource, staticOrInstance);
            }
            PsiElement source = this.getSourceForTypeContext(resolveResult, processedExpression);
            this.addType(type, source);
        } else if (resolveResult instanceof JSFunction) {
            JSType returnType;
            if (resolveResult.getParent() instanceof TypeScriptInterface && (returnType = ((JSFunction)resolveResult).getReturnType()) != null) {
                this.addType(returnType, resolveResult);
            } else {
                this.addTypeFromClass(resolveResult.getParent());
            }
        }
    }

    private PsiElement getSourceForTypeContext(PsiElement resolveResult, JSReferenceExpression processedExpression) {
        return processedExpression != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)this.myContext.targetFile) ? processedExpression : resolveResult;
    }

    private void processAllIdenticallyNamedElements(@NotNull PsiElement expression, @NotNull PsiElement resolveResult) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processAllIdenticallyNamedElements"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processAllIdenticallyNamedElements"));
        }
        if (!(this.myTypeProcessor instanceof PsiScopeProcessor)) {
            return;
        }
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            ((ResolveProcessor)((Object)this.myTypeProcessor)).prefixResolved();
        }
        boolean result = true;
        if (!this.skipCallContextIfModule(resolveResult) && TypeScriptTypeEvaluator.hasInnerDeclarations(resolveResult)) {
            result = JSResolveUtil.processDeclarationsInScope((JSElement)((JSQualifiedNamedElement)resolveResult), (PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), resolveResult, expression);
        }
        if (result && resolveResult.getContainingFile() == expression.getContainingFile()) {
            String name = ((JSQualifiedNamedElement)resolveResult).getQualifiedName();
            if (name == null) {
                return;
            }
            this.addIdenticalNameElements(expression, resolveResult, name);
        }
    }

    private void addIdenticalNameElements(@NotNull PsiElement expression, @Nullable PsiElement resolveResult, String name) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addIdenticalNameElements"));
        }
        Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, expression).getElements();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || psiElement.equals(resolveResult) || this.skipCallContextIfModule(psiElement)) continue;
            if (!TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                this.addTypeFromResolveResult(psiElement, false);
                continue;
            }
            if (!(this.myTypeProcessor instanceof PsiScopeProcessor) || psiElement.processDeclarations((PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), psiElement, expression)) continue;
            break;
        }
    }

    private static boolean hasInnerDeclarations(PsiElement element) {
        return !(element instanceof JSVariable) && !(element instanceof JSFunction);
    }

    private boolean skipCallContextIfModule(PsiElement resolveResult) {
        return resolveResult instanceof TypeScriptModule && !this.myContext.isJSElementsToApplyEmpty() && !(this.myContext.peekJSElementToApply() instanceof JSNewExpression);
    }

    @Override
    protected void addTypeFromES6ImportBindingReference(PsiElement referencedElement) {
        if (referencedElement instanceof TypeScriptModule) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)((TypeScriptModule)referencedElement), false);
        } else if (referencedElement instanceof ES6ExportDefaultAssignment && ((ES6ExportDefaultAssignment)referencedElement).getExpression() instanceof TypeScriptClass) {
            TypeScriptClass tsClass = (TypeScriptClass)((ES6ExportDefaultAssignment)referencedElement).getExpression();
            if (tsClass != null) {
                this.myTypeProcessor.processResolvedElement((PsiElement)tsClass.getContainingFile(), this.myContext);
                this.addTypeFromResolveResult((PsiElement)tsClass, false);
            }
        } else {
            super.addTypeFromES6ImportBindingReference(referencedElement);
        }
    }

    @Override
    @Nullable
    protected JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        JSType expressionTypeType;
        JSExpression expression;
        JSTypeEvaluationResult expressionTypeResult;
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSArrayType || type == null) {
            return super.addComponentTypeFromProcessor(rawqualifier, type);
        }
        if (!(rawqualifier instanceof JSIndexedPropertyAccessExpression)) {
            return super.addComponentTypeFromProcessor(rawqualifier, type);
        }
        JSRecordType recordType = type.asRecordType();
        if (recordType.getTypeMembers().isEmpty()) {
            return super.addComponentTypeFromProcessor(rawqualifier, type);
        }
        ArrayList indexSignatures = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
            if (!(member instanceof JSRecordTypeImpl.IndexSignature)) continue;
            indexSignatures.add((JSRecordTypeImpl.IndexSignature)member);
        }
        JSAnyType result = null;
        if (indexSignatures.size() > 0 && (expressionTypeResult = JSTypeEvaluator.getExpressionType(expression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression())) != null && (expressionTypeType = expressionTypeResult.getType()) != null) {
            for (JSRecordTypeImpl.IndexSignature signature : indexSignatures) {
                if (!JSResolveUtil.isAssignableJSType(signature.getParameterType(), expressionTypeType)) continue;
                result = signature.getType();
                break;
            }
        }
        if (result == null) {
            result = JSAnyType.get((PsiElement)rawqualifier, false);
        }
        this.addType(result, (PsiElement)rawqualifier);
        return result;
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromLiteralExpression"));
        }
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier instanceof JSXmlLiteralExpressionImpl) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, true), (PsiElement)rawqualifier);
            return;
        }
        super.addTypeFromLiteralExpression(rawqualifier);
    }

    @Override
    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        ResolveResult[] resolveResult = super.getResolveResultsFromQualifier(qualifier);
        boolean hasModules = false;
        for (ResolveResult result : resolveResult) {
            if (!(result.getElement() instanceof TypeScriptModule)) continue;
            hasModules = true;
            break;
        }
        if (!hasModules) {
            if (resolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
            }
            return resolveResult;
        }
        ArrayList newResults = ContainerUtil.newArrayListWithCapacity((int)resolveResult.length);
        HashSet visitedQualifiers = ContainerUtil.newHashSet();
        for (ResolveResult result : resolveResult) {
            PsiElement element = result.getElement();
            if (!(element instanceof TypeScriptModule)) {
                newResults.add(result);
                continue;
            }
            TypeScriptModule module = (TypeScriptModule)element;
            if (!visitedQualifiers.add(module.getQualifiedName())) continue;
            newResults.add(result);
        }
        ResolveResult[] resolveResultArray = newResults.size() == resolveResult.length ? resolveResult : (ResolveResult[])ContainerUtil.toArray((List)newResults, (Object[])new ResolveResult[newResults.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        return resolveResultArray;
    }
}

