/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.refactoring.JSRefactoringFilterProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStatementUpDownMover
extends LineMover {
    private PsiElement myBlockStatementContainer = null;
    private boolean myShouldAddComma = false;

    public boolean checkAvailable(final @NotNull Editor editor, @NotNull PsiFile file, final @NotNull StatementUpDownMover.MoveInfo info, final boolean down) {
        JSRefactoringFilterProvider refactoringFilterProvider;
        PsiLanguageInjectionHost languageInjectionHost;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "checkAvailable"));
        }
        if (!(file instanceof JSFile) && !(file instanceof XmlFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        this.myBlockStatementContainer = null;
        this.myShouldAddComma = false;
        if (file instanceof XmlFile && (languageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiLanguageInjectionHost.class)) != null) {
            Document document = editor.getDocument();
            int movedLineStartOffset = document.getLineStartOffset(info.toMove.startLine);
            TextRange possibleInjectionRange = languageInjectionHost.getTextRange();
            if (info.toMove.endLine < document.getLineCount() && possibleInjectionRange.containsRange(movedLineStartOffset, document.getLineStartOffset(info.toMove.endLine)) && info.toMove2.endLine < document.getLineCount() && possibleInjectionRange.containsRange(document.getLineStartOffset(info.toMove2.startLine), document.getLineStartOffset(info.toMove2.endLine))) {
                final Ref result = new Ref();
                InjectedLanguageUtil.enumerate((PsiElement)languageInjectionHost, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/lang/javascript/editing/JSStatementUpDownMover$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/lang/javascript/editing/JSStatementUpDownMover$1", "visit"));
                        }
                        if (injectedPsi instanceof JSFile) {
                            StatementUpDownMover.MoveInfo myInfo = new StatementUpDownMover.MoveInfo();
                            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)injectedPsi);
                            int lineNumberDiff = editor.getDocument().getLineNumber(editor.getCaretModel().getOffset()) - injectedEditor.getDocument().getLineNumber(injectedEditor.getCaretModel().getOffset());
                            myInfo.toMove = new LineRange(info.toMove.startLine - lineNumberDiff, info.toMove.endLine - lineNumberDiff);
                            myInfo.toMove2 = new LineRange(info.toMove2.startLine - lineNumberDiff, info.toMove2.endLine - lineNumberDiff);
                            if (JSStatementUpDownMover.this.canMoveIt(injectedEditor, injectedPsi, myInfo, down)) {
                                myInfo.toMove = new LineRange(myInfo.toMove.startLine + lineNumberDiff, myInfo.toMove.endLine + lineNumberDiff);
                                myInfo.toMove2 = new LineRange(myInfo.toMove2.startLine + lineNumberDiff, myInfo.toMove2.endLine + lineNumberDiff);
                                result.set((Object)myInfo);
                            }
                        }
                    }
                });
                StatementUpDownMover.MoveInfo newInfo = (StatementUpDownMover.MoveInfo)result.get();
                if (newInfo != null) {
                    info.toMove = newInfo.toMove;
                    info.toMove2 = newInfo.toMove2;
                    return true;
                }
            }
        }
        if ((refactoringFilterProvider = (JSRefactoringFilterProvider)JSRefactoringFilterProvider.INSTANCE.forLanguage(file.getLanguage())) == null) {
            refactoringFilterProvider = JSRefactoringFilterProvider.DEFAULT_INSTANCE;
        }
        if (!refactoringFilterProvider.isRefactoringEnabled(JSStatementUpDownMover.class)) {
            return false;
        }
        return this.canMoveIt(editor, file, info, down);
    }

    private boolean canMoveIt(Editor editor, PsiFile file, StatementUpDownMover.MoveInfo info, boolean down) {
        int lineNumber;
        Document document = editor.getDocument();
        if (JSStatementUpDownMover.isSameNode(file, info, document, down)) {
            return false;
        }
        Couple<PsiElement> movedRange = JSStatementUpDownMover.elementRange(editor, file, info.toMove, StatementSelectionMode.DOWN);
        if (JSStatementUpDownMover.isNotValidStatementRange(movedRange)) {
            return false;
        }
        if (!down) {
            this.checkNeedToAddComma(movedRange, movedRange);
        }
        LineRange oldToMove = info.toMove;
        info.toMove = new LineRange(JSStatementUpDownMover.expandRangeBefore((PsiElement)movedRange.first), JSStatementUpDownMover.expandRangeAfter((PsiElement)movedRange.second, true), document);
        info.toMove = new LineRange(Math.min(oldToMove.startLine, info.toMove.startLine), Math.max(info.toMove.endLine, oldToMove.endLine));
        StatementSelectionMode selectionMode = StatementSelectionMode.DOWN;
        if (down) {
            lineNumber = info.toMove.endLine;
            if (lineNumber != info.toMove2.startLine) {
                info.toMove2 = new LineRange(lineNumber, Math.min(lineNumber + 1, document.getLineCount()));
            }
        } else {
            lineNumber = info.toMove.startLine;
            if (lineNumber != info.toMove2.endLine) {
                info.toMove2 = new LineRange(Math.max(0, lineNumber - 1), lineNumber);
                selectionMode = StatementSelectionMode.UP;
            } else {
                int lineStartOffset = document.getLineStartOffset(info.toMove2.startLine);
                int firstNonWs = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t\n");
                if (document.getLineNumber(firstNonWs) != info.toMove2.startLine) {
                    selectionMode = StatementSelectionMode.UP;
                }
            }
        }
        Couple<PsiElement> destinationRange = JSStatementUpDownMover.elementRange(editor, file, info.toMove2, selectionMode);
        if (JSStatementUpDownMover.isNotValidStatementRange(destinationRange)) {
            return false;
        }
        if (down) {
            this.checkNeedToAddComma(destinationRange, movedRange);
        }
        boolean shouldWeJumpOverNextStatement = false;
        TextRange firstElementRange = ((PsiElement)destinationRange.first).getTextRange();
        if (JSStatementUpDownMover.isBlockStatementContainer((PsiElement)destinationRange.first)) {
            JSStatement elseBranch;
            ASTNode blockNode = ((PsiElement)destinationRange.first).getNode().findChildByType((IElementType)JSElementTypes.BLOCK_STATEMENT);
            if (blockNode == null) {
                this.myBlockStatementContainer = (PsiElement)destinationRange.first;
            }
            TextRange blockHeaderRange = JSStatementUpDownMover.blockHeaderRange(blockNode);
            TextRange additionalBlockHeaderRange = null;
            if (destinationRange.first instanceof JSIfStatement && (elseBranch = ((JSIfStatement)destinationRange.first).getElse()) instanceof JSBlockStatement && (additionalBlockHeaderRange = JSStatementUpDownMover.blockHeaderRange(elseBranch != null ? elseBranch.getNode() : null)) != null) {
                additionalBlockHeaderRange = new TextRange(blockNode.findChildByType(JSTokenTypes.RBRACE).getStartOffset(), additionalBlockHeaderRange.getEndOffset());
            }
            if (blockHeaderRange != null) {
                TextRange targetRange = new TextRange(document.getLineStartOffset(info.toMove2.startLine), document.getLineStartOffset(info.toMove2.endLine));
                if (blockHeaderRange.intersects(targetRange)) {
                    int start = document.getLineNumber(blockHeaderRange.getStartOffset());
                    int end = JSStatementUpDownMover.advanceToRange(document, blockHeaderRange.getEndOffset());
                    info.toMove2 = new LineRange(start, end);
                } else if (additionalBlockHeaderRange != null && additionalBlockHeaderRange.intersects(targetRange)) {
                    int start = document.getLineNumber(additionalBlockHeaderRange.getStartOffset());
                    int end = JSStatementUpDownMover.advanceToRange(document, additionalBlockHeaderRange.getEndOffset());
                    info.toMove2 = new LineRange(start, end);
                }
            }
        } else {
            boolean bl = shouldWeJumpOverNextStatement = !firstElementRange.contains(((PsiElement)movedRange.first).getTextRange());
        }
        if (shouldWeJumpOverNextStatement && (destinationRange.first instanceof JSStatement && JSStatementUpDownMover.isFunExpr((JSStatement)destinationRange.first) || destinationRange.first instanceof JSFunction)) {
            if (movedRange.first instanceof JSStatement && !JSStatementUpDownMover.isFunExpr((JSStatement)movedRange.first)) {
                shouldWeJumpOverNextStatement = false;
            }
            if (shouldWeJumpOverNextStatement) {
                Couple<PsiElement> range = JSStatementUpDownMover.findElementRange(editor, file, info.toMove2, StatementSelectionMode.DOWN);
                if (down && range.second != null && "{".equals(((PsiElement)range.second).getText()) || !down && range.first != null && "}".equals(((PsiElement)range.first).getText())) {
                    PsiElement element = ((PsiElement)destinationRange.first).getParent();
                    boolean bl = shouldWeJumpOverNextStatement = element instanceof JSFile || element instanceof JSClass || element instanceof JSEmbeddedContent;
                }
            }
        }
        if (shouldWeJumpOverNextStatement) {
            PsiElement startElement = down ? (PsiElement)destinationRange.first : JSStatementUpDownMover.expandRangeBefore((PsiElement)destinationRange.first);
            PsiElement endElement = JSStatementUpDownMover.expandRangeAfter((PsiElement)destinationRange.second, false);
            if (startElement != null && endElement != null && startElement.getTextRange().getEndOffset() > endElement.getTextRange().getEndOffset()) {
                Logger.getInstance((String)((Object)((Object)this)).getClass().getName()).error("Unexpected move expansion:" + startElement.getText() + "--,--" + endElement.getText());
                endElement = startElement;
            }
            info.toMove2 = new LineRange(startElement, endElement, document);
        }
        return !(down ? info.toMove.endLine > info.toMove2.startLine : info.toMove.startLine < info.toMove2.endLine);
    }

    private static boolean isFunExpr(JSStatement statement) {
        JSVariable[] variables;
        if (statement instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)statement).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                return ((JSAssignmentExpression)expression).getROperand() instanceof JSFunctionExpression;
            }
        } else if (statement instanceof JSVarStatement && (variables = ((JSVarStatement)statement).getVariables()).length == 1 && variables[0].getInitializer() instanceof JSFunctionExpression) {
            return true;
        }
        return false;
    }

    private void checkNeedToAddComma(@NotNull Couple<PsiElement> range, Couple<PsiElement> movedRange) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "checkNeedToAddComma"));
        }
        if (range.second instanceof JSExpression) {
            if (PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)range.second), JSExpression.class) == null && TreeUtil.findSibling((ASTNode)((PsiElement)range.second).getNode(), (IElementType)JSTokenTypes.COMMA) == null) {
                this.myShouldAddComma = true;
            }
        } else if (range.second instanceof JSProperty && PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)range.second), JSProperty.class) == null && TreeUtil.findSibling((ASTNode)((PsiElement)range.second).getNode(), (IElementType)JSTokenTypes.COMMA) == null) {
            this.myShouldAddComma = true;
        }
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "beforeMove"));
        }
        super.beforeMove(editor, info, down);
        if (this.myBlockStatementContainer != null && this.isMultiline(editor)) {
            this.surroundWithCodeBlock(editor, info, down);
        }
        if (this.myShouldAddComma) {
            JSStatementUpDownMover.addComma(editor, info, down);
        }
    }

    private boolean isMultiline(Editor editor) {
        Document document = editor.getDocument();
        TextRange textRange = this.myBlockStatementContainer.getTextRange();
        int start = document.getLineNumber(textRange.getStartOffset());
        int end = document.getLineNumber(textRange.getEndOffset());
        return end - start != 0;
    }

    private static void addComma(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "addComma"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "addComma"));
        }
        Document document = editor.getDocument();
        int offset = down ? document.getLineEndOffset(info.toMove2.endLine - 1) : document.getLineEndOffset(info.toMove.endLine - 1);
        document.insertString(offset, (CharSequence)",");
        offset = down ? document.getLineEndOffset(info.toMove.endLine - 1) : document.getLineEndOffset(info.toMove2.endLine - 1);
        String text = document.getText(new TextRange(offset - 1, offset));
        if (text.equals(",")) {
            document.deleteString(offset - 1, offset);
        }
        PsiDocumentManager.getInstance((Project)editor.getProject()).commitDocument(document);
    }

    private void surroundWithCodeBlock(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int endOffset;
        int startOffset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "surroundWithCodeBlock"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "surroundWithCodeBlock"));
        }
        PsiElement body = this.getBody(down);
        if (body == null || body instanceof JSBlockStatement) {
            return;
        }
        Document document = editor.getDocument();
        Project project = this.myBlockStatementContainer.getProject();
        PsiFile containingFile = this.myBlockStatementContainer.getContainingFile();
        if (down) {
            startOffset = document.getLineEndOffset(info.toMove2.startLine);
            endOffset = body.getTextRange().getEndOffset() + 1;
        } else {
            startOffset = body.getTextRange().getStartOffset();
            endOffset = document.getLineEndOffset(info.toMove.endLine - 1) + 1;
        }
        document.insertString(startOffset, (CharSequence)"{");
        document.insertString(endOffset, (CharSequence)"}");
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)containingFile, startOffset, endOffset + 2);
    }

    private PsiElement getBody(boolean down) {
        JSStatement body;
        if (this.myBlockStatementContainer instanceof JSLoopStatement) {
            body = ((JSLoopStatement)this.myBlockStatementContainer).getBody();
        } else {
            JSStatement elseBranch;
            JSIfStatement ifStatement = (JSIfStatement)this.myBlockStatementContainer;
            body = down ? ifStatement.getThen() : ((elseBranch = ifStatement.getElse()) == null ? ifStatement.getThen() : elseBranch);
        }
        return body;
    }

    private static boolean isSameNode(PsiFile file, StatementUpDownMover.MoveInfo info, Document document, boolean down) {
        int endOffset;
        int startOffset;
        if (down) {
            startOffset = document.getLineStartOffset(info.toMove.startLine);
            endOffset = document.getLineEndOffset(info.toMove2.endLine - 1);
        } else {
            startOffset = document.getLineStartOffset(info.toMove2.startLine);
            endOffset = document.getLineEndOffset(info.toMove.endLine - 1);
        }
        return file.findElementAt(startOffset) == file.findElementAt(endOffset);
    }

    private static int advanceToRange(Document document, int offset) {
        int afterNextLf = CharArrayUtil.shiftForwardUntil((CharSequence)document.getCharsSequence(), (int)offset, (String)"\n") + 1;
        return document.getLineNumber(afterNextLf < document.getTextLength() ? afterNextLf : afterNextLf - 1);
    }

    @Nullable
    private static TextRange blockHeaderRange(ASTNode blockNode) {
        if (blockNode == null) {
            return null;
        }
        ASTNode lBrace = blockNode.findChildByType(JSTokenTypes.LBRACE);
        return lBrace != null ? new TextRange(blockNode.getTreeParent().getStartOffset(), lBrace.getTextRange().getEndOffset()) : null;
    }

    private static PsiElement expandRangeBefore(PsiElement second) {
        PsiElement psiElement;
        ASTNode node = second.getNode();
        if (node.getElementType() == JSTokenTypes.COMMA) {
            PsiElement prevElement = second.getPrevSibling();
            if (prevElement instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement instanceof JSProperty) {
                return prevElement;
            }
        }
        if ((psiElement = JSStatementUpDownMover.expandComment(node, false)) != null) {
            return psiElement;
        }
        if (!JSStatementUpDownMover.isCommentOwner(second)) {
            return second;
        }
        PsiElement prevElement = second.getPrevSibling();
        if (prevElement instanceof PsiWhiteSpace && JSStatementUpDownMover.isTrivialWs((PsiWhiteSpace)prevElement)) {
            prevElement = prevElement.getPrevSibling();
        }
        if (prevElement instanceof PsiComment && ((PsiComment)prevElement).getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            return JSStatementUpDownMover.expandComment(prevElement.getNode(), false);
        }
        return second;
    }

    private static boolean isTrivialWs(PsiWhiteSpace prevElement) {
        String text = prevElement.getText();
        return text.startsWith("\n") && text.indexOf("\n", 1) == -1;
    }

    private static PsiElement expandRangeAfter(PsiElement second, boolean movedElement) {
        PsiElement psiElement;
        if (second instanceof JSProperty) {
            PsiElement nextElement = second.getNextSibling();
            if (nextElement instanceof PsiWhiteSpace) {
                nextElement = nextElement.getNextSibling();
            }
            if (nextElement != null && nextElement.getNode().getElementType() == JSTokenTypes.COMMA) {
                return nextElement;
            }
        }
        if ((psiElement = JSStatementUpDownMover.expandComment(second.getNode(), true)) != null) {
            if (!movedElement) {
                PsiElement nextElement = second.getNextSibling();
                if (nextElement instanceof PsiWhiteSpace && JSStatementUpDownMover.isTrivialWs((PsiWhiteSpace)nextElement)) {
                    nextElement = nextElement.getNextSibling();
                }
                if (JSStatementUpDownMover.isCommentOwner(nextElement)) {
                    return nextElement;
                }
            }
            return psiElement;
        }
        return second;
    }

    private static boolean isCommentOwner(PsiElement nextElement) {
        return nextElement instanceof JSExpressionStatement || nextElement instanceof JSQualifiedNamedElement || nextElement instanceof JSProperty || nextElement instanceof JSVarStatement;
    }

    @Nullable
    private static PsiElement expandComment(ASTNode node, boolean after) {
        if (node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            ASTNode result;
            ASTNode prev = node;
            do {
                result = prev;
                prev = node;
                ASTNode aSTNode = node = after ? node.getTreeNext() : node.getTreePrev();
            } while (node != null && (node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT || prev.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT));
            return result.getPsi();
        }
        return null;
    }

    private static boolean isNotValidStatementRange(Couple<PsiElement> range) {
        if (range == null || range.first == null || range.second == null || ((PsiElement)range.first).getParent() != ((PsiElement)range.second).getParent()) {
            return true;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)((PsiElement)range.first));
        boolean skippedSemicolon = false;
        while (prevLeaf instanceof PsiWhiteSpace) {
            if ((prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)prevLeaf)) == null || prevLeaf.getNode() == null || prevLeaf.getNode().getElementType() != JSTokenTypes.SEMICOLON || skippedSemicolon) continue;
            prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)prevLeaf);
        }
        return prevLeaf instanceof PsiErrorElement;
    }

    private static Couple<PsiElement> findElementRange(@NotNull Editor editor, @NotNull PsiFile file, @NotNull LineRange toMove, StatementSelectionMode mode) {
        PsiElement endingElement;
        int lineCount;
        Document document;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "findElementRange"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "findElementRange"));
        }
        if (toMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "findElementRange"));
        }
        boolean startSearchMode = true;
        boolean endSearchMode = false;
        if (mode == StatementSelectionMode.UP) {
            startSearchMode = false;
            endSearchMode = false;
        }
        int startOffset = document.getLineStartOffset(toMove.startLine < (lineCount = (document = editor.getDocument()).getLineCount()) ? toMove.startLine : lineCount - 1);
        PsiElement startingElement = JSStatementUpDownMover.firstNonWhiteElement((int)startOffset, (PsiFile)file, (boolean)startSearchMode);
        int endOffset = toMove.endLine < lineCount ? document.getLineStartOffset(toMove.endLine) - 1 : document.getLineEndOffset(lineCount - 1);
        PsiElement psiElement = endingElement = endOffset > startOffset ? JSStatementUpDownMover.firstNonWhiteElement((int)endOffset, (PsiFile)file, (boolean)endSearchMode) : startingElement;
        if (startingElement != null && endingElement != null && startingElement.getTextRange().getStartOffset() > endingElement.getTextRange().getEndOffset()) {
            endingElement = startingElement = file.findElementAt(startOffset);
        }
        return Couple.of((Object)startingElement, (Object)endingElement);
    }

    @Nullable
    private static Couple<PsiElement> elementRange(@NotNull Editor editor, @NotNull PsiFile file, @NotNull LineRange toMove, StatementSelectionMode mode) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "elementRange"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "elementRange"));
        }
        if (toMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove", "com/intellij/lang/javascript/editing/JSStatementUpDownMover", "elementRange"));
        }
        Couple<PsiElement> range = JSStatementUpDownMover.findElementRange(editor, file, toMove, mode);
        PsiElement statement = JSStatementUpDownMover.getSourceElement((PsiElement)range.first);
        PsiElement statement2 = JSStatementUpDownMover.getSourceElement((PsiElement)range.second);
        if (statement2 != null && PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)statement2, (boolean)false)) {
            statement2 = statement;
        }
        if (statement != null && PsiTreeUtil.isAncestor((PsiElement)statement2, (PsiElement)statement, (boolean)false)) {
            statement = statement2;
        }
        return Couple.of((Object)statement, (Object)statement2);
    }

    private static boolean isBlockStatementContainer(PsiElement parent) {
        return parent instanceof JSLoopStatement || parent instanceof JSIfStatement;
    }

    @Nullable
    private static PsiElement getSourceElement(PsiElement first) {
        PsiElement parent;
        PsiElement element;
        if (first == null) {
            return null;
        }
        if (first.getNode().getElementType() == JSTokenTypes.COMMA) {
            PsiElement prevElement = first.getPrevSibling();
            if (prevElement instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement == null) {
                return null;
            }
            first = prevElement;
        }
        if ((element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)first, (Class[])new Class[]{JSExpression.class})) != null && element.getParent() instanceof JSArrayLiteralExpression) {
            return element;
        }
        element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)first, (Class[])new Class[]{JSStatement.class, JSFunction.class, PsiComment.class, JSProperty.class});
        if (element instanceof JSPackageStatement) {
            return null;
        }
        if (element instanceof JSBlockStatement && ((parent = element.getParent()) instanceof JSStatement || parent instanceof JSFunction)) {
            element = parent;
        }
        if (element instanceof JSFunctionExpression) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSStatement.class, JSFunction.class, JSProperty.class});
        }
        return element;
    }

    static enum StatementSelectionMode {
        UP,
        DOWN;

    }
}

