/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.flow.psi.FlowJSParser;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;

public class FlowJSPsiTypeParser
extends TypeScriptPsiTypeParser<FlowJSParser> {
    static final Key<Boolean> FORCED_TYPE_KEY = Key.create((String)"js.parser.forced.type");

    protected FlowJSPsiTypeParser(FlowJSParser parser) {
        super(parser);
    }

    @Override
    protected boolean parseDistinctType(boolean regularType) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.QUEST) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseDistinctType(true);
            marker.done(FlowJSElementTypes.MAYBE_TYPE);
            return true;
        }
        if (JSTokenTypes.BOOLEAN_LITERALS.contains(firstToken)) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(FlowJSElementTypes.BOOLEAN_LITERAL_TYPE);
            return true;
        }
        if (firstToken == JSTokenTypes.NUMERIC_LITERAL) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(FlowJSElementTypes.NUMBER_LITERAL_TYPE);
            return true;
        }
        if (firstToken == JSTokenTypes.MULT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.SINGLE_TYPE);
            return true;
        }
        return super.parseDistinctType(true);
    }

    @Override
    public boolean tryParseType() {
        if (Boolean.TRUE.equals(this.builder.getUserData(FORCED_TYPE_KEY)) && this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
        }
        return super.tryParseType();
    }

    @Override
    protected boolean parseTypeParameter() {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            return false;
        }
        PsiBuilder.Marker typeParameter = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            this.parseType();
        }
        typeParameter.done(TypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }

    @Override
    protected boolean allowLastCommaInTupleType() {
        return true;
    }
}

