/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndentOptionsEditor
extends SmartIndentOptionsEditor {
    private JCheckBox myIndentOptionsCheckBox;
    private Language myDialect = null;

    public JSIndentOptionsEditor() {
    }

    public JSIndentOptionsEditor(@Nullable Language dialect) {
        this.myDialect = dialect;
    }

    protected void addComponents() {
        super.addComponents();
        this.myIndentOptionsCheckBox = new JCheckBox("Indent chained methods");
        this.add(this.myIndentOptionsCheckBox);
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        return super.isModified(settings, options) || this.myIndentOptionsCheckBox.isSelected() != jsSettings.INDENT_CHAINED_CALLS;
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        jsSettings.INDENT_CHAINED_CALLS = this.myIndentOptionsCheckBox.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSIndentOptionsEditor", "reset"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/formatter/JSIndentOptionsEditor", "reset"));
        }
        super.reset(settings, options);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        this.myIndentOptionsCheckBox.setSelected(jsSettings.INDENT_CHAINED_CALLS);
    }
}

