/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.webcore.formatter.chainedMethods.ChainedBlocksSpacingStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSpacingStrategy
extends ChainedBlocksSpacingStrategy {
    private final ASTNode myRootNode;
    private final CodeStyleSettings mySettings;
    private final Language myDialect;
    private final boolean myIsDotOnNewLine;

    public JSSpacingStrategy(@NotNull ASTNode rootNode, @NotNull CodeStyleSettings settings, Language dialect) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy", "<init>"));
        }
        super(settings.getCommonSettings(dialect));
        this.myRootNode = rootNode;
        this.mySettings = settings;
        this.myDialect = dialect;
        this.myIsDotOnNewLine = ((JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class)).CHAINED_CALL_DOT_ON_NEW_LINE;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy", "getSpacing"));
        }
        Spacing spacing = super.getSpacing(child1, child2);
        if (spacing != null) {
            return spacing;
        }
        if (!JSSpacingStrategy.canComputeSpacing(child1) || !JSSpacingStrategy.canComputeSpacing(child2)) {
            return null;
        }
        return new JSSpacingProcessor(this.myRootNode, ((ASTBlock)child1).getNode(), ((ASTBlock)child2).getNode(), this.mySettings, this.myDialect).calcSpacing();
    }

    private static boolean canComputeSpacing(Block block) {
        return block instanceof JSBlock || block instanceof XmlTagBlock;
    }

    protected boolean isDotOnNewLine() {
        return this.myIsDotOnNewLine;
    }
}

