/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSAmdIndexingHandler
extends FrameworkIndexingHandler {
    private static final String[] INTERESTED_PROPERTIES = new String[]{"baseUrl", "paths"};
    private static final String DEFINE = "define";
    private static final String[] INTERESTED_METHOD_NAMES = new String[]{"define"};

    @Override
    @NotNull
    public String[] interestedProperties() {
        if (INTERESTED_PROPERTIES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler", "interestedProperties"));
        }
        return INTERESTED_PROPERTIES;
    }

    @Override
    public boolean processProperty(@NotNull JSProperty property, @NotNull Map<String, String> outCustomSingleEntries) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler", "processProperty"));
        }
        if (outCustomSingleEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outCustomSingleEntries", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler", "processProperty"));
        }
        PsiElement argList = property.getParent().getParent();
        if (!(argList instanceof JSArgumentList)) {
            return true;
        }
        PsiElement callExpr = argList.getParent();
        if (!(callExpr instanceof JSCallExpression)) {
            return true;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpr).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return true;
        }
        if (!"config".equals(((JSReferenceExpression)methodExpression).getReferencedName())) {
            return true;
        }
        String name = property.getName();
        JSExpression value = property.getValue();
        if ("baseUrl".equals(name) && value instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            String url = StringUtil.unquoteString((String)value.getText());
            if (!url.contains(":")) {
                outCustomSingleEntries.put("js.require.base.url", url);
                return false;
            }
        } else if ("paths".equals(name) && value instanceof JSObjectLiteralExpression) {
            THashMap paths = new THashMap();
            for (JSProperty path : ((JSObjectLiteralExpression)value).getProperties()) {
                JSExpression pathValue = path.getValue();
                if (!(pathValue instanceof JSLiteralExpression) || !((JSLiteralExpression)pathValue).isQuotedLiteral()) continue;
                paths.put(path.getName(), StringUtil.unquoteString((String)pathValue.getText()));
            }
            outCustomSingleEntries.put("js.require.path.aliases", JSAmdIndexingHandler.serializeMap((Map<String, String>)paths));
            return false;
        }
        return true;
    }

    private static String serializeMap(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtil.containsAnyChar((String)key, (String)"*|") || StringUtil.containsAnyChar((String)value, (String)"*|")) continue;
            builder.append(separator).append(key).append("*").append(value);
            separator = "|";
        }
        return builder.toString();
    }

    public static Map<String, String> deserializeMap(String serialized) {
        THashMap map = new THashMap();
        for (String entry : StringUtil.split((String)serialized, (String)"|")) {
            int separatorIndex = entry.indexOf(42);
            assert (separatorIndex >= 0);
            map.put(entry.substring(0, separatorIndex), entry.substring(separatorIndex + 1));
        }
        return map;
    }

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler", "processCallExpression"));
        }
        if (JSAmdPsiUtil.isDefineCall(callExpression)) {
            String referenceName;
            Collection returnedExpressions;
            JSReferenceExpression returnedReference;
            String localAlias = "";
            JSExpression moduleInitializer = JSAmdPsiUtil.getModuleInitializer(callExpression);
            if (moduleInitializer instanceof JSFunctionExpression && (returnedReference = (JSReferenceExpression)ContainerUtil.getFirstItem(returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)moduleInitializer), JSReferenceExpression.class))) != null && returnedReference.getQualifier() == null && (referenceName = returnedReference.getReferenceName()) != null) {
                localAlias = referenceName;
            }
            outData.putUserString("def", localAlias);
        }
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        return JSAmdPsiUtil.isDefineCall(node);
    }

    @Override
    @NotNull
    public String[] interestedMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler", "interestedMethodNames"));
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledMethodName", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler", "createLiteralImplicitElementProvider"));
        }
        if (DEFINE.equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler$1", "fillIndexingData"));
                    }
                    if (callExpression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler$1", "fillIndexingData"));
                    }
                    if (outIndexingData == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler$1", "fillIndexingData"));
                    }
                    if (!JSAmdPsiUtil.isDefineCall(callExpression)) {
                        return;
                    }
                    JSExpression[] arguments = callExpression.getArguments();
                    if (arguments[0] != argument) {
                        return;
                    }
                    String name = JSAmdPsiUtil.unifyModuleName(argument);
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)argument).setContext(JSContext.STATIC).setNamespaceExplicitlyDeclared(true).setType(JSImplicitElement.Type.Namespace).setUserString("amd");
                    outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }

    static {
        JSImplicitElement.ourUserStringsRegistry.registerUserString("amd");
    }
}

