/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.commonjs;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.types.JSCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonJSUtil {
    public static boolean hasReexportedModules(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "hasReexportedModules"));
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        JSType exported = ((JSFile)file).getExportsInnerAlias();
        return exported instanceof JSCallExpressionType && "require".equals(((JSCallExpressionType)exported).getMethod());
    }

    public static boolean calculateIsRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "calculateIsRequireCall"));
        }
        JSReferenceExpression methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
        return methodExpression != null && callExpression.getArguments().length == 1 && methodExpression.getQualifier() == null && "require".equals(methodExpression.getReferenceName());
    }

    @Nullable
    public static String getNodeJsRedirectPath(PsiFile mainModule) {
        Collection expressions = PsiTreeUtil.collectElementsOfType((PsiElement)mainModule, (Class[])new Class[]{JSAssignmentExpression.class});
        if (expressions.size() != 1) {
            return null;
        }
        JSAssignmentExpression assignment = (JSAssignmentExpression)expressions.iterator().next();
        if (assignment.getParent() instanceof JSExpressionStatement && mainModule.equals(assignment.getParent().getParent())) {
            JSDefinitionExpression definition = assignment.getDefinitionExpression();
            JSExpression operand = assignment.getROperand();
            if (definition == null || !(operand instanceof JSCallExpression)) {
                return null;
            }
            if ("exports".equals(definition.getName()) && definition.getNamespace() != null && "module".equals(definition.getNamespace().getName())) {
                JSCallExpression call = (JSCallExpression)operand;
                JSExpression[] arguments = call.getArguments();
                JSExpression methodExpression = call.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && "require".equals(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() == null && arguments.length == 1) {
                    return StringUtil.unquoteString((String)arguments[0].getText());
                }
            }
        }
        return null;
    }

    public static boolean isModuleType(JSType type) {
        return type instanceof JSTypeImpl && type.getTypeText(JSType.TypeTextFormat.SIMPLE).startsWith("module:");
    }

    public static Collection<JSFile> resolveReferencedElements(@NotNull PsiElement context, @NotNull String path) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "resolveReferencedElements"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "resolveReferencedElements"));
        }
        PsiReference moduleReference = null;
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])JSModuleReferenceContributor.EP_NAME.getExtensions()) {
            PsiReference[] references = contributor.getCommonJSModuleReferences(path, context, 0, null);
            if (references.length <= 0) continue;
            moduleReference = references[references.length - 1];
        }
        if (moduleReference == null) {
            return Collections.emptyList();
        }
        if (!(moduleReference instanceof PsiPolyVariantReference)) {
            PsiElement resolve = moduleReference.resolve();
            return ContainerUtil.createMaybeSingletonList((Object)(resolve instanceof JSFile ? (JSFile)resolve : null));
        }
        ResolveResult[] results = ((PsiPolyVariantReference)moduleReference).multiResolve(false);
        ArrayList modules = ContainerUtil.newArrayListWithCapacity((int)results.length);
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!result.isValidResult() || !(element instanceof JSFile)) continue;
            modules.add((JSFile)element);
        }
        return modules;
    }
}

