/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.extjs;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.frameworks.extjs.Ext4FrameworkHandler;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtXTypeReference
implements PsiReference,
HighlightSeverityHolder,
EmptyResolveMessageProvider {
    @NotNull
    private final JSLiteralExpression myStringLiteral;

    public ExtXTypeReference(@NotNull JSLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringLiteral", "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference", "<init>"));
        }
        this.myStringLiteral = stringLiteral;
    }

    public PsiElement getElement() {
        return this.myStringLiteral;
    }

    public TextRange getRangeInElement() {
        return new TextRange(1, this.myStringLiteral.getTextLength() - 1);
    }

    @Nullable
    public PsiElement resolve() {
        String typeName = StringUtil.stripQuotesAroundValue((String)this.myStringLiteral.getText());
        JSType type = JSTypeEvaluateManager.getTypedefValue((PsiElement)this.myStringLiteral, typeName);
        JSTypeSource source = type != null ? type.getSource() : null;
        return source != null && source.getSourceElement().isValid() ? source.getSourceElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.stripQuotesAroundValue((String)this.myStringLiteral.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<String> xtypes = new ArrayList<String>();
        Collection keys = StubIndex.getInstance().getAllKeys(JSTypedefIndex.KEY, this.myStringLiteral.getProject());
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)this.myStringLiteral);
        block0: for (String key : keys) {
            for (JSElement element : StubIndex.getElements(JSTypedefIndex.KEY, (Object)key, (Project)scope.getProject(), (GlobalSearchScope)scope, JSElement.class)) {
                assert (element instanceof JSImplicitElementProvider);
                JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
                assert (data != null);
                Collection typedefs = data.getTypedefs();
                assert (typedefs != null && !typedefs.isEmpty());
                for (Pair typedef : typedefs) {
                    if (!StringUtil.equals((CharSequence)key, (CharSequence)((CharSequence)typedef.first)) || typedef.second == null || !Ext4FrameworkHandler.isExtXType((String)typedef.second)) continue;
                    xtypes.add(key);
                    continue block0;
                }
            }
        }
        Object[] objectArray = xtypes.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference", "getUnresolvedReferenceSeverity"));
        }
        return highlightSeverity;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JSBundle.message((String)"js.frameworks.sencha.xtype.not.found", (Object[])new Object[]{StringUtil.stripQuotesAroundValue((String)this.myStringLiteral.getText())});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

