/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactAttributeDescriptorsProvider;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    public static final ReactAttributeDescriptorsProvider PROVIDER = new ReactAttributeDescriptorsProvider();
    private static final String REACT_ATTRIBUTES = "HTMLDOMPropertyConfig.Properties";

    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context) {
        XmlAttributeDescriptor[] descriptors;
        if (ReactXmlExtension.nonJsxTag(context)) {
            return XmlAttributeDescriptor.EMPTY;
        }
        if (!DialectDetector.isTypeScript((PsiElement)context) && (descriptors = ReactAttributeDescriptorsProvider.getJavaScriptReactAttributeDescriptors(context)).length > 0) {
            return descriptors;
        }
        return TypeScriptReactAttributeDescriptorsProvider.PROVIDER_TSX.getAttributeDescriptors(context);
    }

    @NotNull
    private static XmlAttributeDescriptor[] getJavaScriptReactAttributeDescriptors(XmlTag context) {
        JSObjectLiteralExpression initializer;
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)context).getClassResolver();
        Collection<JSPsiElementBase> elements = resolver.findElementsByQNameIncludingImplicit(REACT_ATTRIBUTES, JSResolveUtil.getResolveScope((PsiElement)context));
        JSPsiElementBase item = (JSPsiElementBase)ContainerUtil.getFirstItem(elements);
        JSObjectLiteralExpression jSObjectLiteralExpression = initializer = item instanceof JSProperty ? ((JSProperty)item).getObjectLiteralExpressionInitializer() : null;
        if (initializer != null) {
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = (XmlAttributeDescriptor[])ContainerUtil.map2Array((Object[])initializer.getProperties(), XmlAttributeDescriptor.class, (Function)new Function<JSProperty, XmlAttributeDescriptor>(){

                public XmlAttributeDescriptor fun(JSProperty property) {
                    return new ReactAttributeDescriptor(property.getName(), (PsiElement)property);
                }
            });
            if (xmlAttributeDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptorsProvider", "getJavaScriptReactAttributeDescriptors"));
            }
            return xmlAttributeDescriptorArray;
        }
        if (XmlAttributeDescriptor.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptorsProvider", "getJavaScriptReactAttributeDescriptors"));
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        XmlAttributeDescriptor descriptor;
        if (ReactXmlExtension.nonJsxTag(context)) {
            return null;
        }
        if (!DialectDetector.isTypeScript((PsiElement)context) && (descriptor = ReactAttributeDescriptorsProvider.getJavaScriptReactAttributeDescriptor(attributeName, context)) != null) {
            return descriptor;
        }
        descriptor = TypeScriptReactAttributeDescriptorsProvider.PROVIDER_TSX.getAttributeDescriptor(attributeName, context);
        if (descriptor != null) {
            return descriptor;
        }
        return ReactXmlExtension.isComponentName(context.getName()) ? new AnyXmlAttributeDescriptor(attributeName) : null;
    }

    @Nullable
    private static XmlAttributeDescriptor getJavaScriptReactAttributeDescriptor(String attributeName, XmlTag context) {
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)context).getClassResolver();
        Collection<JSPsiElementBase> elements = resolver.findElementsByQNameIncludingImplicit("HTMLDOMPropertyConfig.Properties." + attributeName, JSResolveUtil.getResolveScope((PsiElement)context));
        JSPsiElementBase attribute = (JSPsiElementBase)ContainerUtil.getFirstItem(elements);
        if (attribute instanceof JSProperty) {
            return new ReactAttributeDescriptor(attributeName, (PsiElement)attribute);
        }
        return null;
    }

    public static class ReactAttributeDescriptor
    extends BasicXmlAttributeDescriptor {
        private final String myAttributeName;
        @NotNull
        private final PsiElement myDeclaration;

        public ReactAttributeDescriptor(String attributeName, @NotNull PsiElement declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptorsProvider$ReactAttributeDescriptor", "<init>"));
            }
            this.myAttributeName = attributeName;
            this.myDeclaration = declaration;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean hasIdType() {
            return false;
        }

        public boolean hasIdRefType() {
            return false;
        }

        public boolean isEnumerated() {
            return false;
        }

        public PsiElement getDeclaration() {
            return this.myDeclaration;
        }

        public String getName() {
            return this.myAttributeName;
        }

        public void init(PsiElement element) {
        }

        public Object[] getDependences() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isFixed() {
            return false;
        }

        public String getDefaultValue() {
            return null;
        }

        public String[] getEnumeratedValues() {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }
}

