/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ReactFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    public static final String COMPONENT = "ReactCompositeComponent";

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler", "processCallExpression"));
        }
        if (!JSXHarmonyLanguageDialect.isReactComponent((JSExpression)callExpression)) {
            return;
        }
        ReactFrameworkIndexingHandler.addClassFromVariable(callExpression, outData);
    }

    private static void addClassFromVariable(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler", "addClassFromVariable"));
        }
        JSVariable variable = (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSVariable.class);
        if (variable != null) {
            String name = variable.getName();
            if (name == null) {
                return;
            }
            JSImplicitElementImpl.Builder props = new JSImplicitElementImpl.Builder("props", (PsiElement)callExpression).setNamespace(JSQualifiedNameImpl.create(name, null)).setType(JSImplicitElement.Type.Variable).setTypeString(name + ".props");
            outData.addImplicitElement((JSImplicitElement)props.toImplicitElement());
            if (JSDocumentationUtils.isClassOrInterface((JSQualifiedNamedElement)variable) == JSClassIndex.ClassOrInterface.NONE) {
                JSImplicitElementImpl.Builder clazz = new JSImplicitElementImpl.Builder(name, (PsiElement)callExpression).setNamespace(JSQualifiedNameImpl.create(name, null)).setType(JSImplicitElement.Type.Class).setTypeString(COMPONENT);
                outData.addImplicitElement((JSImplicitElement)clazz.toImplicitElement());
            }
        }
    }

    @Override
    public int getVersion() {
        return 3;
    }
}

