/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.tsx;

import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReactComponentUtil {
    public static final String ELEMENT_CLASS_NAME = "ElementClass";

    @Nullable
    private static JSClass findReactClass(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "findReactClass"));
        }
        Collection candidates = StubIndex.getElements(JSClassIndex.KEY, (Object)"^ElementClass", (Project)context.getProject(), (GlobalSearchScope)JSResolveUtil.getResolveScope(context), JSElement.class);
        for (JSElement aClass : candidates) {
            Object[] superClasses;
            if (!(aClass instanceof TypeScriptInterface) || (superClasses = ((TypeScriptInterface)aClass).getSuperClasses()).length != 1) continue;
            return (JSClass)ArrayUtil.getFirstElement((Object[])superClasses);
        }
        return null;
    }

    @NotNull
    public static Collection<JSClass> getReactComponents(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "getReactComponents"));
        }
        JSClass reactClass = TypeScriptReactComponentUtil.findReactClass(context);
        if (reactClass == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "getReactComponents"));
            }
            return list;
        }
        List list = ContainerUtil.filter(JSInheritanceUtil.findDirectSubClasses(reactClass, true), (Condition)new Condition<JSClass>(){

            public boolean value(JSClass aClass) {
                return !aClass.isInterface();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "getReactComponents"));
        }
        return list;
    }

    @Nullable
    public static JSClass resolveComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "resolveComponent"));
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveName(tag.getName(), (PsiElement)tag);
        for (PsiElement psiElement : result.getElements()) {
            JSClass jsClass;
            if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface()) continue;
            return jsClass;
        }
        return null;
    }
}

