/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.ImplementedMethodProcessor;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Map;

public class JavaScriptImplementMethodsHandler
extends BaseJSGenerateHandler {
    @Override
    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
        if (DialectDetector.isTypeScript((PsiElement)clazz)) {
            Map<JSNamedElement, JSClass> members = TypeScriptUtil.getUnimplementedMembers(clazz, true);
            for (Map.Entry<JSNamedElement, JSClass> entry : members.entrySet()) {
                JSNamedElement key = entry.getKey();
                if (!(key instanceof JSFunction)) continue;
                candidates.add(new JSNamedElementNode((JSPsiNamedElementBase)key));
            }
        } else {
            for (JSFunction fun : ImplementedMethodProcessor.collectFunctionsToImplement(clazz)) {
                candidates.add(new JSNamedElementNode((JSPsiNamedElementBase)fun));
            }
        }
    }

    @Override
    protected String getTitleKey() {
        return "methods.to.implement.chooser.title";
    }

    @Override
    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.methods.to.implement", (Object[])new Object[0]);
    }

    @Override
    protected BaseCreateMethodsFix createFix(JSClass clazz) {
        return new ImplementMethodsFix(clazz);
    }

    @Override
    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }
}

