/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyBrowser;
import com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyNodeDescriptor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSCallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)JSCallerMethodsTreeStructure.class.getName());
    private final String myScopeType;

    public JSCallerMethodsTreeStructure(Project project, JSFunction method, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new JSCallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/hierarchy/call/JSCallerMethodsTreeStructure", "buildChildren"));
        }
        PsiElement enclosingElement = ((JSCallHierarchyNodeDescriptor)descriptor).getEnclosingElement();
        if (!(enclosingElement instanceof JSFunction)) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/call/JSCallerMethodsTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        final JSFunction method = (JSFunction)enclosingElement;
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if (JSCallHierarchyBrowser.SCOPE_CLASS.equals(this.myScopeType)) {
            JSFunction baseMethod = (JSFunction)((JSCallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
            JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)baseMethod);
            searchScope = containingClass == null ? GlobalSearchScope.EMPTY_SCOPE : new LocalSearchScope((PsiElement)containingClass);
        } else if (JSCallHierarchyBrowser.SCOPE_PROJECT.equals(this.myScopeType)) {
            searchScope = GlobalSearchScopes.projectProductionScope((Project)this.myProject);
        } else if (JSCallHierarchyBrowser.SCOPE_TEST.equals(this.myScopeType)) {
            searchScope = GlobalSearchScopes.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.myScopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScopes.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        Collection<JSFunction> methodsToFind = JSInheritanceUtil.findTopMethods(method);
        HashMap methodToDescriptorMap = new HashMap();
        for (JSFunction methodToFind : methodsToFind) {
            ReferencesSearch.search((PsiElement)methodToFind, (SearchScope)searchScope, (boolean)true).forEach((Processor)new Processor<PsiReference>((Map)methodToDescriptorMap, descriptor){
                final /* synthetic */ Map val$methodToDescriptorMap;
                final /* synthetic */ HierarchyNodeDescriptor val$descriptor;
                {
                    this.val$methodToDescriptorMap = map;
                    this.val$descriptor = hierarchyNodeDescriptor;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(PsiReference reference) {
                    PsiElement key;
                    if (!(reference instanceof JSReferenceExpression)) {
                        return true;
                    }
                    PsiElement element = reference.getElement();
                    if (!(element.getParent() instanceof JSCallExpression)) {
                        return true;
                    }
                    JSExpression qualifier = ((JSReferenceExpression)reference).getQualifier();
                    if (qualifier instanceof JSSuperExpression) {
                        PsiElement psiElement;
                        PsiReference psiReference = qualifier.getReference();
                        PsiElement psiElement2 = psiElement = psiReference == null ? null : psiReference.resolve();
                        if (psiElement instanceof JSClass) {
                            JSClass superClass = (JSClass)psiElement;
                            JSClass methodClass = JSResolveUtil.getClassOfContext((PsiElement)method);
                            if (methodClass != null && JSInheritanceUtil.isParentClass(methodClass, superClass)) {
                                return true;
                            }
                        }
                    }
                    if ((key = JSCallHierarchyNodeDescriptor.getEnclosingElement(element)) == null) {
                        LOG.debug("Enclosing element for element " + element.getText() + " in file " + element.getContainingFile() + " is null");
                        return true;
                    }
                    Map map = this.val$methodToDescriptorMap;
                    synchronized (map) {
                        JSCallHierarchyNodeDescriptor d = (JSCallHierarchyNodeDescriptor)((Object)this.val$methodToDescriptorMap.get(key));
                        if (d == null) {
                            d = new JSCallHierarchyNodeDescriptor(JSCallerMethodsTreeStructure.this.myProject, this.val$descriptor, element, false, true);
                            this.val$methodToDescriptorMap.put(key, d);
                        } else {
                            d.incrementUsageCount();
                        }
                        d.addReference(reference);
                    }
                    return true;
                }
            });
        }
        Object[] objectArray = methodToDescriptorMap.values().toArray(new Object[methodToDescriptorMap.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/call/JSCallerMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }
}

