/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyNodeDescriptor;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyTreeStructure;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMethodHierarchyBrowser
extends MethodHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyBrowser");

    public JSMethodHierarchyBrowser(Project project, PsiElement method) {
        super(project, method);
    }

    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trees", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyBrowser", "createTrees"));
        }
        JTree tree = this.createTree(false);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("JSMethodHierarchyPopupMenu");
        PopupHandler.installPopupHandler((JComponent)tree, (ActionGroup)group, (String)"MethodHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        MethodHierarchyBrowserBase.BaseOnThisMethodAction baseOnThisMethodAction = new MethodHierarchyBrowserBase.BaseOnThisMethodAction();
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("MethodHierarchy").getShortcutSet(), (JComponent)tree);
        trees.put(METHOD_TYPE, tree);
    }

    protected JPanel createLegendPanel() {
        return JSMethodHierarchyBrowser.createStandardLegendPanel((String)IdeBundle.message((String)"hierarchy.legend.method.is.defined.in.class", (Object[])new Object[0]), (String)IdeBundle.message((String)"hierarchy.legend.method.defined.in.superclass", (Object[])new Object[0]), (String)"method should be defined");
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (descriptor instanceof JSMethodHierarchyNodeDescriptor) {
            return ((JSMethodHierarchyNodeDescriptor)descriptor).getTargetElement();
        }
        return null;
    }

    protected boolean isApplicableElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyBrowser", "isApplicableElement"));
        }
        return psiElement instanceof JSFunction;
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (!METHOD_TYPE.equals(typeName)) {
            LOG.error("unexpected type: " + typeName);
            return null;
        }
        return new JSMethodHierarchyTreeStructure(this.myProject, (JSFunction)psiElement);
    }

    protected Comparator<NodeDescriptor> getComparator() {
        return JSHierarchyUtils.getComparator(this.myProject);
    }
}

