/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type.jsclass;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;

public final class JSTypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    public JSTypeHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, JSClass jsClass, boolean isBase) {
        super(project, (NodeDescriptor)parentDescriptor, (PsiElement)jsClass, isBase);
    }

    public final JSClass getJsClass() {
        return (JSClass)this.getPsiElement();
    }

    public final boolean update() {
        String packageName;
        boolean changes = super.update();
        if (this.getJsClass() == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(this.getIcon(), 0);
            icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
            this.setIcon((Icon)icon);
        }
        JSClass jsClass = this.getJsClass();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(jsClass.getName(), classNameAttributes);
        String name = jsClass.getQualifiedName();
        if (!(StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)(packageName = StringUtil.getPackageName((String)name))) && !DialectDetector.isActionScript((PsiElement)jsClass))) {
            this.myHighlightedText.getEnding().addText(" (" + packageName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

