/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type.jsfunction;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.type.jsfunction.JSFunctionHierarchyNodeDescriptor;
import com.intellij.lang.javascript.hierarchy.type.jsfunction.JSFunctionSubtypesHierarchyTreeStructure;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;

public class JSFunctionHierarchyTreeStructure
extends JSFunctionSubtypesHierarchyTreeStructure {
    public JSFunctionHierarchyTreeStructure(Project project, JSPsiElementBase jsFunction) {
        super(project, JSFunctionHierarchyTreeStructure.buildHierarchyElement(project, jsFunction));
        this.setBaseElement(this.myBaseDescriptor);
    }

    private static HierarchyNodeDescriptor buildHierarchyElement(Project project, JSPsiElementBase jsFunction) {
        boolean jsFunctionIsInterface;
        String qName = JSHierarchyUtils.getQName(jsFunction);
        ArrayList<JSPsiElementBase> extendedTypesHierarchy = new ArrayList<JSPsiElementBase>();
        String currentFunctionQName = qName;
        boolean bl = jsFunctionIsInterface = qName != null && JSSymbolUtil.isInterface(qName, (PsiElement)jsFunction);
        while (qName != null) {
            Collection<JSPsiElementBase> supertypes = JSTypeEvaluateManager.findNearestExtendedJSTypes(jsFunction, currentFunctionQName);
            JSPsiElementBase nonInterfaceElement = null;
            String nonInterfaceName = null;
            for (JSPsiElementBase supertype : supertypes) {
                boolean isImplementation;
                String superName = JSHierarchyUtils.getQName(supertype);
                boolean bl2 = isImplementation = !jsFunctionIsInterface && JSSymbolUtil.isInterface(superName, (PsiElement)jsFunction);
                if (!isImplementation && nonInterfaceElement != null) {
                    extendedTypesHierarchy.add(0, null);
                    nonInterfaceElement = null;
                    break;
                }
                if (isImplementation) continue;
                nonInterfaceElement = supertype;
                nonInterfaceName = superName;
            }
            if (nonInterfaceElement == null || extendedTypesHierarchy.contains(nonInterfaceElement)) break;
            extendedTypesHierarchy.add(0, nonInterfaceElement);
            currentFunctionQName = nonInterfaceName;
        }
        HierarchyNodeDescriptor lastParent = null;
        for (JSPsiElementBase extendedElement : extendedTypesHierarchy) {
            HierarchyNodeDescriptor newDescriptor;
            HierarchyNodeDescriptor hierarchyNodeDescriptor = newDescriptor = extendedElement == null ? new MultipleInheritedHierarchyNodeDescriptor(project, (NodeDescriptor)lastParent, (PsiElement)jsFunction) : new JSFunctionHierarchyNodeDescriptor(project, lastParent, extendedElement, false);
            if (lastParent != null) {
                lastParent.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
            }
            lastParent = newDescriptor;
        }
        JSFunctionHierarchyNodeDescriptor newDescriptor = new JSFunctionHierarchyNodeDescriptor(project, lastParent, jsFunction, true);
        if (lastParent != null) {
            lastParent.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static class MultipleInheritedHierarchyNodeDescriptor
    extends HierarchyNodeDescriptor {
        protected MultipleInheritedHierarchyNodeDescriptor(Project project, NodeDescriptor parentDescriptor, PsiElement dummyElement) {
            super(project, parentDescriptor, dummyElement, false);
        }

        public boolean isValid() {
            return false;
        }

        public boolean update() {
            this.myHighlightedText = new CompositeAppearance();
            this.myHighlightedText.getEnding().addText("[Multiple inheritance]", SimpleTextAttributes.GRAY_ATTRIBUTES);
            return false;
        }
    }
}

