/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.highlighting.JSSpellcheckerProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class JSSpellcheckingStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JSLiteralExpression> myLiteralTokenizer = new MyLiteralTokenizer();
    private final Tokenizer<JSProperty> myPropertyTokenizer = new MyPropertyTokenizer();
    private final Tokenizer<JSNamedElement> myAttributeValueTokenizer = new MyAttributeValueTokenizer();
    private final JSSpellcheckerProvider[] myProviders = (JSSpellcheckerProvider[])JSSpellcheckerProvider.EP.getExtensions();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement identifier;
        if (element != null) {
            for (JSSpellcheckerProvider provider : this.myProviders) {
                Tokenizer tokenizer = provider.getTokenizer(element);
                if (tokenizer == null) continue;
                Tokenizer tokenizer2 = tokenizer;
                if (tokenizer2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer2;
            }
        }
        if (element instanceof TypeScriptModule && (identifier = ((TypeScriptModule)element).getNameIdentifier()) instanceof JSLiteralExpression) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof JSFunctionExpression && element.getParent() instanceof JSProperty) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof JSLiteralExpression) {
            if (element instanceof JSXmlLiteralExpressionImpl) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
            Tokenizer<JSLiteralExpression> tokenizer = this.myLiteralTokenizer;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof JSAttribute) {
            PsiReference psiReference = element.getReference();
            if (psiReference != null && psiReference.resolve() != null) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
        } else if (element instanceof JSProperty) {
            ASTNode node = ((JSProperty)element).findNameIdentifier();
            if (node != null && (node.textContains('\'') || node.textContains('\"'))) {
                String text = node.getText();
                if (!StringUtil.isJavaIdentifier((String)text)) {
                    Tokenizer<JSNamedElement> tokenizer = this.myAttributeValueTokenizer;
                    if (tokenizer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
                    }
                    return tokenizer;
                }
                Tokenizer<JSProperty> tokenizer = this.myPropertyTokenizer;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
        } else {
            JSQualifiedNamedElement qualifiedNamedElement;
            ASTNode node;
            if (element instanceof JSDefinitionExpression) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
            if (element instanceof JSQualifiedNamedElement && (node = (qualifiedNamedElement = (JSQualifiedNamedElement)element).findNameIdentifier()) != null && node.textContains('.')) {
                Tokenizer<JSNamedElement> tokenizer = this.myAttributeValueTokenizer;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    private static class MyLiteralTokenizer
    extends EscapeSequenceTokenizer<JSLiteralExpression> {
        private MyLiteralTokenizer() {
        }

        public void tokenize(@NotNull JSLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyLiteralTokenizer", "tokenize"));
            }
            if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element))) {
                return;
            }
            if (!element.isQuotedLiteral() || element.getTextLength() < 3) {
                return;
            }
            String text = StringUtil.unquoteString((String)element.getText());
            if (!text.contains("\\")) {
                consumer.consumeToken((PsiElement)element, (Splitter)PlainTextSplitter.getInstance());
            } else {
                StringBuilder unescapedText = new StringBuilder();
                Ref offsetsRef = new Ref();
                JSStringLiteralEscaper.parseStringCharacters((String)text, (StringBuilder)unescapedText, (Ref)offsetsRef, (boolean)element.isRegExpLiteral());
                MyLiteralTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])((int[])offsetsRef.get()), (int)1);
            }
        }
    }

    private static class MyAttributeValueTokenizer
    extends Tokenizer<JSNamedElement> {
        private MyAttributeValueTokenizer() {
        }

        public void tokenize(@NotNull JSNamedElement property, TokenConsumer consumer) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyAttributeValueTokenizer", "tokenize"));
            }
            ASTNode node = property.findNameIdentifier();
            if (node != null) {
                consumer.consumeToken(node.getPsi(), true, (Splitter)TextSplitter.getInstance());
            }
        }
    }

    private static class MyPropertyTokenizer
    extends Tokenizer<JSProperty> {
        private MyPropertyTokenizer() {
        }

        public void tokenize(@NotNull JSProperty element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyPropertyTokenizer", "tokenize"));
            }
            ASTNode node = element.findNameIdentifier();
            if (node != null) {
                String text = StringUtil.unquoteString((String)node.getText());
                consumer.consumeToken(node.getPsi(), text, true, 1, TextRange.allOf((String)text), (Splitter)IdentifierSplitter.getInstance());
            }
        }
    }
}

