/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSyntaxHighlighterProvider
implements SyntaxHighlighterProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/lang/javascript/highlighting/JSSyntaxHighlighterProvider", "create"));
        }
        JSLanguageDialect lang = null;
        if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType)) {
            lang = JavaScriptSupportLoader.JS_IN_HTML_DIALECT;
        }
        if (virtualFile != null) {
            JSLanguageDialect jSLanguageDialect = lang = project != null ? DialectDetector.getLanguageDialect(virtualFile, project) : null;
        }
        if (lang == null && project != null && virtualFile != null) {
            PsiFile psiFile;
            AccessToken l = ReadAction.start();
            try {
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            }
            finally {
                l.finish();
            }
            if (psiFile != null) {
                lang = psiFile.getLanguage();
            }
            if (!(lang instanceof JSLanguageDialect) && !(lang instanceof JavascriptLanguage)) {
                lang = null;
            }
        }
        if (lang == null) {
            lang = ((LanguageFileType)fileType).getLanguage();
        }
        return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, (Project)project, (VirtualFile)virtualFile);
    }
}

