/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES7Decorator;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementCustomProvider;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkIndexingHandler {
    public static final ExtensionPointName<FrameworkIndexingHandler> EP_NAME = ExtensionPointName.create((String)"JavaScript.frameworkIndexingHandler");

    public void processFile(@NotNull JSFile file, @NotNull JSFileCachedData data) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processFile"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processFile"));
        }
    }

    public void processFile(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processFile"));
        }
        if (indexBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexBuilder", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processFile"));
        }
    }

    public boolean processProperty(String name, @Nullable JSElement value, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processProperty"));
        }
        return true;
    }

    public boolean processCustomElement(@NotNull PsiElement customElement, @NotNull JSIndexContentBuilder builder) {
        if (customElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customElement", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processCustomElement"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processCustomElement"));
        }
        return true;
    }

    public boolean canProcessCustomElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "canProcessCustomElement"));
        }
        return false;
    }

    public boolean processProperty(@NotNull JSProperty property, @NotNull Map<String, String> outCustomSingleEntries) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processProperty"));
        }
        if (outCustomSingleEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outCustomSingleEntries", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processProperty"));
        }
        return true;
    }

    @NotNull
    public String[] interestedProperties() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "interestedProperties"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processAnyProperty"));
        }
        return outData;
    }

    @NotNull
    public String[] interestedMethodNames() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "interestedMethodNames"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSFileCachedData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processCallExpression"));
        }
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processCallExpression"));
        }
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSIndexContentBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processCallExpression"));
        }
    }

    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        return false;
    }

    @Nullable
    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        return null;
    }

    @Nullable
    public JSElementIndexingData processJSDocComment(@NotNull JSDocComment comment, @Nullable JSElementIndexingData outData) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "processJSDocComment"));
        }
        return outData;
    }

    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledMethodName", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "createLiteralImplicitElementProvider"));
        }
        assert (false) : calledMethodName + " not implemented for " + this.getClass();
        return null;
    }

    @Nullable
    public JSLiteralImplicitElementCustomProvider createLiteralImplicitElementCustomProvider() {
        return null;
    }

    public boolean addTypeFromResolveResult(JSTypeEvaluator evaluator, PsiElement result, boolean hasSomeType) {
        return false;
    }

    public int getVersion() {
        return 1;
    }

    public static int computeTotalVersion(int baseVersion) {
        FrameworkIndexingHandler[] handlers = (FrameworkIndexingHandler[])EP_NAME.getExtensions();
        ArrayList parts = ContainerUtil.newArrayListWithCapacity((int)(1 + handlers.length));
        parts.add("baseVersion:" + baseVersion);
        for (FrameworkIndexingHandler handler : handlers) {
            parts.add(handler.getClass().getName() + ":" + handler.getVersion());
        }
        Collections.sort(parts);
        return parts.hashCode();
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElement element, @Nullable IndexSink sink) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/FrameworkIndexingHandler", "indexImplicitElement"));
        }
        return false;
    }

    public JSElementIndexingDataImpl processDecorator(ES7Decorator decorator, JSElementIndexingDataImpl data) {
        return data;
    }
}

