/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.types.JSCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JSFileCachedDataEvaluator
extends JSElementVisitor {
    @NotNull
    protected final JSFileCachedData myCachedData;
    private Stack<Boolean> mySkipChildren;
    private boolean mySkipCurrentElementChildren;

    public JSFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outCachedData", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "<init>"));
        }
        this.mySkipChildren = ContainerUtil.newStack();
        this.myCachedData = outCachedData;
    }

    public void setSkipChildren() {
        this.mySkipCurrentElementChildren = true;
    }

    public boolean isSkipChildren() {
        return !this.mySkipChildren.isEmpty() && (Boolean)this.mySkipChildren.peek() != false;
    }

    public void startElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "startElement"));
        }
        this.mySkipCurrentElementChildren = this.isSkipChildren();
        if (!this.mySkipCurrentElementChildren) {
            element.accept((PsiElementVisitor)this);
        }
        this.mySkipChildren.push((Object)this.mySkipCurrentElementChildren);
    }

    public void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "finishElement"));
        }
        this.mySkipCurrentElementChildren = (Boolean)this.mySkipChildren.pop();
    }

    public void visitJSCallExpression(JSCallExpression node) {
        JSType type;
        JSExpression moduleInitializer;
        if (node.isRequireCall()) {
            this.myCachedData.setIsCommonJSModule();
        } else if (JSAmdPsiUtil.isDefineCall(node) && (moduleInitializer = JSAmdPsiUtil.getModuleInitializer(node)) instanceof JSFunctionExpression && (type = JSSymbolUtil.evaluateModuleInnerAlias((JSFunction)((JSFunctionExpression)moduleInitializer), "exports")) != null) {
            this.myCachedData.setExportsInnerAlias(type);
        }
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
            handler.processCallExpression(node, this.myCachedData);
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand instanceof JSDefinitionExpression) {
            lOperand = ((JSDefinitionExpression)lOperand).getExpression();
        }
        if (lOperand instanceof JSReferenceExpression) {
            JSExpression qualifier;
            if (JSSymbolUtil.isExportReference((JSReferenceExpression)lOperand)) {
                this.myCachedData.setIsCommonJSModule();
                JSExpression rOperand = node.getROperand();
                JSElement nameComponent = JSSymbolUtil.findExportedNameComponent((JSElement)rOperand);
                if (nameComponent instanceof JSReferenceExpression) {
                    JSType type;
                    JSNamespaceEvaluationResult namespace = JSSymbolUtil.evaluateNamespaceLocallyAsIs((JSExpression)((JSReferenceExpression)nameComponent));
                    JSType jSType = type = namespace != null ? namespace.toType((PsiElement)nameComponent) : null;
                    if (type instanceof JSNamedType) {
                        type = JSTypeUtils.copyWithNewSourceRecursive(type, JSTypeSource.EMPTY);
                        this.myCachedData.setExportsInnerAlias(type);
                    }
                } else if (rOperand instanceof JSFunctionExpression) {
                    JSType type = JSSymbolUtil.evaluateReturnedTypeLocally((JSFunction)((JSFunctionExpression)rOperand));
                    if (type instanceof JSNamedType) {
                        type = JSTypeUtils.copyWithNewSourceRecursive(type, JSTypeSource.EMPTY);
                        JSFunctionTypeImpl functionType = new JSFunctionTypeImpl(JSTypeSource.EMPTY, Collections.<JSParameterTypeDecorator>emptyList(), type);
                        this.myCachedData.setExportsInnerAlias(functionType);
                    }
                } else if (rOperand instanceof JSCallExpression && ((JSCallExpression)rOperand).isRequireCall()) {
                    JSCallExpressionType type = new JSCallExpressionType("require", JSTypeSource.EMPTY);
                    this.myCachedData.setExportsInnerAlias(type);
                } else {
                    JSNamespaceEvaluationResult result = JSSymbolUtil.evaluateNamespaceLocally(rOperand);
                    if (result != null) {
                        this.myCachedData.setExportsInnerAlias(result.toType((PsiElement)rOperand));
                    }
                }
            }
            if ((qualifier = ((JSReferenceExpression)lOperand).getQualifier()) instanceof JSReferenceExpression && JSSymbolUtil.isExportReference((JSReferenceExpression)qualifier)) {
                this.myCachedData.setIsCommonJSModule();
            }
        }
    }
}

