/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptHighlightingLexer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSIndexPatternBuilder
implements IndexPatternBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSIndexPatternBuilder", "getIndexingLexer"));
        }
        if (file instanceof JSFile) {
            try {
                LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
                SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)file.getLanguage(), (Project)file.getProject(), (VirtualFile)file.getVirtualFile());
                JSDirectiveCommentLexer jSDirectiveCommentLexer = new JSDirectiveCommentLexer(syntaxHighlighter.getHighlightingLexer());
                return jSDirectiveCommentLexer;
            }
            finally {
                LayeredLexer.ourDisableLayersFlag.set(null);
            }
        }
        return null;
    }

    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSIndexPatternBuilder", "getCommentTokenSet"));
        }
        if (file instanceof JSFile) {
            return Holder.COMMENTS_FOR_INDEXING;
        }
        return null;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        return 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == JSTokenTypes.C_STYLE_COMMENT ? "*/".length() : 0;
    }

    static class Holder {
        static final TokenSet COMMENTS_FOR_INDEXING = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.COMMENTS, TokenSet.create((IElementType[])new IElementType[]{JSDocTokenTypes.DOC_TAG_NAME}), TokenSet.create((IElementType[])new IElementType[]{JavaScriptHighlightingLexer.getTagContentTokenType()})});

        Holder() {
        }
    }
}

