/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.javascript.JSModuleReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.IndexingDataKeys;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSymbolUtil {
    @NonNls
    public static final String J_QUERY_VAR_NAME = "jQuery";
    @NonNls
    static final String FN_FUN_NAME = "fn";
    @NonNls
    public static final String YAHOO_NAME = "YAHOO";
    public static final String WINDOW_OBJECT_NAME = "window";
    public static final String GLOBAL_OBJECT_NAME2 = "global";
    public static final String GLOBAL_OBJECT_NAME3 = "GLOBAL";
    public static final String EXPORTS = "exports";
    public static final String MODULE = "module";
    public static final String MODULE_EXPORTS = "module.exports";
    public static final String EXTEND_METHOD_PART = "extend";
    private static final String INHERIT_METHOD_PART = "inherit";
    private static final String MERGE_METHOD_NAME = "merge";
    private static final String CREATE_METHOD_PART = "create";
    public static final String DEFINE_METHOD_NAME = "define";
    public static final String REQUIRE_METHOD_NAME = "require";
    public static final String DECLARE_METHOD_NAME = "declare";
    public static final String IMPLEMENT_METHOD_NAME = "implement";
    private static final Key<CachedValue<Map<JSReferenceExpression, JSNamespaceEvaluationResult>>> cachedClassExtendingKey = Key.create((String)"cached.class.extending");

    public static boolean symbolSeemsToBeExtensionFunction(String name) {
        return name != null && (StringUtil.containsIgnoreCase((String)name, (String)EXTEND_METHOD_PART) || StringUtil.containsIgnoreCase((String)name, (String)INHERIT_METHOD_PART) || StringUtil.containsIgnoreCase((String)name, (String)CREATE_METHOD_PART)) || StringUtil.equals((CharSequence)name, (CharSequence)MERGE_METHOD_NAME);
    }

    public static JSExpression[] findClassesNames(JSExpression value) {
        JSExpression firstArg;
        JSExpression[] arguments;
        JSArgumentList list;
        if (value instanceof JSReferenceExpression || value instanceof JSLiteralExpression) {
            return new JSExpression[]{value};
        }
        if (value instanceof JSArrayLiteralExpression) {
            return ((JSArrayLiteralExpression)value).getExpressions();
        }
        if (value instanceof JSCallExpression && (list = ((JSCallExpression)value).getArgumentList()) != null && (arguments = list.getArguments()).length > 0 && (firstArg = arguments[0]) instanceof JSObjectLiteralExpression) {
            JSProperty[] properties = ((JSObjectLiteralExpression)firstArg).getProperties();
            JSExpression[] extendList = new JSExpression[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                extendList[i] = properties[i].getValue();
            }
            return extendList;
        }
        return JSExpression.EMPTY_ARRAY;
    }

    public static boolean isDefinitelyConstructor(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return false;
        }
        JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve);
        if (functionItem instanceof JSFunction) {
            return ((JSFunction)functionItem).isConstructor();
        }
        return false;
    }

    public static boolean isConstructorName(String name) {
        return name != null && !name.isEmpty() && Character.isUpperCase(name.charAt(0));
    }

    public static boolean isConstructorSymbol(JSPsiElementBase function) {
        if (function instanceof JSFunction && ((JSFunction)function).isConstructor()) {
            return true;
        }
        return JSSymbolUtil.isConstructorName(function.getName());
    }

    public static void forEachIdentifierProperty(JSObjectLiteralExpression value, PropertyProcessor propertyProcessor) {
        for (JSProperty property : value.getProperties()) {
            String s = property.getName();
            if (s == null || s.length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
            propertyProcessor.process(StringUtil.toTitleCase((String)s), property);
        }
    }

    public static boolean isExtendCallOutsideFunction(JSExpression qualifier, String calledMethodName, @Nullable Ref<JSContext> outContext) {
        if ("inherits".equals(calledMethodName)) {
            if (outContext != null && qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, "goog")) {
                outContext.set((Object)JSContext.INSTANCE);
            }
            return qualifier != null;
        }
        return qualifier != null && CREATE_METHOD_PART.equals(calledMethodName);
    }

    @NonNls
    public static String suggestSetterName(String propertyName) {
        return "set" + StringUtil.capitalize((String)propertyName);
    }

    @NonNls
    public static String suggestGetterName(String propertyName) {
        return "get" + StringUtil.capitalize((String)propertyName);
    }

    static JSElement findNameComponent(JSElement expr) {
        if (expr instanceof JSReferenceExpression) {
            return expr;
        }
        JSElement current = expr;
        while (expr != null) {
            if (expr instanceof JSReferenceExpression) {
                return expr;
            }
            if (expr instanceof JSAssignmentExpression) {
                JSExpression lOperand;
                JSExpression _lOperand = ((JSAssignmentExpression)expr).getLOperand();
                if (!(_lOperand instanceof JSDefinitionExpression) || !((lOperand = ((JSDefinitionExpression)_lOperand).getExpression()) instanceof JSReferenceExpression)) break;
                expr = lOperand;
                continue;
            }
            if (expr instanceof JSVariable) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSExpression method = ((JSCallExpression)expr).getMethodExpression();
                if (method instanceof JSReferenceExpression) {
                    return method;
                }
            } else {
                current = expr;
            }
            if (current == null) continue;
            PsiElement parent = current.getParent();
            if (!(parent instanceof JSElement) || parent instanceof JSStatement) break;
            expr = (JSElement)parent;
        }
        return null;
    }

    static JSElement findExportedNameComponent(JSElement expr) {
        while (expr instanceof JSAssignmentExpression) {
            JSExpression rOperand = ((JSAssignmentExpression)expr).getROperand();
            expr = rOperand instanceof JSAssignmentExpression ? rOperand : ((JSAssignmentExpression)expr).getLOperand();
        }
        if (expr instanceof JSDefinitionExpression) {
            expr = ((JSDefinitionExpression)expr).getExpression();
        }
        if (expr instanceof JSReferenceExpression) {
            return expr;
        }
        return null;
    }

    @NotNull
    public static List<String> buildNameIndexArray(JSElement _expr) {
        final ArrayList<String> nameComponents = new ArrayList<String>();
        JSElement nameComponent = JSSymbolUtil.findNameComponent(_expr);
        JSReferenceExpression expr = null;
        if (nameComponent instanceof JSVariable) {
            String varName = nameComponent.getName();
            if (varName != null) {
                nameComponents.add(varName);
            }
        } else if (nameComponent instanceof JSReferenceExpression) {
            expr = (JSReferenceExpression)nameComponent;
        }
        if (expr != null) {
            final JSReferenceExpression expr1 = expr;
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder(expr, new ReferenceExpressionProcessor(){

                @Override
                public void processExpression(JSReferenceExpression expr) {
                    JSType predefinedType = JSSymbolUtil.getPredefinedType(expr);
                    String name = predefinedType != null ? predefinedType.getTypeText(JSType.TypeTextFormat.SIMPLE) : expr.getReferencedName();
                    nameComponents.add(JavaScriptIndex.intern(name));
                }

                @Override
                public void processUnresolvedThis() {
                    nameComponents.add("");
                }

                @Override
                public boolean isTopLevel(JSReferenceExpression expression) {
                    return expr1 == expression;
                }
            });
        }
        ArrayList<String> arrayList = nameComponents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSSymbolUtil", "buildNameIndexArray"));
        }
        return arrayList;
    }

    static void visitReferenceExpressionComponentsInRootFirstOrder(JSReferenceExpression expr, ReferenceExpressionProcessor processor) {
        String refName;
        JSExpression qualifier = expr.getQualifier();
        if (qualifier instanceof JSCallExpression) {
            qualifier = ((JSCallExpression)qualifier).getMethodExpression();
        }
        if (qualifier instanceof JSIndexedPropertyAccessExpression) {
            qualifier = ((JSIndexedPropertyAccessExpression)qualifier).getQualifier();
        }
        if (qualifier instanceof JSReferenceExpression) {
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder((JSReferenceExpression)qualifier, processor);
        }
        if (qualifier instanceof JSThisExpression) {
            processor.processUnresolvedThis();
        }
        if ((refName = expr.getReferencedName()) != null && (!refName.equals("prototype") || processor.isTopLevel(expr))) {
            processor.processExpression(expr);
        }
    }

    public static boolean binaryOpTypeToAvoidRecursions(IElementType sign) {
        return sign == JSTokenTypes.PLUS || sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.COMMA;
    }

    public static boolean isMeaningfulLocalVariableInitializer(JSExpression initializer) {
        return initializer instanceof JSFunction || initializer instanceof JSObjectLiteralExpression;
    }

    public static boolean isInterface(@NotNull String name, PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/index/JSSymbolUtil", "isInterface"));
        }
        return JSClassIndex.isInterface(name, context);
    }

    @Nullable
    private static JSNamespaceEvaluationResult evaluateInitializedPrototype(JSExpression initializer, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        JSExpression operand;
        JSBinaryExpression binaryExpression;
        if (outSourceReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outSourceReference", "com/intellij/lang/javascript/index/JSSymbolUtil", "evaluateInitializedPrototype"));
        }
        if (initializer instanceof JSParenthesizedExpression) {
            initializer = JSUtils.unparenthesize(initializer);
        }
        if (initializer instanceof JSBinaryExpression && (binaryExpression = (JSBinaryExpression)initializer).getOperationSign() == JSTokenTypes.OROR && (operand = binaryExpression.getLOperand()) instanceof JSReferenceExpression) {
            outSourceReference.set((Object)((JSReferenceExpression)operand));
            return JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)operand, JSContext.STATIC, true);
        }
        JSReferenceExpression initializedPrototype = null;
        JSTypeContext typeContext = JSTypeContext.UNKNOWN;
        if (initializer instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)initializer).getReferencedName())) {
            JSExpression qualifier = ((JSReferenceExpression)initializer).getQualifier();
            if (qualifier instanceof JSReferenceExpression) {
                initializedPrototype = (JSReferenceExpression)qualifier;
                typeContext = JSTypeContext.PROTOTYPE;
            }
        } else {
            JSTypeEvaluationResult type;
            if (initializer instanceof JSReferenceExpression && WINDOW_OBJECT_NAME.equals(((JSReferenceExpression)initializer).getReferencedName())) {
                outSourceReference.set((Object)((JSReferenceExpression)initializer));
                return JSSymbolUtil.createWindowNamespace((JSReferenceExpression)initializer, true);
            }
            if (initializer instanceof JSAssignmentExpression) {
                JSExpression initializerlOperand = ((JSAssignmentExpression)initializer).getLOperand();
                if (initializerlOperand instanceof JSDefinitionExpression) {
                    JSExpression lOperand = ((JSDefinitionExpression)initializerlOperand).getExpression();
                    JSSymbolUtil.evaluateInitializedPrototype(lOperand, outSourceReference);
                    initializedPrototype = (JSReferenceExpression)outSourceReference.get();
                    if (initializedPrototype == null && lOperand instanceof JSReferenceExpression && ((JSReferenceExpression)lOperand).getQualifier() instanceof JSReferenceExpression) {
                        initializedPrototype = (JSReferenceExpression)lOperand;
                    }
                }
            } else if (initializer instanceof JSThisExpression && (type = JSContextResolver.resolveContext((PsiElement)initializer)).getType() != null) {
                return type.toNamespaceEvaluationResult();
            }
        }
        if (initializedPrototype == null) {
            return null;
        }
        outSourceReference.set(initializedPrototype);
        return JSSymbolUtil.createNamespaceFromReferenceExpression(initializedPrototype, typeContext.toJSContext(), true);
    }

    @Nullable
    public static JSReferenceExpression createRef(String text, @NotNull PsiElement initializer) {
        PsiElement expr;
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/lang/javascript/index/JSSymbolUtil", "createRef"));
        }
        if (!StringUtil.isEmpty((String)text) && (expr = JSInheritedLanguagesHelper.createExpressionFromText(text, initializer, false)) instanceof JSReferenceExpression) {
            return (JSReferenceExpression)expr;
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult evaluateNamespaceLocally(@NotNull JSReferenceExpression lOperand) {
        Map cachedMap;
        if (lOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOperand", "com/intellij/lang/javascript/index/JSSymbolUtil", "evaluateNamespaceLocally"));
        }
        JSExpression qualifier = lOperand.getQualifier();
        if (qualifier != null) {
            JSNamespaceEvaluationResult qualifierNs;
            String name = lOperand.getReferencedName();
            if (JSSymbolUtil.isPrototype(name) && qualifier instanceof JSReferenceExpression && (qualifierNs = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifier)) != null) {
                return new JSNamespaceEvaluationResult(qualifierNs.getQualifiedName(), JSContext.INSTANCE, qualifierNs.isExplicitlyDeclared(), true, qualifierNs.getSource());
            }
            return null;
        }
        final PsiFile containingFile = lOperand.getContainingFile();
        CachedValue value = (CachedValue)containingFile.getUserData(cachedClassExtendingKey);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)containingFile.getManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<JSReferenceExpression, JSNamespaceEvaluationResult>>(){

                public CachedValueProvider.Result<Map<JSReferenceExpression, JSNamespaceEvaluationResult>> compute() {
                    return new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap(100)), new Object[]{containingFile});
                }
            }, false);
            containingFile.putUserData(cachedClassExtendingKey, (Object)value);
        }
        if ((cachedMap = (Map)value.getValue()).containsKey(lOperand)) {
            return (JSNamespaceEvaluationResult)((Object)cachedMap.get(lOperand));
        }
        JSNamespaceEvaluationResult type = JSSymbolUtil.evaluateNamespaceLocally(lOperand, null);
        cachedMap.put(lOperand, type);
        return type;
    }

    @Nullable
    public static JSType getPredefinedType(JSReferenceExpression expression) {
        if (expression.getQualifier() == null && WINDOW_OBJECT_NAME.equals(expression.getReferencedName())) {
            return JSSymbolUtil.createWindowType((PsiElement)expression);
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult getPredefinedNamespace(JSReferenceExpression expression) {
        if (expression.getQualifier() == null && WINDOW_OBJECT_NAME.equals(expression.getReferencedName())) {
            return JSSymbolUtil.createWindowNamespace(expression, true);
        }
        return null;
    }

    private static JSType createWindowType(PsiElement source) {
        return JSNamedType.createType("Window", JSTypeSourceFactory.createTypeSource(source, true), JSTypeContext.PROTOTYPE);
    }

    private static JSNamespaceEvaluationResult createWindowNamespace(JSReferenceExpression expression, boolean isExplicitlyDeclared) {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.create("Window", null);
        return new JSNamespaceEvaluationResult(name, JSContext.INSTANCE, isExplicitlyDeclared, true, (JSElement)expression);
    }

    public static JSNamespaceEvaluationResult evaluateNamespaceLocallyAsIs(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSSymbolUtil", "evaluateNamespaceLocallyAsIs"));
        }
        JSNamespaceEvaluationResult result = JSSymbolUtil.evaluateNamespaceLocally(expression);
        if (result == null && expression instanceof JSReferenceExpression) {
            result = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expression, JSContext.STATIC, false);
        }
        return result;
    }

    @Nullable
    public static JSNamespaceEvaluationResult evaluateNamespaceLocally(@Nullable JSExpression expression) {
        JSExpression[] arguments;
        JSExpression methodExpression;
        if (expression instanceof JSReferenceExpression) {
            JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)expression);
            if (ns != null) {
                return ns;
            }
            JSNamespaceEvaluationResult rawType = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expression, JSContext.STATIC, true, false, true);
            if (rawType != null) {
                return JSSymbolUtil.replaceLocalVars(rawType, (JSReferenceExpression)expression, null);
            }
        } else if (expression instanceof JSThisExpression) {
            Ref ref = Ref.create(null);
            JSNamespaceEvaluationResult namespace = JSSymbolUtil.evalThis((JSThisExpression)expression, (Ref<JSReferenceExpression>)ref);
            if (namespace != null) {
                return JSSymbolUtil.replaceLocalVars(namespace, (JSReferenceExpression)ref.get(), null);
            }
        } else if (expression instanceof JSNewExpression) {
            JSNamespaceEvaluationResult innerResult = JSSymbolUtil.evaluateNamespaceLocally(((JSNewExpression)expression).getMethodExpression());
            if (innerResult != null && innerResult.getJSContext() == JSContext.STATIC) {
                return new JSNamespaceEvaluationResult(innerResult.getQualifiedName(), JSContext.INSTANCE, innerResult.isExplicitlyDeclared(), false, innerResult.getSource());
            }
        } else if (expression instanceof JSCallExpression && (methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", CREATE_METHOD_PART) || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", EXTEND_METHOD_PART)) && (arguments = ((JSCallExpression)expression).getArguments()).length > 0) {
            return JSSymbolUtil.evaluateNamespaceLocally(arguments[0]);
        }
        return null;
    }

    @Nullable
    public static JSType evaluateTypeLocally(JSExpression expression) {
        if (expression instanceof JSLiteralExpression) {
            return JSTypeEvaluator.getTypeFromConstant(expression, DialectDetector.isActionScript((PsiElement)expression));
        }
        if (expression instanceof JSArrayLiteralExpression) {
            return new JSPrimitiveArrayType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, true), JSTypeContext.INSTANCE);
        }
        return null;
    }

    @Nullable
    private static JSNamespaceEvaluationResult evaluateNamespaceLocally(JSReferenceExpression lOperand, @Nullable Set<String> visited) {
        JSNamespaceEvaluationResult predefinedType = JSSymbolUtil.getPredefinedNamespace(lOperand);
        if (predefinedType != null) {
            return predefinedType;
        }
        JSReferenceExpression originalExpr = lOperand;
        JSElement expressionToFollow = JSSymbolUtil.calcRefExprValue(lOperand);
        JSNamespaceEvaluationResult ns = null;
        boolean forceUseType = false;
        JSContext jsContext = JSContext.STATIC;
        if (expressionToFollow != null) {
            JSNamespaceEvaluationResult outerType;
            Ref ref = Ref.create(null);
            if (expressionToFollow instanceof JSExpression) {
                ns = JSSymbolUtil.evaluateInitializedPrototype((JSExpression)expressionToFollow, (Ref<JSReferenceExpression>)ref);
            }
            if (ns == null && (outerType = JSSymbolUtil.checkAnonymousCallForClassExtension(lOperand.getText(), expressionToFollow)) != null) {
                ns = outerType;
                forceUseType = true;
                JSElement source = outerType.getSource();
                if (source instanceof JSReferenceExpression) {
                    ref.set((Object)((JSReferenceExpression)source));
                }
            }
            if (ns != null) {
                lOperand = (JSReferenceExpression)ref.get();
                forceUseType = true;
                jsContext = ns.getJSContext();
            } else if (expressionToFollow instanceof JSReferenceExpression) {
                PsiElement localVariableRef;
                JSFunction function;
                JSReferenceExpression referenceExpression = (JSReferenceExpression)expressionToFollow;
                if (referenceExpression.getQualifier() == null && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expressionToFollow, JSFunction.class)) != null && (localVariableRef = JSResolveUtil.getLocalVariableRef(function, referenceExpression)) != null) {
                    referenceExpression = originalExpr;
                }
                lOperand = referenceExpression;
            } else if (expressionToFollow instanceof JSCallExpression) {
                JSExpression methodExpr = ((JSCallExpression)expressionToFollow).getMethodExpression();
                if (methodExpr instanceof JSParenthesizedExpression) {
                    methodExpr = ((JSParenthesizedExpression)methodExpr).getInnerExpression();
                }
                if (methodExpr instanceof JSFunctionExpression) {
                    JSReferenceExpression resultIf = JSSymbolUtil.calcRefExprUsedForClassExtension((JSFunctionExpression)methodExpr, (PsiElement)expressionToFollow, null);
                    if (resultIf != null) {
                        lOperand = resultIf;
                    }
                } else if (expressionToFollow instanceof JSNewExpression) {
                    if (methodExpr instanceof JSReferenceExpression && !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpr, "Object")) {
                        JSElement element = JSSymbolUtil.calcRefExprValue((JSReferenceExpression)methodExpr);
                        JSReferenceExpression refExpr = (JSReferenceExpression)(element instanceof JSReferenceExpression ? element : methodExpr);
                        return JSSymbolUtil.createNamespaceFromReferenceExpression(refExpr, JSContext.INSTANCE, false);
                    }
                } else {
                    JSArgumentList list = ((JSCallExpression)expressionToFollow).getArgumentList();
                    if (list != null && methodExpr instanceof JSReferenceExpression) {
                        JSExpression[] jsExpressions = list.getArguments();
                        String methodName = ((JSReferenceExpression)methodExpr).getReferencedName();
                        if (jsExpressions.length >= 2 && jsExpressions[0] instanceof JSReferenceExpression && jsExpressions[1] instanceof JSReferenceExpression && methodName != null && JSSymbolUtil.symbolSeemsToBeExtensionFunction(methodName)) {
                            lOperand = (JSReferenceExpression)jsExpressions[0];
                            jsContext = JSContext.UNKNOWN;
                        }
                    }
                }
            } else if (expressionToFollow instanceof JSThisExpression && (ns = JSSymbolUtil.evalThis((JSThisExpression)expressionToFollow, (Ref<JSReferenceExpression>)ref)) != null) {
                forceUseType = true;
                lOperand = (JSReferenceExpression)ref.get();
            }
            if (ns == null && originalExpr == lOperand) {
                if (expressionToFollow instanceof JSExpression) {
                    expressionToFollow = JSStubBasedPsiTreeUtil.getInitializedElement((JSExpression)expressionToFollow);
                }
                if ((expressionToFollow instanceof JSVariable || expressionToFollow instanceof JSFunction) && ((JSQualifiedNamedElement)expressionToFollow).isNamespaceExplicitlyDeclared()) {
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)expressionToFollow));
                    ns = new JSNamespaceEvaluationResult(qName, jsContext, true, true, expressionToFollow);
                    forceUseType = true;
                }
            }
        }
        if (lOperand != originalExpr && lOperand != null || forceUseType) {
            if (ns == null) {
                ns = JSSymbolUtil.createNamespaceFromReferenceExpression(lOperand, jsContext, true);
            }
            if (ns != null) {
                return JSSymbolUtil.replaceLocalVars(ns, lOperand, visited);
            }
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult checkAnonymousCallForClassExtension(String name, JSElement scopeElement) {
        JSFunctionExpression funExpr = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)scopeElement, JSFunctionExpression.class);
        if (funExpr != null) {
            JSReferenceExpression resultIf;
            PsiElement parentOfFunExpr = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)funExpr);
            JSFunctionExpression grandParentForExtensionCalculation = null;
            if (parentOfFunExpr instanceof JSVariable) {
                grandParentForExtensionCalculation = funExpr;
            } else if (parentOfFunExpr instanceof JSCallExpression) {
                grandParentForExtensionCalculation = parentOfFunExpr;
            }
            if (grandParentForExtensionCalculation != null && (resultIf = JSSymbolUtil.calcRefExprUsedForClassExtension(funExpr, (PsiElement)grandParentForExtensionCalculation, name)) != null) {
                return JSSymbolUtil.createNamespaceFromReferenceExpression(resultIf, JSContext.STATIC, true);
            }
        }
        return null;
    }

    public static JSElement calcRefExprValue(@NotNull JSReferenceExpression lOperand) {
        if (lOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOperand", "com/intellij/lang/javascript/index/JSSymbolUtil", "calcRefExprValue"));
        }
        ASTNode node = lOperand.getNode();
        if (JSReferenceExpressionImpl.getQualifierNode(node) != null) {
            return null;
        }
        String referenceName = JSReferenceExpressionImpl.getReferenceName(node);
        if (referenceName == null) {
            return null;
        }
        return JSSymbolUtil.calcRefExprValue(referenceName, (JSElement)lOperand);
    }

    public static JSElement calcRefExprValue(@NotNull String name, @NotNull JSElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/index/JSSymbolUtil", "calcRefExprValue"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/JSSymbolUtil", "calcRefExprValue"));
        }
        PsiElement parent = context.getParent();
        ASTNode node = context.getNode();
        JSTreeUtil.JSScopeDeclarationsAndAssignments up = JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, node);
        if (up == null) {
            return null;
        }
        CompositeElement definition = up.findNearestDefinition(node);
        PsiElement jsElement = definition.getPsi();
        if (jsElement == null && parent instanceof JSDefinitionExpression) {
            jsElement = parent;
        }
        JSExpression expressionToFollow = null;
        if (jsElement instanceof JSVariable) {
            JSType type = ((JSVariable)jsElement).getType();
            if (type != null && type.getSource().isExplicitlyDeclared()) {
                expressionToFollow = null;
            } else if (jsElement instanceof JSParameter) {
                JSParameter parameter = (JSParameter)jsElement;
                JSNamespaceEvaluationResult initialization = JSSymbolUtil.getParameterInitialization(parameter);
                if (initialization != null && initialization.getSource() != null) {
                    return initialization.getSource();
                }
            } else if (!(jsElement.getParent() instanceof JSDestructuringProperty) && !(jsElement.getParent() instanceof JSDestructuringContainer)) {
                expressionToFollow = ((JSVariable)jsElement).getInitializer();
            }
        } else {
            JSExpression rOperand;
            if (jsElement instanceof JSFunction) {
                return (JSFunction)jsElement;
            }
            if (jsElement instanceof JSDefinitionExpression && (rOperand = JSPsiImplUtils.getRightmostOperand((JSDefinitionExpression)jsElement)) != null) {
                expressionToFollow = rOperand;
            }
        }
        return expressionToFollow;
    }

    @Nullable
    private static JSNamespaceEvaluationResult evalThis(JSThisExpression expressionToFollow, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        if (outSourceReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outSourceReference", "com/intellij/lang/javascript/index/JSSymbolUtil", "evalThis"));
        }
        JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateInitializedPrototype((JSExpression)expressionToFollow, outSourceReference);
        if (ns != null) {
            return ns.withExplicitlyDeclared(true);
        }
        boolean thisIsGlobal = false;
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expressionToFollow, JSFunction.class);
        if (function == null || function.isAnonymousFunctionCall()) {
            thisIsGlobal = true;
        } else if (function instanceof JSFunctionExpression) {
            PsiElement functionParent = function.getParent();
            if (functionParent instanceof JSParenthesizedExpression) {
                functionParent = functionParent.getParent();
            }
            if (functionParent instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)functionParent).getReferencedName())) {
                PsiElement prevParent = functionParent;
                if ((functionParent = functionParent.getParent()) instanceof JSCallExpression && ((JSCallExpression)functionParent).getMethodExpression() == prevParent) {
                    JSExpression[] arguments = ((JSCallExpression)functionParent).getArguments();
                    if (arguments.length > 0) {
                        ns = JSSymbolUtil.evaluateInitializedPrototype(arguments[0], outSourceReference);
                        if (outSourceReference.isNull() && arguments[0] instanceof JSThisExpression && PsiTreeUtil.getParentOfType((PsiElement)arguments[0], (Class[])new Class[]{JSFunction.class, JSObjectLiteralExpression.class}) == null) {
                            thisIsGlobal = true;
                        }
                    } else {
                        thisIsGlobal = true;
                    }
                }
            }
        }
        if (thisIsGlobal) {
            return JSSymbolUtil.createWindowNamespace(null, false);
        }
        return ns;
    }

    @Nullable
    private static JSReferenceExpression calcRefExprUsedForClassExtension(JSFunctionExpression funExpr, PsiElement grandParent, String name) {
        JSExpression expr;
        JSSourceElement[] body = funExpr.getBody();
        if (body.length == 0) {
            return null;
        }
        JSStatement lastStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)body[0].getLastChild(), JSStatement.class);
        if (lastStatement instanceof JSReturnStatement && (expr = ((JSReturnStatement)lastStatement).getExpression()) != null && (name == null || JSSymbolUtil.isReferencingName(name, expr))) {
            JSReferenceExpression ref;
            PsiElement grandGrandParent = JSPsiImplUtils.getNonParenthesizeParent(grandParent);
            if (grandGrandParent instanceof JSAssignmentExpression) {
                JSExpression definedExpr;
                JSExpression jsExpression = ((JSAssignmentExpression)grandGrandParent).getLOperand();
                if (jsExpression instanceof JSDefinitionExpression && (definedExpr = ((JSDefinitionExpression)jsExpression).getExpression()) instanceof JSReferenceExpression) {
                    return (JSReferenceExpression)definedExpr;
                }
            } else if (grandGrandParent instanceof JSVariable && (ref = JSSymbolUtil.createRef(((JSVariable)grandGrandParent).getName(), grandGrandParent)) != null) {
                return ref;
            }
        }
        return null;
    }

    private static boolean isReferencingName(@Nullable String name, @Nullable JSExpression expr) {
        if (expr instanceof JSReferenceExpression) {
            JSReferenceExpression ref = (JSReferenceExpression)expr;
            return Comparing.equal((String)name, (String)ref.getReferencedName()) && ref.getQualifier() == null;
        }
        return false;
    }

    @Nullable
    public static JSType evaluateReturnedTypeLocally(@NotNull JSFunction function) {
        JSExpression methodExpression;
        JSExpression returnExpression;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/index/JSSymbolUtil", "evaluateReturnedTypeLocally"));
        }
        JSSourceElement[] body = function.getBody();
        if (body.length == 0) {
            return null;
        }
        JSStatement lastStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)body[0].getLastChild(), JSStatement.class);
        if (lastStatement instanceof JSReturnStatement && (returnExpression = ((JSReturnStatement)lastStatement).getExpression()) instanceof JSNewExpression && (methodExpression = ((JSNewExpression)returnExpression).getMethodExpression()) instanceof JSReferenceExpression) {
            return JSSymbolUtil.createTypeFromReferenceExpression((JSReferenceExpression)methodExpression, JSTypeContext.INSTANCE);
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult replaceLocalVars(JSReferenceExpression expression) {
        JSNamespaceEvaluationResult ns = JSSymbolUtil.createNamespaceFromReferenceExpression(expression, JSContext.UNKNOWN, true);
        if (ns != null) {
            return JSSymbolUtil.replaceLocalVars(ns, expression, null);
        }
        return null;
    }

    @Nullable
    private static JSNamespaceEvaluationResult replaceLocalVars(@NotNull JSNamespaceEvaluationResult ns, @Nullable JSReferenceExpression expression, @Nullable Set<String> visited) {
        String name;
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/lang/javascript/index/JSSymbolUtil", "replaceLocalVars"));
        }
        if (expression == null) {
            return ns;
        }
        JSFunction func = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        if (func == null) {
            return ns;
        }
        JSQualifiedName innerMostQName = ns.getQualifiedName();
        if (innerMostQName == null) {
            return ns;
        }
        JSQualifiedName qualifier = innerMostQName.getParent();
        while (qualifier != null) {
            innerMostQName = qualifier;
            qualifier = innerMostQName.getParent();
        }
        JSReferenceExpression innerMostExpr = expression;
        while (innerMostExpr.getQualifier() != null) {
            JSExpression innerMostExprQualifier = innerMostExpr.getQualifier();
            if (!(innerMostExprQualifier instanceof JSReferenceExpression)) {
                return ns;
            }
            innerMostExpr = (JSReferenceExpression)innerMostExprQualifier;
        }
        PsiElement ref = JSResolveUtil.getLocalVariableRef(func, innerMostQName.getName());
        if (ref instanceof JSParameter) {
            return null;
        }
        if (ref instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)ref).getInitializer();
            if (initializer instanceof JSReferenceExpression) {
                JSNamespaceEvaluationResult initializerType = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)initializer, ns.getJSContext(), ns.isDeclaration());
                return JSSymbolUtil.replaceExpression(ns, innerMostQName, initializerType != null ? initializerType.getQualifiedName() : null);
            }
            if (visited == null) {
                visited = new THashSet();
            }
            String replaced = innerMostQName.getQualifiedName();
            boolean added = visited.add(replaced);
            if (innerMostExpr != expression && added) {
                JSNamespaceEvaluationResult innerMostType = JSSymbolUtil.evaluateNamespaceLocally(innerMostExpr, (Set<String>)visited);
                if (innerMostType == null) {
                    String name2 = innerMostExpr.getReferenceName();
                    if (JSSymbolUtil.isImportantName(name2)) {
                        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, ns.getJSContext(), ns.isDeclaration());
                    }
                    return null;
                }
                return JSSymbolUtil.replaceExpression(ns, innerMostQName, innerMostType.getQualifiedName());
            }
            if (added) {
                JSNamespaceEvaluationResult innerResult = JSSymbolUtil.evaluateNamespaceLocally(innerMostExpr, (Set<String>)visited);
                if (innerResult == null) {
                    return null;
                }
                JSContext jsContext = JSTypeUtils.combineJSContexts(innerResult.getJSContext(), ns.getJSContext());
                return new JSNamespaceEvaluationResult(innerResult.getQualifiedName(), jsContext, innerResult.isExplicitlyDeclared(), innerResult.isDeclaration(), innerResult.getSource());
            }
        } else if (ref == null && WINDOW_OBJECT_NAME.equals(name = innerMostExpr.getReferenceName())) {
            String text = expression.getText();
            JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName(text.substring(text.indexOf(46) + 1));
            return new JSNamespaceEvaluationResult(qName, JSContext.UNKNOWN, false, true, null);
        }
        return ns;
    }

    public static boolean isAccurateReferenceExpression(@NotNull JSReferenceExpression initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/lang/javascript/index/JSSymbolUtil", "isAccurateReferenceExpression"));
        }
        JSExpression initializerQualifier = initializer.getQualifier();
        while (initializerQualifier instanceof JSReferenceExpression) {
            initializerQualifier = ((JSReferenceExpression)initializerQualifier).getQualifier();
        }
        return initializerQualifier == null;
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceExpression referenceExpression, String ... components) {
        JSReferenceExpression ref = referenceExpression;
        int i = components.length - 1;
        while (ref != null) {
            if (i < 0) {
                return false;
            }
            if (!StringUtil.equals((CharSequence)ref.getReferenceName(), (CharSequence)components[i])) {
                return false;
            }
            JSExpression qualifier = ref.getQualifier();
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            ref = (JSReferenceExpression)qualifier;
            --i;
        }
        return i == -1;
    }

    public static boolean isArgumentOfCallWithName(@NotNull JSExpression argument, String ... components) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/index/JSSymbolUtil", "isArgumentOfCallWithName"));
        }
        PsiElement argumentList = argument.getParent();
        if (!(argumentList instanceof JSArgumentList)) {
            return false;
        }
        PsiElement callExpression = argumentList.getParent();
        if (!(callExpression instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
        return methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, components);
    }

    @Nullable
    public static JSQualifiedName getAccurateReferenceName(@NotNull PsiQualifiedReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/index/JSSymbolUtil", "getAccurateReferenceName"));
        }
        String referenceName = reference.getReferenceName();
        if (referenceName == null) {
            return null;
        }
        PsiElement qualifier = reference.getQualifier();
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(referenceName, null);
        }
        if (qualifier instanceof PsiQualifiedReference) {
            JSQualifiedName qualifierName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)qualifier);
            return qualifierName != null ? JSQualifiedNameImpl.create(referenceName, qualifierName) : null;
        }
        return null;
    }

    @Nullable
    public static JSType createTypeFromReferenceExpression(@NotNull JSReferenceExpression expression, JSTypeContext staticOrInstance) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSSymbolUtil", "createTypeFromReferenceExpression"));
        }
        JSType predefinedType = JSSymbolUtil.getPredefinedType(expression);
        if (predefinedType != null) {
            return predefinedType;
        }
        return JSSymbolUtil.isAccurateReferenceExpression(expression) ? (JSSymbolUtil.isExplicitExportReference((JSExpression)expression) ? JSNamedType.createType(EXPORTS, JSTypeSourceFactory.createTypeSource((PsiElement)expression), staticOrInstance) : JSNamedType.createType(expression.getText(), JSTypeSourceFactory.createTypeSource((PsiElement)expression), staticOrInstance)) : null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, JSContext jsContext, boolean isDeclaration) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSSymbolUtil", "createNamespaceFromReferenceExpression"));
        }
        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, jsContext, isDeclaration, false);
    }

    @Nullable
    public static JSNamespaceEvaluationResult createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, @NotNull JSContext jsContext, boolean isDeclaration, boolean inheritsFunction) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSSymbolUtil", "createNamespaceFromReferenceExpression"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/index/JSSymbolUtil", "createNamespaceFromReferenceExpression"));
        }
        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, jsContext, isDeclaration, inheritsFunction, false);
    }

    @Nullable
    public static JSNamespaceEvaluationResult createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, @NotNull JSContext jsContext, boolean isDeclaration, boolean inheritsFunction, boolean explicitlyDeclared) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSSymbolUtil", "createNamespaceFromReferenceExpression"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/index/JSSymbolUtil", "createNamespaceFromReferenceExpression"));
        }
        JSNamespaceEvaluationResult predefinedNs = JSSymbolUtil.getPredefinedNamespace(expression);
        if (predefinedNs != null) {
            return predefinedNs;
        }
        String name = expression.getReferencedName();
        if (JSSymbolUtil.isPrototype(name)) {
            JSExpression qualifier = expression.getQualifier();
            if (!(qualifier instanceof JSReferenceExpression)) {
                return null;
            }
            expression = (JSReferenceExpression)qualifier;
            jsContext = JSContext.INSTANCE;
            isDeclaration = true;
        }
        if (!JSSymbolUtil.isAccurateReferenceExpression(expression)) {
            return null;
        }
        if (JSSymbolUtil.isExplicitExportReference((JSExpression)expression)) {
            return new JSNamespaceEvaluationResult(JSQualifiedNameImpl.create(EXPORTS, null), jsContext, explicitlyDeclared, isDeclaration, inheritsFunction, (JSElement)expression);
        }
        String text = expression.getText();
        if (text.startsWith("window.")) {
            text = "Window" + text.substring(WINDOW_OBJECT_NAME.length());
        }
        return new JSNamespaceEvaluationResult(JSQualifiedNameImpl.fromQualifiedName(text), jsContext, explicitlyDeclared, isDeclaration, inheritsFunction, (JSElement)expression);
    }

    private static boolean isPrototype(String name) {
        return "prototype".equals(name) || FN_FUN_NAME.equals(name);
    }

    @Nullable
    public static JSQualifiedName evaluateReferencedNamespace(JSExpression expression) {
        SmartList components = new SmartList();
        boolean canBeEvaluated = true;
        while (canBeEvaluated) {
            if (expression instanceof JSReferenceExpression) {
                JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)expression);
                if (ns != null && ns.getQualifiedName() != null) {
                    components.addAll(0, QualifiedName.fromDottedString((String)ns.getQualifiedName().getQualifiedName()).getComponents());
                    break;
                }
                String name = ((JSReferenceExpression)expression).getReferencedName();
                if (!"prototype".equals(name)) {
                    components.add(0, name);
                }
                expression = ((JSReferenceExpression)expression).getQualifier();
                continue;
            }
            if (expression instanceof JSIndexedPropertyAccessExpression) {
                JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
                if (indexExpression instanceof JSLiteralExpression) {
                    components.add(0, ((JSLiteralExpression)indexExpression).getValueAsPropertyName());
                }
                expression = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
                continue;
            }
            if (expression == null || expression instanceof JSThisExpression) break;
            canBeEvaluated = false;
        }
        return canBeEvaluated ? JSQualifiedNameImpl.fromComponents((List<String>)components) : null;
    }

    @Nullable
    public static JSQualifiedName getReferencedNamespace(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSSymbolUtil", "getReferencedNamespace"));
        }
        JSExpression qualifier = null;
        String name = null;
        if (expression instanceof JSReferenceExpression) {
            name = ((JSReferenceExpression)expression).getReferencedName();
            qualifier = ((JSReferenceExpression)expression).getQualifier();
        } else if (expression instanceof JSIndexedPropertyAccessExpression) {
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
            if (indexExpression instanceof JSLiteralExpression) {
                name = ((JSLiteralExpression)indexExpression).getValueAsPropertyName();
            }
            qualifier = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
        }
        if (name == null) {
            return null;
        }
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(name, null);
        }
        JSQualifiedName namespace = JSSymbolUtil.getReferencedNamespace(qualifier);
        return namespace != null && !"prototype".equals(name) ? JSQualifiedNameImpl.create(name, namespace) : namespace;
    }

    @Nullable
    public static JSQualifiedName getLiteralValueAsQualifiedName(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/lang/javascript/index/JSSymbolUtil", "getLiteralValueAsQualifiedName"));
        }
        if (literal.isQuotedLiteral()) {
            if (literal.getTextLength() > 200) {
                return null;
            }
            String text = literal.getText();
            if (StringUtil.containsWhitespaces((CharSequence)text)) {
                return null;
            }
            return JSQualifiedNameImpl.fromQualifiedName(StringUtil.unquoteString((String)text));
        }
        return null;
    }

    public static boolean isImportantName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        char ch = name.charAt(0);
        return Character.isUpperCase(ch) || ch == '$';
    }

    @Nullable
    private static JSNamespaceEvaluationResult replaceExpression(@NotNull JSNamespaceEvaluationResult ns, @NotNull JSQualifiedName what, @Nullable JSQualifiedName by) {
        JSQualifiedName replaced;
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/lang/javascript/index/JSSymbolUtil", "replaceExpression"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/lang/javascript/index/JSSymbolUtil", "replaceExpression"));
        }
        JSQualifiedName initialQName = ns.getQualifiedName();
        if (initialQName == null) {
            replaced = by;
        } else {
            if (by == null || initialQName.equals(what)) {
                return null;
            }
            JSQualifiedNameImpl tail = null;
            for (JSQualifiedName qualifier = initialQName; qualifier != null && qualifier != what; qualifier = qualifier.getParent()) {
                tail = JSQualifiedNameImpl.create(qualifier.getName(), tail);
            }
            assert (tail != null);
            replaced = tail.withQualifier(by);
        }
        return new JSNamespaceEvaluationResult(replaced, ns.getJSContext(), false, ns.isDeclaration(), ns.getSource());
    }

    @Nullable
    public static JSElement findQualifyingExpressionFromArgumentList(JSArgumentList parent) {
        PsiElement firstParent = parent.getParent();
        if (!(firstParent instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression call = (JSCallExpression)firstParent;
        JSExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression instanceof JSReferenceExpression ? ((JSReferenceExpression)methodExpression).getReferencedName() : null;
        PsiElement grandParent = firstParent.getParent();
        if (grandParent instanceof JSVariable) {
            return (JSElement)grandParent;
        }
        if (grandParent instanceof JSAssignmentExpression) {
            JSExpression assignedTo;
            JSExpression jsExpression = ((JSAssignmentExpression)grandParent).getLOperand();
            JSExpression jSExpression = assignedTo = jsExpression instanceof JSDefinitionExpression ? ((JSDefinitionExpression)jsExpression).getExpression() : null;
            if (assignedTo instanceof JSReferenceExpression) {
                return assignedTo;
            }
        }
        if (grandParent instanceof JSExpressionStatement) {
            JSExpression expression;
            JSExpression jSExpression = expression = methodName != null ? ((JSReferenceExpression)methodExpression).getQualifier() : null;
            if ("each".equals(methodName) || EXTEND_METHOD_PART.equals(methodName)) {
                JSReferenceExpression qualifierExpr;
                if (expression instanceof JSReferenceExpression && FN_FUN_NAME.equals((qualifierExpr = (JSReferenceExpression)expression).getReferencedName())) {
                    expression = qualifierExpr.getQualifier();
                }
                if (expression != null && J_QUERY_VAR_NAME.equals(expression.getText())) {
                    return expression;
                }
            } else if (IMPLEMENT_METHOD_NAME.equals(methodName) && expression instanceof JSReferenceExpression && parent.getArguments().length == 1) {
                return expression;
            }
        }
        if (JSSymbolUtil.symbolSeemsToBeExtensionFunction(methodName) || IMPLEMENT_METHOD_NAME.equals(methodName) || JSSymbolUtil.isFrameworkMethod(methodName)) {
            return JSSymbolUtil.getFirstLiteralOrExprArg(parent);
        }
        return null;
    }

    private static boolean isFrameworkMethod(String name) {
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            for (String method : handler.interestedMethodNames()) {
                if (!StringUtil.equals((CharSequence)name, (CharSequence)method)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static JSElement getFirstLiteralOrExprArg(JSArgumentList parent) {
        JSExpression[] jsExpressions = parent.getArguments();
        for (int i = 0; i < jsExpressions.length; ++i) {
            JSExpression expr = jsExpressions[i];
            if (expr instanceof JSReferenceExpression || expr instanceof JSLiteralExpression && !expr.textContains(' ') && expr.getTextLength() < 100) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSArgumentList argumentList = ((JSCallExpression)expr).getArgumentList();
                if (argumentList == null) continue;
                jsExpressions = argumentList.getArguments();
                i = -1;
                continue;
            }
            if (!(expr instanceof JSArrayLiteralExpression)) continue;
            jsExpressions = ((JSArrayLiteralExpression)expr).getExpressions();
            i = -1;
        }
        return null;
    }

    public static boolean isExtendCall(@Nullable JSExpression qualifier, @Nullable String calledMethodName, @Nullable Ref<JSContext> outContext) {
        if (!JSSymbolUtil.symbolSeemsToBeExtensionFunction(calledMethodName)) {
            return false;
        }
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof JSReferenceExpression) || ((JSReferenceExpression)qualifier).getQualifier() != null) {
            return false;
        }
        String qualifierText = ((JSReferenceExpression)qualifier).getReferenceName();
        if ("Object".equals(qualifierText)) {
            if (outContext != null) {
                outContext.set((Object)JSContext.STATIC);
            }
            return true;
        }
        if ("Ext".equals(qualifierText)) {
            if (outContext != null) {
                outContext.set((Object)JSContext.INSTANCE);
            }
            return true;
        }
        return YAHOO_NAME.equals(qualifierText) || "_".equals(qualifierText) || "Class".equals(qualifierText);
    }

    public static JSCallExpression getAnonymousFunCall(JSFunction function) {
        PsiElement functionParent = function.getParent();
        if (functionParent instanceof JSParenthesizedExpression) {
            functionParent = functionParent.getParent();
        }
        if (!(functionParent instanceof JSCallExpression)) {
            return null;
        }
        return (JSCallExpression)functionParent;
    }

    @Nullable
    public static JSLiteralExpression getParameterInitializationIfRequireArgument(@NotNull JSParameter jsParameter) {
        if (jsParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsParameter", "com/intellij/lang/javascript/index/JSSymbolUtil", "getParameterInitializationIfRequireArgument"));
        }
        JSFunction function = jsParameter.getDeclaringFunction();
        if (function == null) {
            return null;
        }
        Pair<JSLiteralExpression, JSArrayLiteralExpression> requireArguments = JSAmdPsiUtil.getRequireArguments(function);
        if (requireArguments != null) {
            int parameterIndex = JSUtils.findParameterIndex(function, jsParameter);
            if (requireArguments.second != null) {
                JSExpression id = null;
                JSExpression[] expressions = ((JSArrayLiteralExpression)requireArguments.second).getExpressions();
                if (parameterIndex < expressions.length && parameterIndex >= 0) {
                    id = expressions[parameterIndex];
                }
                if (id instanceof JSLiteralExpression) {
                    return (JSLiteralExpression)id;
                }
            }
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult getParameterInitialization(@NotNull JSParameter jsParameter) {
        JSExpression expression;
        JSExpression[] expressions;
        if (jsParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsParameter", "com/intellij/lang/javascript/index/JSSymbolUtil", "getParameterInitialization"));
        }
        JSFunction function = jsParameter.getDeclaringFunction();
        if (function == null) {
            return null;
        }
        JSCallExpression anonymousCallExpr = JSSymbolUtil.getAnonymousFunCall(function);
        if (anonymousCallExpr == null) {
            return null;
        }
        int parameterIndex = JSUtils.findParameterIndex(function, jsParameter);
        JSExpression actualParameter = parameterIndex < (expressions = anonymousCallExpr.getArguments()).length ? expressions[parameterIndex] : null;
        JSNamespaceEvaluationResult result = null;
        if (actualParameter instanceof JSThisExpression) {
            Ref ref = Ref.create();
            result = JSSymbolUtil.evalThis((JSThisExpression)actualParameter, (Ref<JSReferenceExpression>)ref);
            actualParameter = (JSExpression)ref.get();
        }
        if (actualParameter instanceof JSCallExpression && 0 == ((JSCallExpression)actualParameter).getArguments().length && (expression = ((JSCallExpression)actualParameter).getMethodExpression()) instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)expression).getReferencedName())) {
            JSSourceElement[] body;
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            if (qualifier instanceof JSParenthesizedExpression) {
                qualifier = ((JSParenthesizedExpression)qualifier).getInnerExpression();
            }
            if (qualifier instanceof JSFunctionExpression && (body = ((JSFunctionExpression)qualifier).getBody()).length == 1 && body[0] instanceof JSBlockStatement) {
                JSExpression returned;
                JSStatement secondStatement;
                JSStatement firstStatement = (JSStatement)PsiTreeUtil.getChildOfType((PsiElement)body[0], JSStatement.class);
                JSStatement jSStatement = secondStatement = firstStatement != null ? (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)firstStatement, JSStatement.class) : null;
                if (firstStatement != null && secondStatement == null && firstStatement instanceof JSReturnStatement && (returned = ((JSReturnStatement)firstStatement).getExpression()) instanceof JSThisExpression) {
                    JSQualifiedNameImpl windowName = JSQualifiedNameImpl.create("Window", null);
                    result = new JSNamespaceEvaluationResult(windowName, JSContext.INSTANCE, true, false, (JSElement)returned);
                }
            }
        }
        if (actualParameter instanceof JSReferenceExpression) {
            return new JSNamespaceEvaluationResult(null, JSContext.INSTANCE, false, false, (JSElement)actualParameter);
        }
        return result;
    }

    private static String escapeKeyword(String idText, PsiElement context) {
        PsiFile file = context.getContainingFile();
        Language language = file.getLanguage();
        if (!language.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            language = JavascriptLanguage.INSTANCE;
        }
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).createLexer(context.getProject());
        lexer.start((CharSequence)idText);
        if (JSTokenTypes.KEYWORDS.contains(lexer.getTokenType()) && lexer.getTokenEnd() == idText.length()) {
            idText = "_" + idText;
        }
        return idText;
    }

    private static String calcPackage(PsiFile file) {
        VirtualFile dir;
        VirtualFile curdir;
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)file.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        if ((curdir = JSModuleReference.calcRoot(dir = virtualFile.getParent())) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)curdir, (char)'.');
        }
        return "";
    }

    public static boolean isExportReference(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/index/JSSymbolUtil", "isExportReference"));
        }
        if (JSSymbolUtil.isExplicitExportReference((JSExpression)referenceExpression)) {
            return true;
        }
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        JSElement element = JSSymbolUtil.calcRefExprValue(referenceExpression);
        if (element != referenceExpression && element instanceof JSReferenceExpression) {
            return JSSymbolUtil.isExplicitExportReference((JSExpression)((JSReferenceExpression)element));
        }
        return false;
    }

    public static boolean isExplicitExportReference(JSExpression reference) {
        if (reference instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)reference;
            String referencedName = referenceExpression.getReferencedName();
            JSExpression qualifier = referenceExpression.getQualifier();
            return EXPORTS.equals(referencedName) && (qualifier == null || qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null && MODULE.equals(((JSReferenceExpression)qualifier).getReferencedName()));
        }
        return false;
    }

    @Nullable
    public static JSType evaluateModuleInnerAlias(JSFunction moduleInitializer, String functionNs) {
        ASTNode returnStatementNode;
        JSType returnType = moduleInitializer.getReturnType();
        if (returnType != null) {
            return returnType;
        }
        JSSourceElement[] body = moduleInitializer.getBody();
        if (body.length > 0 && (returnStatementNode = body[0].getNode().findChildByType((IElementType)JSElementTypes.RETURN_STATEMENT)) != null) {
            JSExpression returnExpression = ((JSReturnStatement)returnStatementNode.getPsi()).getExpression();
            JSTypeContext staticOrInstance = JSTypeContext.STATIC;
            JSReferenceExpression referenceExpression = null;
            if (returnExpression instanceof JSNewExpression) {
                JSExpression methodExpression = ((JSNewExpression)returnExpression).getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression) {
                    referenceExpression = (JSReferenceExpression)methodExpression;
                    staticOrInstance = JSTypeContext.INSTANCE;
                }
            } else if (returnExpression instanceof JSReferenceExpression) {
                referenceExpression = (JSReferenceExpression)returnExpression;
            }
            if (referenceExpression != null) {
                return JSSymbolUtil.createTypeFromReferenceExpression(referenceExpression, staticOrInstance);
            }
            if (returnExpression instanceof JSObjectLiteralExpression) {
                return JSNamedType.createType(functionNs, JSTypeSource.EMPTY, staticOrInstance);
            }
        }
        return null;
    }

    public static JSContext getContext(@NotNull JSElement element) {
        JSExpression qualifier;
        JSExpression expression;
        JSExpression lOperand;
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSSymbolUtil", "getContext"));
        }
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributes = ((JSAttributeListOwner)element).getAttributeList();
            if (attributes != null && attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                return JSContext.STATIC;
            }
            PsiElement parent2 = JSResolveUtil.findParent((PsiElement)element);
            if (parent2 instanceof TypeScriptEnum || parent2 instanceof TypeScriptModule) {
                return JSContext.STATIC;
            }
            if (parent2 instanceof JSClass) {
                return JSContext.INSTANCE;
            }
        }
        if (element instanceof JSFunctionExpression && (parent = element.getParent()) instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) != null) {
            element = lOperand;
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() != null && "prototype".equals(((JSReferenceExpression)qualifier).getReferencedName())) {
            return JSContext.INSTANCE;
        }
        if (element instanceof TypeScriptTypeMember && JSSymbolUtil.isInInterface((TypeScriptTypeMember)element)) {
            return JSContext.INSTANCE;
        }
        JSContext context = JSDocumentationUtils.findJSContext((PsiElement)element);
        if (element instanceof JSProperty && context == JSContext.UNKNOWN) {
            return JSDocumentationUtils.findJSContext(element.getParent());
        }
        return context;
    }

    private static boolean isInInterface(TypeScriptTypeMember typeMember) {
        return typeMember.getParent().getParent() instanceof TypeScriptInterface;
    }

    @Nullable
    public static String getIndexedPropertyName(@NotNull JSIndexedPropertyAccessExpression expr) {
        JSFunction function;
        PsiElement ref;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/index/JSSymbolUtil", "getIndexedPropertyName"));
        }
        JSExpression indexExpression = expr.getIndexExpression();
        if (indexExpression instanceof JSReferenceExpression && (ref = JSResolveUtil.getLocalVariableRef(function = JSPsiImplUtils.getScopeFunction((JSElement)expr), (JSReferenceExpression)indexExpression)) instanceof JSVariable && !(JSResolveUtil.findParent(ref) instanceof JSLoopStatement)) {
            indexExpression = ((JSVariable)ref).getInitializer();
        }
        if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral()) {
            return StringUtil.stripQuotesAroundValue((String)indexExpression.getText());
        }
        return null;
    }

    @Nullable
    public static JSSymbolNamespace findNamespace(@NotNull JSExpression expression) {
        JSFunction function;
        String name;
        PsiElement parent;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSSymbolUtil", "findNamespace"));
        }
        PsiElement returnStatementToCheck = parent = expression.getParent();
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)expression);
        if (docComment instanceof JSDocComment) {
            JSDocComment comment = (JSDocComment)docComment;
            JSQualifiedName namespace = comment.getNamespace();
            name = comment.getExplicitName();
            if (name != null) {
                JSContext context = comment.getJSContext();
                return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.create(name, namespace), context, true, true);
            }
        }
        if (parent instanceof JSVariable) {
            JSVariable jsVariable = (JSVariable)parent;
            return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)jsVariable), JSContext.STATIC, jsVariable.isNamespaceExplicitlyDeclared(), true);
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == expression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression) {
                return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSDefinitionExpression)lOperand)));
            }
        } else {
            PsiElement grandParent;
            if (parent instanceof JSProperty) {
                return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSProperty)parent)));
            }
            if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression) {
                JSElement qualifyingExpression = JSSymbolUtil.findQualifyingExpressionFromArgumentList((JSArgumentList)parent);
                JSNamespaceEvaluationResult localNs = null;
                if (qualifyingExpression instanceof JSReferenceExpression) {
                    JSNamespaceEvaluationResult nsResult = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifyingExpression);
                    if (nsResult != null) {
                        localNs = nsResult.withJSContext(JSContext.UNKNOWN);
                        qualifyingExpression = null;
                    }
                } else if (qualifyingExpression instanceof JSVariable) {
                    JSElement element;
                    name = qualifyingExpression.getName();
                    if (name != null && (element = JSSymbolUtil.calcRefExprValue(name, qualifyingExpression)) instanceof JSReferenceExpression) {
                        qualifyingExpression = element;
                    }
                } else if (qualifyingExpression == null) {
                    if (grandParent.getParent() instanceof JSReturnStatement) {
                        returnStatementToCheck = grandParent.getParent();
                    } else {
                        String name2;
                        PsiComment callExpressionDocComment = JSDocumentationUtils.findDocComment(grandParent);
                        if (callExpressionDocComment instanceof JSDocComment && (name2 = ((JSDocComment)callExpressionDocComment).getExplicitName()) != null && ((JSDocComment)callExpressionDocComment).isClassExplicitly()) {
                            return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.create(name2, ((JSDocComment)callExpressionDocComment).getNamespace()));
                        }
                    }
                }
                if (qualifyingExpression != null) {
                    String s = JSContextResolver.getQualifierOfExprAsString(qualifyingExpression);
                    if (s != null) {
                        return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(s));
                    }
                } else if (localNs != null) {
                    return localNs;
                }
            } else {
                if (parent instanceof JSParenthesizedExpression) {
                    return JSSymbolUtil.findNamespace((JSExpression)((JSParenthesizedExpression)parent));
                }
                if (parent instanceof JSBinaryExpression) {
                    IElementType sign = ((JSBinaryExpression)parent).getOperationSign();
                    if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND) {
                        return JSSymbolUtil.findNamespace((JSExpression)((JSBinaryExpression)parent));
                    }
                } else if (parent instanceof JSConditionalExpression) {
                    return JSSymbolUtil.findNamespace((JSExpression)((JSConditionalExpression)parent));
                }
            }
        }
        if (returnStatementToCheck instanceof JSReturnStatement && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)returnStatementToCheck, JSFunction.class)) != null) {
            JSQualifiedName amdNamespace = JSAmdPsiUtil.getNamespaceForAmdModuleElements(function);
            if (amdNamespace != null) {
                return new JSSymbolNamespaceImpl(amdNamespace);
            }
            PsiElement call = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)function);
            if (call instanceof JSCallExpression) {
                return JSSymbolUtil.findNamespace((JSExpression)call);
            }
        }
        return null;
    }

    public static boolean isValidPropertyName(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/index/JSSymbolUtil", "isValidPropertyName"));
        }
        return StringUtil.isJavaIdentifier((String)s);
    }

    public static interface PropertyProcessor {
        public void process(String var1, JSProperty var2);
    }

    static interface ReferenceExpressionProcessor {
        public void processExpression(JSReferenceExpression var1);

        public void processUnresolvedThis();

        public boolean isTopLevel(JSReferenceExpression var1);
    }
}

