/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileContent;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        String string = TypeScriptFileType.INSTANCE.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "getId"));
        }
        return string;
    }

    public boolean acceptFile(VirtualFile file) {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        for (FileType type : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
            fileTypeSink.consume((Object)type);
        }
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        JSFile file = (JSFile)ObjectUtils.tryCast((Object)content.getPsiFile(), JSFile.class);
        if (file == null) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        FileIncludeInfo[] fileIncludeInfoArray = TypeScriptFileIncludeProvider.buildFileIncludeInfo(file.getReferencedPaths(), file.getImportReferences().values());
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }

    @NotNull
    private static FileIncludeInfo[] buildFileIncludeInfo(Collection<String> ... collections) {
        int totalSize = 0;
        for (Collection<String> collection : collections) {
            totalSize += collection.size();
        }
        if (totalSize == 0) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "buildFileIncludeInfo"));
            }
            return FileIncludeInfo.EMPTY;
        }
        THashSet refSet = new THashSet(totalSize);
        for (Collection<String> collection : collections) {
            refSet.addAll(collection);
        }
        FileIncludeInfo[] result = new FileIncludeInfo[refSet.size()];
        int i = 0;
        for (String ref : refSet) {
            String path = TypeScriptFileIncludeProvider.normalizePath(ref);
            result[i] = new FileIncludeInfo(path);
            ++i;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "buildFileIncludeInfo"));
        }
        return result;
    }

    @NotNull
    private static String normalizePath(@NotNull String ref) {
        boolean addSuffix;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "normalizePath"));
        }
        String path = FileUtil.toSystemIndependentName((String)StringUtil.unquoteString((String)ref));
        boolean addPrefix = !path.startsWith("./") && !path.startsWith("../") && !FileUtil.isAbsolutePlatformIndependent((String)path);
        boolean bl = addSuffix = !FileUtilRt.extensionEquals((String)path, (String)"ts");
        if (!addPrefix && !addSuffix) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "normalizePath"));
            }
            return string;
        }
        StringBuilder buf = new StringBuilder(2 + path.length() + 3);
        if (addPrefix) {
            buf.append("./");
        }
        buf.append(path);
        if (addSuffix) {
            buf.append(".").append("ts");
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "normalizePath"));
        }
        return string;
    }

    public int getVersion() {
        return 1;
    }
}

