/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.flags;

import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.util.SmartList;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class EnumSetStructureElement<T extends Enum<T>>
extends FlagsStructureElement<EnumSet<T>> {
    private final Class<T> myEnumClass;

    public EnumSetStructureElement(Class<T> enumClass) {
        super(((Enum[])enumClass.getEnumConstants()).length);
        assert (((Enum[])enumClass.getEnumConstants()).length < 32) : "getObject/getValue are ints";
        this.myEnumClass = enumClass;
    }

    @Override
    @NotNull
    public EnumSet<T> getObject(int value) {
        SmartList list = new SmartList();
        Enum[] constants = (Enum[])this.myEnumClass.getEnumConstants();
        for (int i = 0; i < constants.length; ++i) {
            if ((value & 1 << i) == 0) continue;
            list.add((Object)constants[i]);
        }
        EnumSet<Object> enumSet = list.isEmpty() ? EnumSet.noneOf(this.myEnumClass) : EnumSet.copyOf(list);
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/flags/EnumSetStructureElement", "getObject"));
        }
        return enumSet;
    }

    @Override
    public int getValue(EnumSet<T> object) {
        int result = 0;
        Enum[] constants = (Enum[])this.myEnumClass.getEnumConstants();
        for (int i = 0; i < constants.length; ++i) {
            if (!object.contains(constants[i])) continue;
            result |= 1 << i;
        }
        return result;
    }
}

