/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.flags;

import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class IntFlagsSerializer {
    public static IntFlagsSerializer INSTANCE = new IntFlagsSerializer();

    private IntFlagsSerializer() {
    }

    @Contract(pure=true)
    public <T> int writeValue(@NotNull FlagsStructure structure, @NotNull FlagsStructureElement<T> structureElement, T value, int flags) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/index/flags/IntFlagsSerializer", "writeValue"));
        }
        if (structureElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureElement", "com/intellij/lang/javascript/index/flags/IntFlagsSerializer", "writeValue"));
        }
        int offset = 0;
        for (FlagsStructureElement element : structure.getElements()) {
            if (element == structureElement) {
                int intValue = structureElement.getValue(value);
                int mask = (1 << structureElement.size()) - 1 << offset;
                return flags & ~mask | (intValue <<= offset);
            }
            offset += element.size();
        }
        throw new IllegalArgumentException("structureElement was not found in its container");
    }

    @Contract(pure=true)
    public <T> T readValue(@NotNull FlagsStructure structure, @NotNull FlagsStructureElement<T> structureElement, int flags) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/index/flags/IntFlagsSerializer", "readValue"));
        }
        if (structureElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureElement", "com/intellij/lang/javascript/index/flags/IntFlagsSerializer", "readValue"));
        }
        int offset = 0;
        for (FlagsStructureElement element : structure.getElements()) {
            if (element == structureElement) {
                int intValue = flags >> offset & (1 << structureElement.size()) - 1;
                return structureElement.getObject(intValue);
            }
            offset += element.size();
        }
        throw new IllegalArgumentException("structureElement was not found in its container");
    }
}

