/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.fixes.ImplementJSDocMethodsFix;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSClosureCompilerSyntaxInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.closure.compiler.syntax.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDocComment(final JSDocComment docComment) {
                if (!DialectDetector.isJavaScript((PsiElement)docComment)) {
                    return;
                }
                final PsiElement errorElement = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                THashSet commentInterfaces = new THashSet();
                JSDocTag[] tags = docComment.getTags();
                boolean hasImplements = false;
                boolean hasExtends = false;
                for (JSDocTag tag : tags) {
                    JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
                    if (docTag == null) continue;
                    if (docTag.type == JSDocumentationProcessor.MetaDocType.IMPLEMENTS) {
                        hasImplements = true;
                        JSDocTagValue tagValue = tag.getValue();
                        if (tagValue == null) continue;
                        JSType type = JSTypeUtils.createType(docTag.matchName, JSTypeSource.EMPTY);
                        if (type instanceof JSGenericTypeImpl) {
                            type = ((JSGenericTypeImpl)type).getType();
                        }
                        if (type instanceof JSTypeImpl && JSSymbolUtil.isInterface(type.getTypeText(JSType.TypeTextFormat.SIMPLE), (PsiElement)docComment)) {
                            commentInterfaces.add(docTag.matchName);
                            continue;
                        }
                        holder.registerProblem((PsiElement)tagValue, JSBundle.message((String)"js.closure.compiler.syntax.implements.not.interface", (Object[])new Object[]{docTag.matchName}), new LocalQuickFix[0]);
                        continue;
                    }
                    if (docTag.type == JSDocumentationProcessor.MetaDocType.EXTENDS) {
                        hasExtends = true;
                        continue;
                    }
                    this.checkTypeInDocTag(tag, docTag);
                }
                final String className = JSDocumentationUtils.findNameOfClassAppliedTo((PsiComment)docComment);
                if (className != null && (hasImplements || hasExtends)) {
                    OrderedSet implementedInterfaces = new OrderedSet();
                    THashSet classesInHierarchy = new THashSet();
                    classesInHierarchy.add(className);
                    JSTypeEvaluateManager.iterateTypeHierarchy((PsiElement)docComment, Collections.singleton(className), false, new JSTypeEvaluateManager.NamespaceProcessor((Set)commentInterfaces, implementedInterfaces, (Set)classesInHierarchy){
                        final /* synthetic */ Set val$commentInterfaces;
                        final /* synthetic */ OrderedSet val$implementedInterfaces;
                        final /* synthetic */ Set val$classesInHierarchy;
                        {
                            this.val$commentInterfaces = set;
                            this.val$implementedInterfaces = orderedSet;
                            this.val$classesInHierarchy = set2;
                        }

                        @Override
                        public boolean process(String serializedType, VirtualFile file) {
                            String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                            if (className.equals(qName)) {
                                holder.registerProblem((PsiElement)(errorElement != null ? errorElement : docComment), JSBundle.message((String)"js.closure.compiler.syntax.cyclic.inheritance", (Object[])new Object[]{className}), new LocalQuickFix[0]);
                            } else if (this.val$commentInterfaces.contains(qName) || JSSymbolUtil.isInterface(qName, (PsiElement)docComment)) {
                                this.val$implementedInterfaces.add((Object)qName);
                            } else {
                                this.val$classesInHierarchy.add(qName);
                            }
                            return true;
                        }
                    });
                    if (!JSSymbolUtil.isInterface(className, (PsiElement)docComment)) {
                        JSClosureCompilerSyntaxInspection.processUnimplementedMethods(className, (PsiElement)(errorElement != null ? errorElement : docComment), (OrderedSet<String>)implementedInterfaces, (Set)classesInHierarchy, holder);
                    }
                }
            }

            private void checkTypeInDocTag(@NotNull JSDocTag psiTag, JSDocumentationUtils.DocTag tag) {
                if (psiTag == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTag", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection$1", "checkTypeInDocTag"));
                }
                String type = tag.type == JSDocumentationProcessor.MetaDocType.TYPE || tag.type == JSDocumentationProcessor.MetaDocType.ENUM || tag.type == JSDocumentationProcessor.MetaDocType.TYPEDEF || tag.type == JSDocumentationProcessor.MetaDocType.EXTENDS || tag.type == JSDocumentationProcessor.MetaDocType.IMPLEMENTS || tag.type == JSDocumentationProcessor.MetaDocType.RETURN || tag.type == JSDocumentationProcessor.MetaDocType.THIS || tag.type == JSDocumentationProcessor.MetaDocType.LENDS || tag.type == JSDocumentationProcessor.MetaDocType.MIXIN || tag.type == JSDocumentationProcessor.MetaDocType.MIXES || tag.type == JSDocumentationProcessor.MetaDocType.THROWS ? tag.matchName : (tag.type == JSDocumentationProcessor.MetaDocType.PARAMETER || tag.type == JSDocumentationProcessor.MetaDocType.PROPERTY ? tag.matchValue : null);
                JSDocTagValue value = psiTag.getValue();
                if (value != null && type != null) {
                    if (type.trim().isEmpty()) {
                        holder.registerProblem((PsiElement)value, JSBundle.message((String)"js.closure.compiler.syntax.empty.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else {
                        boolean parsedCorrectly;
                        boolean bl = tag.type == JSDocumentationProcessor.MetaDocType.PARAMETER ? new JSTypeParser(type, JSTypeSource.EMPTY).parseParameterType() != null : (parsedCorrectly = new JSTypeParser(type, JSTypeSource.EMPTY).parse() != null);
                        if (!parsedCorrectly) {
                            holder.registerProblem((PsiElement)value, JSBundle.message((String)"js.closure.compiler.syntax.invalid.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            public void visitJSNewExpression(JSNewExpression node) {
                super.visitJSNewExpression(node);
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSExpression expression = node.getMethodExpression();
                if (expression instanceof JSReferenceExpression && JSSymbolUtil.isInterface(expression.getText(), (PsiElement)expression)) {
                    holder.registerProblem((PsiElement)expression, JSBundle.message((String)"javascript.interface.can.not.be.instantiated.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitJSParameterList(JSParameterList node) {
                DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
                if (dialect == null || dialect.isECMA6 || !dialect.isJavaScript()) {
                    return;
                }
                boolean foundRest = false;
                for (JSParameter parameter : node.getParameters()) {
                    if (parameter.isRest()) {
                        foundRest = true;
                        continue;
                    }
                    if (!foundRest) continue;
                    holder.registerProblem((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void processUnimplementedMethods(@NotNull String classQName, @NotNull PsiElement errorElement, OrderedSet<String> implementedInterfaces, Set<String> classesInHierarchy, ProblemsHolder holder) {
        JSSourceElement parent;
        String methodToImplement;
        if (classQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classQName", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection", "processUnimplementedMethods"));
        }
        if (errorElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorElement", "com/intellij/lang/javascript/inspections/JSClosureCompilerSyntaxInspection", "processUnimplementedMethods"));
        }
        THashMap methodsToImplement = new THashMap();
        ArrayList<String> implementedMethods = new ArrayList<String>(3);
        THashMap abstractMethodsToImplement = new THashMap();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(errorElement);
        for (String baseClassName : classesInHierarchy) {
            for (JSPsiElementBase member : JSClassResolver.getInstance().findNamespaceMembers(baseClassName, scope)) {
                if (member.getJSContext() == JSContext.STATIC) continue;
                JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)member);
                if (docComment != null && docComment.hasAbstractTag()) {
                    if (classQName.equals(baseClassName)) continue;
                    abstractMethodsToImplement.put(member.getName(), baseClassName);
                    continue;
                }
                implementedMethods.add(member.getName());
            }
        }
        for (Iterator implementedInterface : implementedInterfaces) {
            for (JSPsiElementBase member : JSClassResolver.getInstance().findNamespaceMembers((String)((Object)implementedInterface), scope)) {
                if (member.getJSContext() != JSContext.INSTANCE) continue;
                methodsToImplement.put(member.getName(), implementedInterface);
            }
        }
        ArrayList<Trinity> notImplemented = new ArrayList<Trinity>(3);
        for (Map.Entry entry : methodsToImplement.entrySet()) {
            methodToImplement = (String)entry.getKey();
            if (implementedMethods.contains(methodToImplement)) continue;
            notImplemented.add(Trinity.create((Object)true, entry.getValue(), (Object)methodToImplement));
        }
        for (Map.Entry entry : abstractMethodsToImplement.entrySet()) {
            methodToImplement = (String)entry.getKey();
            if (implementedMethods.contains(methodToImplement)) continue;
            notImplemented.add(Trinity.create((Object)false, entry.getValue(), (Object)methodToImplement));
        }
        if (!notImplemented.isEmpty() && (parent = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)errorElement, JSSourceElement.class, (boolean)false)) != null) {
            THashSet notImplementedNames = new THashSet();
            for (int i = 0; i < notImplemented.size(); ++i) {
                PsiElement nameIdentifier;
                LocalQuickFix[] fix;
                LocalQuickFix[] localQuickFixArray;
                Trinity trinity = (Trinity)notImplemented.get(i);
                String notImplementedName = (String)trinity.third;
                notImplementedNames.add((Object)notImplementedName);
                String key = (Boolean)trinity.first != false ? "javascript.validation.message.interface.method.not.implemented" : "javascript.validation.message.abstract.method.not.implemented";
                String message = JSBundle.message((String)key, (Object[])new Object[]{notImplementedName, trinity.second});
                if (i == notImplemented.size() - 1) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new ImplementJSDocMethodsFix(parent, classQName, (Set<String>)notImplementedNames);
                } else {
                    localQuickFixArray = fix = LocalQuickFix.EMPTY_ARRAY;
                }
                if (errorElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)errorElement).getNameIdentifier()) != null) {
                    errorElement = nameIdentifier;
                }
                holder.registerProblem(errorElement, message, fix);
            }
        }
    }
}

