/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSDeprecatedSymbolsInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.deprecated.symbols.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                PsiElement resolve = node.resolve();
                if (resolve == null) {
                    return;
                }
                if (JSResolveUtil.isSameReference(node, resolve)) {
                    return;
                }
                if (JSDocumentationUtils.isDeprecated(resolve)) {
                    String message = null;
                    LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                    if (resolve instanceof JSAttributeListOwner && JSPsiImplUtils.isDeprecatedFromAttribute((JSAttributeListOwner)resolve)) {
                        String replacementString;
                        if ("caller".equals(node.getReferencedName()) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                            return;
                        }
                        JSAttribute attribute = ((JSAttributeListOwner)resolve).getAttributeList().findAttributeByName("Deprecated");
                        JSAttributeNameValuePair since = attribute.getValueByName("since");
                        JSAttributeNameValuePair replacement = attribute.getValueByName("replacement");
                        String string = replacementString = replacement != null ? replacement.getSimpleValue() : "unknown";
                        if (since != null || replacement != null) {
                            message = JSBundle.message((String)"javascript.deprecated.symbol.used.name.message2", (Object[])new Object[]{since != null ? since.getSimpleValue() : "unknown", replacementString});
                        } else {
                            JSAttributeNameValuePair messageAttr = attribute.getValueByName("message");
                            if (messageAttr != null && (message = messageAttr.getSimpleValue()) != null && message.trim().length() == 0) {
                                message = null;
                            }
                        }
                        if (replacement != null) {
                            fixes = new LocalQuickFix[]{new LocalQuickFix(){

                                @NotNull
                                public String getName() {
                                    String string = JSBundle.message((String)"javascript.deprecated.symbol.replace.fix", (Object[])new Object[]{replacementString});
                                    if (string == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1", "getName"));
                                    }
                                    return string;
                                }

                                @NotNull
                                public String getFamilyName() {
                                    String string = JSBundle.message((String)"javascript.deprecated.symbol.replace.fix.family", (Object[])new Object[0]);
                                    if (string == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1", "getFamilyName"));
                                    }
                                    return string;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                    if (project == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1", "applyFix"));
                                    }
                                    if (descriptor == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1", "applyFix"));
                                    }
                                    PsiElement psiElement = descriptor.getPsiElement();
                                    PsiElement grandParent = (psiElement = psiElement.getParent()).getParent();
                                    if (grandParent instanceof JSCallExpression) {
                                        psiElement = grandParent;
                                    }
                                    ((Navigatable)psiElement).navigate(false);
                                    PsiElement finalPsiElement = psiElement;
                                    AccessToken l = WriteAction.start();
                                    try {
                                        ASTNode newElement = JSChangeUtil.createJSTreeFromText(project, replacementString, (JSLanguageDialect)finalPsiElement.getContainingFile().getLanguage());
                                        if (newElement != null) {
                                            finalPsiElement.replace(newElement.getPsi());
                                        }
                                    }
                                    finally {
                                        l.finish();
                                    }
                                }
                            }};
                        }
                    }
                    if (message == null) {
                        message = JSBundle.message((String)"javascript.deprecated.symbol.used.name.message", (Object[])new Object[0]);
                    }
                    holder.registerProblem(node.getReferenceNameElement(), message, ProblemHighlightType.LIKE_DEPRECATED, fixes);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

