/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMoveToScopeStartIntentionAction
implements LocalQuickFix {
    private final boolean myMakeSingleVarStatement;
    @NonNls
    private static final String VAR_STATEMENT_START = "var ";

    public JSMoveToScopeStartIntentionAction(boolean makeSingleVarStatement) {
        this.myMakeSingleVarStatement = makeSingleVarStatement;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"js.move.to.scope.start", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction", "applyFix"));
        }
        JSVarStatement varStatement = (JSVarStatement)descriptor.getPsiElement();
        PsiFile file = varStatement.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        StringBuilder assignments = new StringBuilder();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        JSVariable previousVar = null;
        for (JSVariable jsVariable : varStatement.getVariables()) {
            if (jsVariable.hasInitializer()) {
                if (previousVar != null) {
                    assignments.append(document.getText(new TextRange(previousVar.getTextRange().getEndOffset(), jsVariable.getTextRange().getStartOffset())));
                }
                assignments.append(jsVariable.getText());
            }
            previousVar = jsVariable;
        }
        if (varStatement.getNode().findChildByType(JSTokenTypes.SEMICOLON) != null && assignments.length() > 0) {
            assignments.append(";");
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)varStatement, JSFunction.class);
        JSStatement anchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)varStatement);
        if (anchor == null) {
            return;
        }
        StringBuilder declarations = this.myMakeSingleVarStatement && anchor instanceof JSVarStatement ? JSMoveToScopeStartIntentionAction.buildDeclarations(", ", varStatement) : JSMoveToScopeStartIntentionAction.buildDeclarations(VAR_STATEMENT_START, varStatement);
        if (assignments.length() > 0) {
            document.replaceString(varStatement.getTextRange().getStartOffset(), varStatement.getTextRange().getEndOffset(), (CharSequence)assignments);
        } else {
            FormatFixer ff = FormatFixer.create((PsiElement)varStatement, FormatFixer.Mode.FirstLinebreak);
            varStatement.delete();
            ff.fixFormat();
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        anchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)function);
        if (this.myMakeSingleVarStatement && anchor instanceof JSVarStatement) {
            JSVarStatement firstVarStatement = (JSVarStatement)anchor;
            JSVariable[] variables = firstVarStatement.getVariables();
            JSVariable lastVar = variables[variables.length - 1];
            int endOffset = lastVar.getTextRange().getEndOffset();
            document.insertString(endOffset, (CharSequence)declarations);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        } else if (anchor != null) {
            declarations.append(";\n");
            ASTNode varStatementNode = JSChangeUtil.createStatementFromText(project, declarations.toString());
            anchor.getParent().addBefore(varStatementNode.getPsi(), (PsiElement)anchor);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
    }

    private static StringBuilder buildDeclarations(String prefix, JSVarStatement varStatement) {
        StringBuilder declarations = new StringBuilder(prefix);
        boolean firstVar = true;
        for (JSVariable jsVariable : varStatement.getVariables()) {
            if (!firstVar) {
                declarations.append(", ");
            } else {
                firstVar = false;
            }
            declarations.append(jsVariable.getName());
            String typeString = jsVariable.getTypeString();
            if (typeString == null) continue;
            declarations.append(":");
            declarations.append(typeString);
        }
        return declarations;
    }
}

